# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.table
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing
from ..util.color import Color as Color_68e908c5


class BorderLine(object):
    """
    Struct Class

    describes the line type for a single cell edge.

    See Also:
        `API BorderLine <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1table_1_1BorderLine.html>`_
    """
    typeName: Literal['com.sun.star.table.BorderLine']

    def __init__(self, Color: typing.Optional[Color_68e908c5] = ..., InnerLineWidth: typing.Optional[int] = ..., OuterLineWidth: typing.Optional[int] = ..., LineDistance: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            Color (Color, optional): Color value.
            InnerLineWidth (int, optional): InnerLineWidth value.
            OuterLineWidth (int, optional): OuterLineWidth value.
            LineDistance (int, optional): LineDistance value.
        """


    @property
    def Color(self) -> Color_68e908c5:
        """
        contains the color value of the line.
        """


    @property
    def InnerLineWidth(self) -> int:
        """
        contains the width of the inner part of a double line (in 1/100 mm).
        
        If this value is zero, only a single line is drawn.
        """


    @property
    def OuterLineWidth(self) -> int:
        """
        contains the width of a single line or the width of outer part of a double line (in 1/100 mm).
        
        If this value is zero, no line is drawn.
        """


    @property
    def LineDistance(self) -> int:
        """
        contains the distance between the inner and outer parts of a double line (in 1/100 mm).
        """



__all__ = ['BorderLine']
