# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.sheet
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing


class SingleReference(object):
    """
    Struct Class

    contains a reference to a single cell.

    See Also:
        `API SingleReference <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1sheet_1_1SingleReference.html>`_
    """
    typeName: Literal['com.sun.star.sheet.SingleReference']

    def __init__(self, Column: typing.Optional[int] = ..., RelativeColumn: typing.Optional[int] = ..., Row: typing.Optional[int] = ..., RelativeRow: typing.Optional[int] = ..., Sheet: typing.Optional[int] = ..., RelativeSheet: typing.Optional[int] = ..., Flags: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            Column (int, optional): Column value.
            RelativeColumn (int, optional): RelativeColumn value.
            Row (int, optional): Row value.
            RelativeRow (int, optional): RelativeRow value.
            Sheet (int, optional): Sheet value.
            RelativeSheet (int, optional): RelativeSheet value.
            Flags (int, optional): Flags value.
        """


    @property
    def Column(self) -> int:
        """
        is the absolute column number.
        """


    @property
    def RelativeColumn(self) -> int:
        """
        is the relative column number.
        """


    @property
    def Row(self) -> int:
        """
        is the absolute row number.
        """


    @property
    def RelativeRow(self) -> int:
        """
        is the relative row number.
        """


    @property
    def Sheet(self) -> int:
        """
        is the absolute sheet number.
        """


    @property
    def RelativeSheet(self) -> int:
        """
        is the relative sheet number.
        """


    @property
    def Flags(self) -> int:
        """
        contains flags.
        """



__all__ = ['SingleReference']
