# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.sheet
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing
from .data_pilot_field_filter import DataPilotFieldFilter as DataPilotFieldFilter_271e0eed
from .data_result import DataResult as DataResult_a47d0b1a


class DataPilotTableResultData(object):
    """
    Struct Class

    information about a cell positioned within the result area of a DataPilot table.
    
    DataPilotTableResultData contains information about a particular cell positioned within the result area of a DataPilot table.
    
    **since**
    
        OOo 3.0

    See Also:
        `API DataPilotTableResultData <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1sheet_1_1DataPilotTableResultData.html>`_
    """
    typeName: Literal['com.sun.star.sheet.DataPilotTableResultData']

    def __init__(self, FieldFilters: typing.Optional[typing.Tuple[DataPilotFieldFilter_271e0eed, ...]] = ..., DataFieldIndex: typing.Optional[int] = ..., Result: typing.Optional[DataResult_a47d0b1a] = ...) -> None:
        """
        Constructor

        Arguments:
            FieldFilters (typing.Tuple[DataPilotFieldFilter, ...], optional): FieldFilters value.
            DataFieldIndex (int, optional): DataFieldIndex value.
            Result (DataResult, optional): Result value.
        """


    @property
    def FieldFilters(self) -> typing.Tuple[DataPilotFieldFilter_271e0eed, ...]:
        """
        This is a set of filter criteria that can be used to re-create those data rows that contribute to the value shown in the cell.
        """


    @property
    def DataFieldIndex(self) -> int:
        """
        This is a 0-based index that specifies which data field the data displayed in the cell is for; the value of 0 means the cell is for the first data field, 1 for the second, and so on.
        """


    @property
    def Result(self) -> DataResult_a47d0b1a:
        """
        more information about the result contained in the DataResult type.
        """



__all__ = ['DataPilotTableResultData']
