# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Exception Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.security
# Libre Office Version: 7.2
from typing_extensions import Literal
from ooo.oenv.env_const import UNO_NONE
import typing
from ..uno.security_exception import SecurityException as SecurityException_e4950d61
from ..uno.x_interface import XInterface as XInterface_8f010a43

class AccessControlException(SecurityException_e4950d61):
    """
    Exception Class

    Exception notifying a lacking permission to access data or execute code thus it is thrown if permission ought to be denied.
    
    **since**
    
        OOo 1.1.2

    See Also:
        `API AccessControlException <https://api.libreoffice.org/docs/idl/ref/exceptioncom_1_1sun_1_1star_1_1security_1_1AccessControlException.html>`_
    """

    typeName: Literal['com.sun.star.security.AccessControlException']

    def __init__(self, Message: typing.Optional[str] = ..., Context: typing.Optional[XInterface_8f010a43] = ..., LackingPermission: typing.Optional[object] = ...) -> None:
        """
        Constructor

        Arguments:
            Message (str, optional): Message value.
            Context (XInterface, optional): Context value.
            LackingPermission (object, optional): LackingPermission value.
        """
    @property
    def LackingPermission(self) -> object:
        """
        lacking permission.
        """


__all__ = ['AccessControlException']

