# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.reflection
from typing_extensions import Literal
import typing
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .x_type_description import XTypeDescription as XTypeDescription_3c210fb1

class XMethodParameter(XInterface_8f010a43):
    """
    Reflects a method parameter.
    
    This type is superseded by XParameter, which supports parameters of service constructors as well as parameters of interface methods.

    See Also:
        `API XMethodParameter <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1reflection_1_1XMethodParameter.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.reflection.XMethodParameter']

    def getName(self) -> str:
        """
        Returns the name of the parameter.
        """
    def getPosition(self) -> int:
        """
        Returns the position of the parameter regarding the IDL method declaration.
        """
    def getType(self) -> 'XTypeDescription_3c210fb1':
        """
        Returns the type of the parameter.
        """
    def isIn(self) -> bool:
        """
        Returns true, if the parameter is declared as [in] or [inout] in IDL.
        """
    def isOut(self) -> bool:
        """
        Returns true, if the parameter is declared as [out] or [inout] in IDL.
        """

__all__ = ['XMethodParameter']

