# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.io
from typing_extensions import Literal
import typing
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .x_active_data_source import XActiveDataSource as XActiveDataSource_d1900c7f
    from .x_data_transfer_event_listener import XDataTransferEventListener as XDataTransferEventListener_54d6103f
    from ..lang.x_component import XComponent as XComponent_98dc0ab5

class XDataImporter(XInterface_8f010a43):
    """
    makes it possible to import data from a data source into a component.
    
    Importer objects are registered for specific components and data types.

    See Also:
        `API XDataImporter <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1io_1_1XDataImporter.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.io.XDataImporter']

    def cancel(self) -> None:
        """
        cancels the import process.
        """
    def importData(self, aActiveSource: 'XActiveDataSource_d1900c7f', Component: 'XComponent_98dc0ab5', aListener: 'XDataTransferEventListener_54d6103f') -> None:
        """
        imports data for a component from an active data source.
        """

__all__ = ['XDataImporter']

