# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.i18n
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing


class ParseResult(object):
    """
    Struct Class

    Parser results returned by XCharacterClassification.parseAnyToken() and XCharacterClassification.parsePredefinedToken().

    See Also:
        `API ParseResult <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1i18n_1_1ParseResult.html>`_
    """
    typeName: Literal['com.sun.star.i18n.ParseResult']

    def __init__(self, LeadingWhiteSpace: typing.Optional[int] = ..., EndPos: typing.Optional[int] = ..., CharLen: typing.Optional[int] = ..., Value: typing.Optional[float] = ..., TokenType: typing.Optional[int] = ..., StartFlags: typing.Optional[int] = ..., ContFlags: typing.Optional[int] = ..., DequotedNameOrString: typing.Optional[str] = ...) -> None:
        """
        Constructor

        Arguments:
            LeadingWhiteSpace (int, optional): LeadingWhiteSpace value.
            EndPos (int, optional): EndPos value.
            CharLen (int, optional): CharLen value.
            Value (float, optional): Value value.
            TokenType (int, optional): TokenType value.
            StartFlags (int, optional): StartFlags value.
            ContFlags (int, optional): ContFlags value.
            DequotedNameOrString (str, optional): DequotedNameOrString value.
        """


    @property
    def LeadingWhiteSpace(self) -> int:
        """
        Count of ignored leading whitespace, in UTF-16 code units, not Unicode code points.
        """


    @property
    def EndPos(self) -> int:
        """
        UTF-16 code unit index of first unprocessed character.
        """


    @property
    def CharLen(self) -> int:
        """
        Number of code points (not UTF-16 code units) of the parsed token, not including leading whitespace.
        """


    @property
    def Value(self) -> float:
        """
        Value of token in case of numeric.
        """


    @property
    def TokenType(self) -> int:
        """
        KParseType token type like KParseType.IDENTNAME.
        """


    @property
    def StartFlags(self) -> int:
        """
        KParseTokens flags of first character of actual token matched.
        
        If TokenType is a KParseType.SINGLE_QUOTE_NAME or a KParseType.DOUBLE_QUOTE_STRING the first character is the first character inside the quotes, not the quote itself.
        """


    @property
    def ContFlags(self) -> int:
        """
        KParseTokens flags of remaining characters of actual token matched.
        """


    @property
    def DequotedNameOrString(self) -> str:
        """
        If a quoted name or string is encountered the dequoted result goes here.
        """



__all__ = ['ParseResult']
