# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.frame
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing
from ..beans.named_value import NamedValue as NamedValue_a37a0af3
from ..util.url import URL as URL_57ad07b9


class ControlEvent(object):
    """
    Struct Class

    describes a control event sent by extended user interface controls.
    
    **since**
    
        OOo 2.0.3

    See Also:
        `API ControlEvent <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1frame_1_1ControlEvent.html>`_
    """
    typeName: Literal['com.sun.star.frame.ControlEvent']

    def __init__(self, aInformation: typing.Optional[typing.Tuple[NamedValue_a37a0af3, ...]] = ..., aURL: typing.Optional[URL_57ad07b9] = ..., Event: typing.Optional[str] = ...) -> None:
        """
        Constructor

        Arguments:
            aInformation (typing.Tuple[NamedValue, ...], optional): aInformation value.
            aURL (URL, optional): aURL value.
            Event (str, optional): Event value.
        """


    @property
    def aInformation(self) -> typing.Tuple[NamedValue_a37a0af3, ...]:
        """
        specifies a sequence of named values which are used as additional values for the event.
        
        The number and types of named values depend on the event.
        """


    @property
    def aURL(self) -> URL_57ad07b9:
        """
        fully parsed URL describing the control that sends this notification.
        """


    @property
    def Event(self) -> str:
        """
        specifies the event which has occurred.
        """



__all__ = ['ControlEvent']
