# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.embed
# Libre Office Version: 7.2
from typing_extensions import Literal
import typing
from ..datatransfer.data_flavor import DataFlavor as DataFlavor_ffd30deb


class VisualRepresentation(object):
    """
    Struct Class

    can contain a graphical representation in an arbitrary format.

    See Also:
        `API VisualRepresentation <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1embed_1_1VisualRepresentation.html>`_
    """
    typeName: Literal['com.sun.star.embed.VisualRepresentation']

    def __init__(self, Flavor: typing.Optional[DataFlavor_ffd30deb] = ..., Data: typing.Optional[object] = ...) -> None:
        """
        Constructor

        Arguments:
            Flavor (DataFlavor, optional): Flavor value.
            Data (object, optional): Data value.
        """


    @property
    def Flavor(self) -> DataFlavor_ffd30deb:
        """
        The format of the visual representation.
        """


    @property
    def Data(self) -> object:
        """
        The data in the format specified by Flavor.
        """



__all__ = ['VisualRepresentation']
