# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Exception Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.document
# Libre Office Version: 7.2
from typing_extensions import Literal
from ooo.oenv.env_const import UNO_NONE
import typing
from ..uno.exception import Exception as Exception_85530a09
from ..uno.x_interface import XInterface as XInterface_8f010a43

class NoSuchFilterRequest(Exception_85530a09):
    """
    Exception Class

    should be used for interaction to handle states of unknown filter during detection
    
    If during loading time the filter can't be detected and wasn't given at calling time, a possible com.sun.star.task.InteractionHandler will be used. (it's a part of used MediaDescriptor) Such \"NoSuchFilterRequest\" will be used then to start right interaction on that to get a decision which filter should be used for given URL. A possible continuation of type XInteractionFilterSelect will transport this decision back to generic filter detection and force using of it. Of course it's possible to abort the loading process by use another continuation com.sun.star.task.XInteractionAbort.

    See Also:
        `API NoSuchFilterRequest <https://api.libreoffice.org/docs/idl/ref/exceptioncom_1_1sun_1_1star_1_1document_1_1NoSuchFilterRequest.html>`_
    """

    typeName: Literal['com.sun.star.document.NoSuchFilterRequest']

    def __init__(self, Message: typing.Optional[str] = ..., Context: typing.Optional[XInterface_8f010a43] = ..., URL: typing.Optional[str] = ...) -> None:
        """
        Constructor

        Arguments:
            Message (str, optional): Message value.
            Context (XInterface, optional): Context value.
            URL (str, optional): URL value.
        """
    @property
    def URL(self) -> str:
        """
        transport URL which couldn't be detected
        """


__all__ = ['NoSuchFilterRequest']

