# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.chart2
from typing_extensions import Literal
import typing
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ..beans.property_value import PropertyValue as PropertyValue_c9610c73
    from .x_chart_type import XChartType as XChartType_ad200b38
    from .x_data_interpreter import XDataInterpreter as XDataInterpreter_f84f0db2
    from .x_data_series import XDataSeries as XDataSeries_b8150b89
    from .x_diagram import XDiagram as XDiagram_96fe0a59
    from .data.x_data_source import XDataSource as XDataSource_f6340d57

class XChartTypeTemplate(XInterface_8f010a43):
    """

    See Also:
        `API XChartTypeTemplate <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1chart2_1_1XChartTypeTemplate.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.chart2.XChartTypeTemplate']

    def applyStyle(self, xSeries: 'XDataSeries_b8150b89', nChartTypeGroupIndex: int, nSeriesIndex: int, nSeriesCount: int) -> None:
        """
        Applies a chart-type specific style (e.g.
        
        symbols) to all series in the sequence aSeries.
        """
    def changeDiagram(self, xDiagram: 'XDiagram_96fe0a59') -> None:
        """
        Analyses the given diagram and reinterprets its DataSeries and Categories and creates a new diagram based on these series.
        
        Note, that if matchesTemplate() returns TRUE for the given XDiagram, the latter should not be changed.
        """
    def changeDiagramData(self, xDiagram: 'XDiagram_96fe0a59', xDataSource: 'XDataSource_f6340d57', aArguments: 'typing.Tuple[PropertyValue_c9610c73, ...]') -> None:
        """
        Changes the given diagram xDiagram by using the new data given in xDataSource.
        
        Note that the data is interpreted in a way that fits this template, but not necessarily the chart-types of the diagram. This method should only be called if the data-format of the diagram is compatible with the data-format of this template.
        
        Ideally a matchesTemplate() call for the given diagram should return TRUE before this method is called.
        
        For standard parameters that may be used, see the service StandardDiagramCreationParameters.
        """
    def createDiagramByDataSource(self, xDataSource: 'XDataSource_f6340d57', aArguments: 'typing.Tuple[PropertyValue_c9610c73, ...]') -> 'XDiagram_96fe0a59':
        """
        Creates a new diagram based upon the given data .
        
        For standard parameters that may be used, see the service StandardDiagramCreationParameters.
        """
    def getChartTypeForNewSeries(self, aFormerlyUsedChartTypes: 'typing.Tuple[XChartType_ad200b38, ...]') -> 'XChartType_ad200b38':
        """
        Provides a chart type object that can be used to create new series.
        """
    def getDataInterpreter(self) -> 'XDataInterpreter_f84f0db2':
        """
        """
    def matchesTemplate(self, xDiagram: 'XDiagram_96fe0a59', bAdaptProperties: bool) -> bool:
        """
        States whether the given diagram could have been created by the template.
        
        The template will parse the DataSeriesTree of the diagram to determine if the structure matches the one which would have been created by createDiagramByDataSource().
        
        For analysis all parts of the diagram may be used, e.g. also properties set at the data series (like symbols)./p>
        """
    def resetStyles(self, xDiagram: 'XDiagram_96fe0a59') -> None:
        """
        Resets all styles that were changed from the default at any object in the chart and have not been later modified.
        
        In createDiagramByDataSource() or changeDiagram() a template might e.g. change the page background color or the line style of all data series. This method should reset all objects that still have the changed settings to the default.
        
        If for example the template changed the com.sun.star.drawing.LineStyle of all series to NONE, this method should reset all series with LineStyle NONE back to SOLID. If a series has a style DASH, it must not be changed.
        """
    def supportsCategories(self) -> bool:
        """
        """

__all__ = ['XChartTypeTemplate']

