# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.2
# Namespace: com.sun.star.awt
from typing_extensions import Literal
import typing
from .x_dialog_provider import XDialogProvider as XDialogProvider_c70f0c47
if typing.TYPE_CHECKING:
    from .x_dialog import XDialog as XDialog_709d08fc
    from ..beans.named_value import NamedValue as NamedValue_a37a0af3
    from ..uno.x_interface import XInterface as XInterface_8f010a43

class XDialogProvider2(XDialogProvider_c70f0c47):
    """
    provides dialogs implementing the com.sun.star.awt.XDialog interface.

    See Also:
        `API XDialogProvider2 <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1awt_1_1XDialogProvider2.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.awt.XDialogProvider2']

    def createDialogWithArguments(self, URL: str, Arguments: 'typing.Tuple[NamedValue_a37a0af3, ...]') -> 'XDialog_709d08fc':
        """
        creates a dialog for the given URL, accepting additional creation parameters
        
        The arguments accepted so far are

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
    def createDialogWithHandler(self, URL: str, xHandler: 'XInterface_8f010a43') -> 'XDialog_709d08fc':
        """
        creates a dialog for the given URL accepting an Interface used to handle dialog events.
        
        xHandler can handle events in two different ways:
        
        If XDialogEventHandler is supported XDialogEventHandler.callHandlerMethod() is always called first to handle the event. Only if the event cannot be handled by XDialogEventHandler (callHandlerMethod() then has to return false) or if XDialogEventHandler is not supported at all the Introspection based access will be used.
        
        The Introspection based access tries to call a method named according to the HandlerMethodName specified by a vnd.sun.star.UNO:HandlerMethodName URL. First a method
        
        void HandlerMethodName( [in] com.sun.star.awt.XDialog xDialog, [in] any aEvent )
        
        will be searched. The signature is similar to XDialogEventHandler. callHandlerMethod except for MethodName itself that isn't needed here. For more information about these parameters, see com.sun.star.awt.XDialogEventHandler.
        
        If this method is found, it will be called, otherwise a method
        
        void HandlerMethodName( void )
        
        will be searched and called.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """

__all__ = ['XDialogProvider2']

