"""empty message

Revision ID: roc_dingo_0023_add_hfrtimelog
Revises: roc_dingo_0022_add_to_update_flag_to_filelog
Create Date: 2022-02-08 17:22:38.827046

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from poppy.pop.alembic.helpers import \
    create_table, execute, user, drop_table

# revision identifiers, used by Alembic.
revision = 'roc_dingo_0023_add_hfrtimelog'
down_revision = 'roc_dingo_0022_add_to_update_flag_to_filelog'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    create_table('hfr_time_log',
    sa.Column('id', sa.BIGINT(), nullable=False),
    sa.Column('acq_time', postgresql.TIMESTAMP(), nullable=False),
    sa.Column('coarse_time', sa.BIGINT(), nullable=False),
    sa.Column('fine_time', sa.BIGINT(), nullable=False),
    sa.Column('mode', sa.SMALLINT(), nullable=False),
    sa.Column('delta_time1', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('delta_time2', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('coarse_time', 'fine_time', 'mode'),
    schema='pipeline'
    )
    # ### end Alembic commands ###

    # added by hand
    # fix table permissions
    grant_user_seq = (
        """GRANT USAGE, SELECT
        ON ALL SEQUENCES IN SCHEMA pipeline TO {0}""".format(user)
    )
    execute(grant_user_seq)

def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    drop_table('hfr_time_log', schema='pipeline')
    # ### end Alembic commands ###
