"""empty message

Revision ID: roc_dingo_0020_rm_biacurrtablehfr
Revises: roc_dingo_0019_modify_views_per_date
Create Date: 2021-12-17 10:13:35.507837

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from poppy.pop.alembic.helpers import \
    create_table, execute, user, drop_table

# revision identifiers, used by Alembic.
revision = 'roc_dingo_0020_rm_biacurrtablehfr'
down_revision = 'roc_dingo_0019_modify_views_per_date'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    drop_table('bia_current_log',
               schema='pipeline')
    drop_table('bia_sweep_table',
               schema='pipeline')
    drop_table('hfr_freq_list',
               schema='pipeline')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    create_table('bia_sweep_table',
    sa.Column('id', sa.BIGINT(), nullable=False),
    sa.Column('tc_name', sa.String(length=256), nullable=False),
    sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=False),
    sa.Column('sweep_eeprom', sa.BOOLEAN(), nullable=True),
    sa.Column('sweep_step_cur', sa.String(), nullable=True),
    sa.Column('insert_time', postgresql.TIMESTAMP(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('utc_time', 'tc_name'),
    schema='pipeline'
    )
    create_table('hfr_freq_list',
    sa.Column('id', sa.BIGINT(), nullable=False),
    sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=False),
    sa.Column('tc_name', sa.String(length=256), nullable=False),
    sa.Column('freq_list', sa.String(), nullable=False),
    sa.Column('freq_nr', sa.INTEGER(), nullable=False),
    sa.Column('insert_time', postgresql.TIMESTAMP(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('utc_time', 'tc_name'),
    schema='pipeline'
    )
    create_table('bia_current_log',
                 sa.Column('id', sa.BIGINT(), nullable=False),
                 sa.Column('tc_name', sa.String(length=256), nullable=False),
                 sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=False),
                 sa.Column('bia_current', sa.FLOAT(), nullable=False),
                 sa.Column('insert_time', postgresql.TIMESTAMP(),
                           nullable=True),
                 sa.PrimaryKeyConstraint('id'),
                 sa.UniqueConstraint('utc_time', 'tc_name'),
                 schema='pipeline'
                 )

    # added by hand
    # fix table permissions
    grant_user_seq = (
        """GRANT USAGE, SELECT
        ON ALL SEQUENCES IN SCHEMA pipeline TO {0}""".format(user)
    )
    execute(grant_user_seq)
    # ### end Alembic commands ###
