# -*- coding: utf-8 -*-
"""Add a columns to store if file has already been delivered to ESA
and with which filename

Revision ID: roc_dingo_0016_add_is_delivered
Revises: roc_dingo_0015_add_dataqueue
Create Date: 2021-10-12 11:58:35.441300

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = 'roc_dingo_0018a_task_delivered'
down_revision = 'roc_dingo_0017_add_efecsevents'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        'file_log',
        sa.Column('is_delivered', sa.BOOLEAN(), nullable=True),
        schema='pipeline')

    op.add_column(
        'file_log',
        sa.Column('public_filename', sa.String(), nullable=True),
        schema='pipeline')

    op.add_column(
        'file_log',
        sa.Column('public_dirname', sa.String(), nullable=True),
        schema='pipeline')

    # adding a column with a default value is not possible with Alembic
    # so create the column without the nullable constraint
    # fill the table with the default value (false)
    # after, add the nullable constraint

    op.execute('UPDATE pipeline.file_log SET is_delivered = false')
    op.alter_column(
        'file_log', 'is_delivered',
        nullable=False, schema='pipeline')

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###

    op.drop_column('file_log', 'is_delivered', schema='pipeline')
    op.drop_column('file_log', 'public_filename', schema='pipeline')
    op.drop_column('file_log', 'public_dirname', schema='pipeline')
    # ### end Alembic commands ###
