"""empty message

Revision ID: roc_dingo_0017_add_efecsevents
Revises: roc_dingo_0016_add_kcoeffbiacur
Create Date: 2021-10-20 15:24:57.007966

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from poppy.pop.alembic.helpers import \
    create_table, create_schema, execute, user, drop_table

# revision identifiers, used by Alembic.
revision = 'roc_dingo_0017_add_efecsevents'
down_revision = 'roc_dingo_0016_add_kcoeffbiacur'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    create_table('efecs_events',
    sa.Column('id', sa.BIGINT(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=False),
    sa.Column('attributes', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('ltp_count', sa.SMALLINT(), nullable=False),
    sa.Column('gen_time', postgresql.TIMESTAMP(), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name', 'utc_time'),
    schema='pipeline'
    )
    # ### end Alembic commands ###

    # added by hand
    # fix table permissions
    grant_user_seq = (
        """GRANT USAGE, SELECT
        ON ALL SEQUENCES IN SCHEMA pipeline TO {0}""".format(user)
    )
    execute(grant_user_seq)


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    drop_table('efecs_events', schema='pipeline')
    # ### end Alembic commands ###
