"""empty message

Revision ID: roc_dingo_0016_add_kcoeff_biascurr
Revises: roc_dingo_0015_add_dataqueue
Create Date: 2021-10-10 12:40:44.668707

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from poppy.pop.alembic.helpers import \
    create_table, create_schema, execute, user, drop_table

# revision identifiers, used by Alembic.
revision = 'roc_dingo_0016_add_kcoeffbiacur'
down_revision = 'roc_dingo_0015_add_processqueue'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    create_table('bia_current_log',
                 sa.Column('id', sa.BIGINT(), nullable=False),
                 sa.Column('tc_name', sa.String(length=256), nullable=False),
                 sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=False),
                 sa.Column('bia_current', sa.FLOAT(), nullable=False),
                 sa.Column('insert_time', postgresql.TIMESTAMP(),
                           nullable=True),
                 sa.PrimaryKeyConstraint('id'),
                 sa.UniqueConstraint('utc_time', 'tc_name'),
                 schema='pipeline'
                 )
    create_table('lfr_kcoeff_dump',
                 sa.Column('id', sa.BIGINT(), nullable=False),
                 sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=False),
                 sa.Column('cuc_time', sa.String(length=1024), nullable=False),
                 sa.Column('utc_time_is_predictive',
                           sa.BOOLEAN(), nullable=True),
                 sa.Column('kcoeff_pkt_cnt', sa.SMALLINT(), nullable=False),
                 sa.Column('kcoeff_pkt_nr', sa.SMALLINT(), nullable=False),
                 sa.Column('kcoeff_blk_nr', sa.SMALLINT(), nullable=False),
                 sa.Column('kcoeff_values', postgresql.JSONB(astext_type=sa.Text()), nullable=False),
                 sa.Column('insert_time', postgresql.TIMESTAMP(),
                           nullable=True),
                 sa.PrimaryKeyConstraint('id'),
                 sa.UniqueConstraint('utc_time', 'kcoeff_pkt_nr'),
                 schema='pipeline'
                 )
    op.alter_column('solo_hk_param', 'description',
                    existing_type=sa.VARCHAR(),
                    nullable=False,
                    schema='pipeline')
    op.alter_column('solo_hk_param', 'eng_value',
                    existing_type=sa.VARCHAR(),
                    nullable=False,
                    schema='pipeline')
    op.alter_column('solo_hk_param', 'raw_value',
                    existing_type=sa.VARCHAR(),
                    nullable=False,
                    schema='pipeline')
    op.alter_column('solo_hk_param', 'unit',
                    existing_type=sa.VARCHAR(),
                    nullable=False,
                    schema='pipeline')
    # ### end Alembic commands ###

    # added by hand
    # fix table permissions
    grant_user_seq = (
        """GRANT USAGE, SELECT
        ON ALL SEQUENCES IN SCHEMA pipeline TO {0}""".format(user)
    )
    execute(grant_user_seq)


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('solo_hk_param', 'unit',
                    existing_type=sa.VARCHAR(),
                    nullable=True,
                    schema='pipeline')
    op.alter_column('solo_hk_param', 'raw_value',
                    existing_type=sa.VARCHAR(),
                    nullable=True,
                    schema='pipeline')
    op.alter_column('solo_hk_param', 'eng_value',
                    existing_type=sa.VARCHAR(),
                    nullable=True,
                    schema='pipeline')
    op.alter_column('solo_hk_param', 'description',
                    existing_type=sa.VARCHAR(),
                    nullable=True,
                    schema='pipeline')
    drop_table('lfr_kcoeff_dump', schema='pipeline')
    drop_table('bia_current_log', schema='pipeline')
    # ### end Alembic commands ###
