"""empty message

Revision ID: roc_dingo_0015_add_dataqueue
Revises: roc_dingo_0014_add_solohk
Create Date: 2021-09-27 14:43:44.503799

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from poppy.pop.alembic.helpers import \
    create_table, create_schema, execute, user, drop_table

# revision identifiers, used by Alembic.
revision = 'roc_dingo_0015_add_processqueue'
down_revision = 'roc_dingo_0014_add_solohk'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    create_table('process_queue',
    sa.Column('id', sa.BIGINT(), nullable=False),
    sa.Column('dataset_id', sa.String(length=512), nullable=False),
    sa.Column('start_time', postgresql.TIMESTAMP(), nullable=False),
    sa.Column('end_time', postgresql.TIMESTAMP(), nullable=True),
    sa.Column('version', sa.String(length=16), nullable=True),
    sa.Column('file', sa.String(), nullable=True),
    sa.Column('insert_time', postgresql.TIMESTAMP(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    schema='pipeline'
    )
    # ### end Alembic commands ###

    # added by hand
    # fix table permissions
    grant_user_seq = (
        """GRANT USAGE, SELECT
        ON ALL SEQUENCES IN SCHEMA pipeline TO {0}""".format(user)
    )
    execute(grant_user_seq)

def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    drop_table('process_queue', schema='pipeline')
    # ### end Alembic commands ###
