"""empty message

Revision ID: roc_dingo_0014_add_solohk
Revises: roc_dingo_0013_fix_db
Create Date: 2021-09-14 16:41:50.725120

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from poppy.pop.alembic.helpers import \
    create_table, create_schema, execute, user, drop_table

# revision identifiers, used by Alembic.
revision = 'roc_dingo_0014_add_solohk'
down_revision = 'roc_dingo_0013_fix_db'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    create_table('solo_hk_param',
    sa.Column('id', sa.BIGINT(), nullable=False),
    sa.Column('name', sa.String(length=16), nullable=False),
    sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=False),
    sa.Column('unit', sa.String(), nullable=True),
    sa.Column('description', sa.String(), nullable=True),
    sa.Column('eng_value', sa.String(), nullable=True),
    sa.Column('raw_value', sa.String(), nullable=True),
    sa.Column('sha', sa.String(), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('sha'),
    schema='pipeline'
    )
    # ### end Alembic commands ###

    # added by hand
    # fix table permissions
    grant_user_seq = (
        """GRANT USAGE, SELECT
        ON ALL SEQUENCES IN SCHEMA pipeline TO {0}""".format(user)
    )
    execute(grant_user_seq)


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    drop_table('solo_hk_param', schema='pipeline')
    # ### end Alembic commands ###
