"""empty message

Revision ID: roc_dingo_0012_add_data
Revises: roc_dingo_0011_update_packet
Create Date: 2021-07-15 14:33:41.549410

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from poppy.pop.alembic.helpers import \
    create_table, create_schema, execute, user, drop_table

# revision identifiers, used by Alembic.
revision = 'roc_dingo_0012_add_data'
down_revision = 'roc_dingo_0011_update_packet'
branch_labels = None
depends_on = None


def upgrade():

    # delete the types if they exist
    execute('DROP TYPE IF EXISTS sbm_status_type')

    # ### commands auto generated by Alembic - please adjust! ###
    create_table('bia_sweep_table',
                 sa.Column('id', sa.BIGINT(), nullable=False),
                 sa.Column('tc_name', sa.String(length=256), nullable=False),
                 sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=False),
                 sa.Column('sweep_eeprom', sa.BOOLEAN(), nullable=True),
                 sa.Column('sweep_step_cur', sa.String(), nullable=True),
                 sa.Column('insert_time', postgresql.TIMESTAMP(),
                           nullable=True),
                 sa.PrimaryKeyConstraint('id'),
                 sa.UniqueConstraint('utc_time', 'tc_name'),
                 schema='pipeline'
                 )
    create_table('bia_sweep_log',
                 sa.Column('id', sa.BIGINT(), nullable=False),
                 sa.Column('sweep_step', sa.String(length=16), nullable=False),
                 sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=False),
                 sa.Column('cuc_time', sa.String(length=1024), nullable=False),
                 sa.Column('utc_time_is_predictive',
                           sa.BOOLEAN(), nullable=True),
                 sa.Column('insert_time', postgresql.TIMESTAMP(),
                           nullable=True),
                 sa.PrimaryKeyConstraint('id'),
                 sa.UniqueConstraint('sweep_step', 'utc_time'),
                 schema='pipeline'
                 )
    create_table('hfr_freq_list',
                 sa.Column('id', sa.BIGINT(), nullable=False),
                 sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=False),
                 sa.Column('tc_name', sa.String(length=256), nullable=False),
                 sa.Column('freq_list', sa.String(), nullable=False),
                 sa.Column('freq_nr', sa.INTEGER(), nullable=False),
                 sa.Column('insert_time', postgresql.TIMESTAMP(),
                           nullable=True),
                 sa.PrimaryKeyConstraint('id'),
                 sa.UniqueConstraint('utc_time', 'tc_name'),
                 schema='pipeline'
                 )
    create_table('sbm_log',
                 sa.Column('id', sa.BIGINT(), nullable=False),
                 sa.Column('sbm_type', sa.SMALLINT(), nullable=False),
                 sa.Column('cuc_time', sa.String(length=1024), nullable=False),
                 sa.Column('obt_time', postgresql.TIMESTAMP(), nullable=False),
                 sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=True),
                 sa.Column('utc_time_is_predictive',
                           sa.BOOLEAN(), nullable=True),
                 sa.Column('sbm_qf', sa.FLOAT(), nullable=False),
                 sa.Column('sbm_algo', sa.SMALLINT(), nullable=False),
                 sa.Column('sbm_algo_param', postgresql.JSONB(
                     astext_type=sa.Text()), nullable=True),
                 sa.Column('insert_time', postgresql.TIMESTAMP(),
                           nullable=True),
                 sa.Column('selected', sa.BOOLEAN(), nullable=True),
                 sa.Column('status',
                           postgresql.ENUM(
                               'Available', 'Requested', 'Downlinked', 'Deleted', 'Missed', 'Unknown',
                               name='sbm_status_type'),
                           nullable=False),
                 sa.PrimaryKeyConstraint('id'),
                 sa.UniqueConstraint('cuc_time', 'sbm_type'),
                 schema='pipeline'
                 )
    create_table('event_log',
                 sa.Column('id', sa.BIGINT(), nullable=False),
                 sa.Column('start_time', postgresql.TIMESTAMP(),
                           nullable=False),
                 sa.Column('end_time', postgresql.TIMESTAMP(), nullable=False),
                 sa.Column('description', postgresql.JSONB(
                     astext_type=sa.Text()), nullable=False),
                 sa.Column('label', sa.String(), nullable=False),
                 sa.Column('is_predictive', sa.BOOLEAN(), nullable=True),
                 sa.Column('insert_time', postgresql.TIMESTAMP(),
                           nullable=True),
                 sa.PrimaryKeyConstraint('id'),
                 sa.UniqueConstraint('start_time', 'end_time',
                                     'label', 'description'),
                 schema='pipeline'
                 )
    # ### end Alembic commands ###

    # added by hand
    # fix table permissions
    grant_user_seq = (
        """GRANT USAGE, SELECT
        ON ALL SEQUENCES IN SCHEMA pipeline TO {0}""".format(user)
    )
    execute(grant_user_seq)


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    drop_table('sbm_log', schema='pipeline')
    drop_table('hfr_freq_list', schema='pipeline')
    drop_table('bia_sweep_table', schema='pipeline')
    drop_table('bia_sweep_log', schema='pipeline')
    drop_table('event_log', schema='pipeline')
    # ### end Alembic commands ###

    # delete the types if they exist
    execute('DROP TYPE IF EXISTS sbm_status_type')
