"""empty message

Revision ID: roc_dingo_0011_update_packet
Revises: roc_dingo_0010_add_view
Create Date: 2021-07-13 10:34:14.379850

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from poppy.pop.alembic.helpers import \
    create_table, create_schema, execute, user, drop_table

# revision identifiers, used by Alembic.
revision = 'roc_dingo_0011_update_packet'
down_revision = 'roc_dingo_0010_add_view'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    create_table('tc_log',
    sa.Column('id', sa.BIGINT(), nullable=False),
    sa.Column('length', sa.INTEGER(), nullable=False),
    sa.Column('category', sa.String(length=512), nullable=True),
    sa.Column('apid', sa.INTEGER(), nullable=True),
    sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=False),
    sa.Column('srdb_id', sa.String(length=16), nullable=False),
    sa.Column('palisade_id', sa.String(length=256), nullable=False),
    sa.Column('binary', sa.String(), nullable=True),
    sa.Column('data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('sha', sa.String(), nullable=False),
    sa.Column('tc_exe_state', sa.String(length=16), nullable=True),
    sa.Column('tc_acc_state', sa.String(length=16), nullable=True),
    sa.Column('sequence_name', sa.String(length=16), nullable=True),
    sa.Column('unique_id', sa.String(length=256), nullable=True),
    sa.Column('insert_time', postgresql.TIMESTAMP(), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('sha'),
    schema='pipeline'
    )
    create_table('tm_log',
    sa.Column('id', sa.BIGINT(), nullable=False),
    sa.Column('length', sa.INTEGER(), nullable=True),
    sa.Column('category', sa.String(length=512), nullable=True),
    sa.Column('apid', sa.INTEGER(), nullable=True),
    sa.Column('sync_flag', sa.BOOLEAN(), nullable=True),
    sa.Column('srdb_id', sa.String(length=16), nullable=True),
    sa.Column('palisade_id', sa.String(length=256), nullable=True),
    sa.Column('binary', sa.String(), nullable=True),
    sa.Column('data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('sha', sa.String(), nullable=False),
    sa.Column('sequence_cnt', sa.BIGINT(), nullable=True),
    sa.Column('cuc_time', sa.String(length=1024), nullable=False),
    sa.Column('obt_time', postgresql.TIMESTAMP(), nullable=True),
    sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=True),
    sa.Column('utc_time_is_predictive', sa.BOOLEAN(), nullable=True),
    sa.Column('insert_time', postgresql.TIMESTAMP(), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('sha'),
    schema='pipeline'
    )
    # ### end Alembic commands ###
    # added by hand
    # Drop old packet tables
    drop_table('packet_log', schema='pipeline')
    drop_table('invalid_packet_log', schema='pipeline')

    # added by hand
    # fix table permissions
    grant_user_seq = (
        """GRANT USAGE, SELECT
        ON ALL SEQUENCES IN SCHEMA pipeline TO {0}""".format(user)
    )
    execute(grant_user_seq)

def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    drop_table('tm_log', schema='pipeline')
    drop_table('tc_log', schema='pipeline')
    # ### end Alembic commands ###
