
# Some of these polynomials are used for many algorithms, so they are collected
# here
_CRC16_CCITT_POLY = 0x1021
_CRC32_POLY = 0x04C11DB7

_U8_MAX = 255
_U16_MAX = (1 << 16) - 1
_U32_MAX = (1 << 32) - 1

_FIELDS = ("poly", "width", "seed", "ref_in", "ref_out", "xor_out", "check")

_ALGORITHMS = {
	# =========================  8-bit ========================================
	"crc8": (0xD5, 8, 0, False, False, 0, 0xBC),
	"crc8-autosar": (0x2F, 8, _U8_MAX, False, False, _U8_MAX, 0xDF),
	"crc8-bluetooth": (0xA7, 8, 0, True, True, 0, 0x26),
	# ITU I.432.1 https://www.itu.int/rec/T-REC-I.432.1-199902-I/en
	"crc8-ccitt": (0x07, 8, 0, False, False, 0x55, 0xA1),
	# https://www.etsi.org/deliver/etsi_ts/100900_100999/100909/08.09.00_60/ts_100909v080900p.pdf
	"crc8-gsm-b": (0x49, 8, 0, False, False, _U8_MAX, 0x94),
	"crc8-sae-j1850": (0x1D, 8, _U8_MAX, False, False, _U8_MAX, 0x4B),
	# ========================= 15-bit ========================================
	"crc15-can": (0x4599, 15, 0, False, False, 0, 0x059E),
	# ========================= 16-bit ========================================
	# From  KERMIT PROTOCOL MANUAL Sixth Edition 1986 Three-character 16-bit
	# CRC-CCITT. The CRC calculation treats  the  data  it operates  upon  as
	# a  string  of  bits with the low order bit of the first character first
	# and the high order bit of the last character last.  The initial value of
	# the CRC is taken as 0; the 16-bit CRC is the remainder after 16  12  5
	# dividing the data bit string by the polynomial X  +X  +X +1 (this
	# calculation  can  actually  be  done  a  character at a time, using a
	# simple table lookup algorithm).
	# http://www.columbia.edu/kermit/ftp/e/kproto.doc
	# The Kermit protocol describes the algorithm applied to bits down the wire
	# and UARTs transmit least-significant-bit first
	"crc16-kermit": (_CRC16_CCITT_POLY, 16, 0, True, True, 0, 0x2189),
	"crc16-ccitt-true": (_CRC16_CCITT_POLY, 16, 0, True, True, 0, 0x2189),
	# https://www.itu.int/rec/T-REC-V.41/en
	"crc16-xmodem": (_CRC16_CCITT_POLY, 16, 0, False, False, 0, 0x31C3),
	# AKA CRC16-CCITT-FALSE
	# Reference https://www.autosar.org/fileadmin/Releases_TEMP/Classic_Platform_4.4.0/Libraries.zip
	"crc16-autosar": (_CRC16_CCITT_POLY, 16, _U16_MAX, False, False, 0, 0x29B1),
	#  crc16-ccitt-false is an alias of crc16-autosar
	"crc16-ccitt-false": (_CRC16_CCITT_POLY, 16, _U16_MAX, False, False, 0, 0x29B1),
	"crc16-cdma2000": (0xC867, 16, _U16_MAX, False, False, 0, 0x4C06),
	# Algorithms normally called "CRC16"
	"crc16-ibm": (0x8005, 16, 0, True, True, 0, 0xBB3D),
	"crc16-modbus": (0x8005, 16, _U16_MAX, True, True, 0, 0x4B37),
	"crc16-profibus": (0x1DCF, 16, _U16_MAX, False, False, _U16_MAX, 0xA819),
	# ========================= 24-bit ========================================
	"crc24-flexray16-a": (0x5D6DCB, 24, 0xFEDCBA, False, False, 0, 0x7979BD),
	"crc24-flexray16-b": (0x5D6DCB, 24, 0xABCDEF, False, False, 0, 0x1F23B8),
	# ========================= 32-bit ========================================
	# Ethernet CRC32
	# https://www.ecma-international.org/publications/files/ECMA-ST/Ecma-130.pdf
	"crc32": (_CRC32_POLY, 32, _U32_MAX, True, True, _U32_MAX, 0xCBF43926),
	# CRC32 as implemented in BZIP, same polynomial but no reflection
	"crc32-bzip2": (_CRC32_POLY, 32, _U32_MAX, False, False, _U32_MAX, 0xFC891918),
	# Castagnoli CRC used in iSCSi SSE4, ext4
	"crc32-c": (0x1EDC6F41, 32, _U32_MAX, True, True, _U32_MAX, 0xE3069283),
	# ========================= 64-bit ========================================
	"crc64-ecma": (0x42F0E1EBA9EA3693, 64, 0, False, False, 0, 0x6C40DF5F0B497347),
}
