# Release Notes

## v1.14.5 January 17, 2023
- Bugfix: autodetect from bitcoin.conf file with network set #2037 (kexkey)
- Bugfix: change settings_restore implementation #2042 (k9ert)
- Bugfix: fixes #1997 for Docker builds as well as command line installs #2053 (Michael Henke)
- Bugfix: internal node needs to be saved #2045 (k9ert)
- Chore: Bump json5 from 2.1.3 to 2.2.3 in /pyinstaller/electron #2039 (dependabot[bot])
- Chore: Bump minimatch from 3.0.4 to 3.1.2 #1966 (dependabot[bot])
- Chore: Bump minimatch from 3.0.4 to 3.1.2 in /pyinstaller/electron #1965 (dependabot[bot])
- Chore: Remove docker support #2054 (k9ert)
- Chore: some dependency improvements #2046 (k9ert)
- Chore: testing bridge_rpc errorhandling #2055 (k9ert)
- Docs: Add Documentation Link to Readme #2043 (k9ert)
- Docs: MacOS build instructions #2023 (Manolis Mandrapilias)
- Docs: Updated instructions to upgrade Specter on Raspiblitz #2040 (k9ert)
- Docs: Update of developer guide #2036 (Paarth Agarwal)
- Docs: Update release guide #2029 (Manolis Mandrapilias)
- Feature: delete spectrum node #2047 (k9ert)

## v1.14.2 December 21, 2022
- UIUX: Address labeling revamp #1978 (OTK & Manolis Mandrapilias)
- UIUX: Better node selection #1987 (Manolis Mandrapilias)
- UIUX: Update Passport connection instructions #2010 (BitcoinQnA)
- Bugfix: Long loading time of wallets at start-up with Spectrum #2015 (k9ert)
- Bugfix: Merkle proofs with Spectrum #2012 (k9ert)
- Bugfix: Addressinfo edge case fixed #2001 (relativisticelectron)
- Bugfix: Version not properly detected #2020 (k9ert)
- Chore: Generic error handling for API calls #2014 (k9ert)
- Chore: Moving the Spectrum extension to a core extension #2011 (k9ert)
- Chore: Bump qs from 6.5.2 to 6.5.3 in /pyinstaller/electron #2002 (dependabot[bot])
- Chore: Bump Spectrum and Python version #2027 (Manolis Mandrapilias)
- Chore: Cypress test for address labeling #2021 (Manolis Mandrapilias)
- Chore: Fix nix shell by generating hashes with pip-compile #2016 (hodlwave)
- Docs: Corrected build instructions #1996 (relativisticelectron)

## v1.14.1 December 07, 2022
- Bugfix: Adding migrations to the hidden imports #2007 (k9ert)
- Bugfix: Bump Spectrum for better error_handling (k9ert)
- Chore: better error_handling and tested #2005 (k9ert)
- Docs: Release guide update #2004 (Manolis Mandrapilias)

## v1.14.0 December 07, 2022
- Feature: Spectrum addition #1952 (k9ert)
- Feature: Several things for Spectrum preparation #1913 (k9ert)
- Feature: QR support for Jade #1964 (Manolis Mandrapilias)
- Feature: Add taproot psbt fields #1837 (kdmukai)
- Feature: QR message signing for SeedSigner #1938 (kdmukai)
- Feature: Implement JWT authentication in REST API #1785 (Ankur)
- Feature: Deactivate hot wallets for Spectrum #1999 (Manolis Mandrapilias)
- Feature: Extensions can add new devices #1887 (k9ert)
- Feature: --devstatus-threshold for cli_server #1945 (k9ert)
- Security: CVE-2007-4559 Patch #1927 (TrellixVulnTeam)
- UIUX: Clearer language for incomplete transactions tab #1972 (OTK)
- Bugfix: Failover for non-existent nodes #1992 (k9ert)
- Bugfix: Fix float issue #1900 (relativisticelectron)
- Bugfix: Incomplete wallet deletion #1950 (Manolis Mandrapilias)
- Bugfix: Internal server error when node connection breaks down #1920 (Manolis Mandrapilias)
- Bugfix: No encryption for devhel extension required #1942 (relativisticelectron)
- Bugfix: Release procedure fix #1988 (k9ert)
- Bugfix: Service Manager loads wrong service Test-config #1907 (relativisticelectron)
- Bugfix: Some smaller fixes #1995 (k9ert)
- Bugfix: Updating the auto-withdrawal in Swan integration could lead to an error #1981 (Manolis Mandrapilias)
- Bugfix: Wrong device paths #1936 (k9ert)
- Bugfix: bump spectrum to 0.2.1 #1994 (k9ert)
- Bugfix: Various bugfixes #1959 (k9ert)
- Chore: Flask thread for wallet manager #1962 (k9ert)
- Chore: Make data encrytion for services optional #1918 (relativisticelectron)
- Chore: Making netlify more robust #1953 (k9ert)
- Chore: Node manager refactoring #1974 (Manolis Mandrapilias)
- Chore: Refactor Swan Extension to cryptoadvance.specterext #1955 (k9ert)
- Chore: Refactoring of wallet tests #1943 (Manolis Mandrapilias)
- Chore: Remove arrows and clickable headers on transactions table (for now) #1973 (OTK)
- Chore: Removing the Singleton #1914 (k9ert)
- Chore: Tagging specterext-dummy  with every release #1944 (k9ert)
- Chore: Update protobuf #1933 (k9ert)
- Chore: ext_wallettabs does not have to be set #1941 (Manolis Mandrapilias)
- Docs: Adding sequence diagram for swan flow #1969 (Manolis Mandrapilias)
- Docs: Release guide #1930 (Manolis Mandrapilias)
- Docs: Update connect-your-node.md #1937 (cstizza)

## v1.13.1 October 17, 2022
- Bugfix: Hover effect in balance display #1904 (Manolis Mandrapilias)
- Bugfix: Remove black empty bar in tx-table after search #1912 (relativisticelectron)
- Bugfix: upgrade hwi to 2.1.1 to fix #1840 #1909 (k9ert)
- Chore: macos release-script fixes #1897 (Manolis Mandrapilias)
- Chore: More precise grep in Cypress bash script #1911 (Manolis Mandrapilias)
- Chore: Update icon used in Electron app #1903 (d11n)
- Privacy: Disabeling spellcheck to avoid any leakage to 3rd party servers #1892 (relativisticelectron)
- UIUX: Clearer unconfirmed transaction icons #1899 (relativisticelectron)

## v1.13.0 September 22, 2022
- Feature: Improve Dev-Console #1850 (k9ert)
- Feature: Menu extensions can extend menus #1648 (k9ert)
- UIUX: Adding "Open Bitcoin app" verbiage to Ledger Upload Keys page #1868 (wombat6)
- UIUX: Better balance display #1841 (relativisticelectron)
- UIUX: Do not hide elements by default #1854 (relativisticelectron)
- UIUX: Individual HWI progess for Ledger devices #1864 (Manolis Mandrapilias)
- Mobile: Better width settings #1828 (relativisticelectron)
- Mobile: Optimisation of tx-table #1852 (Manolis Mandrapilias)
- Bugfix: Add non-witness-utxos and xpubs when using hwi with ledger #1888 (Salvatore Ingala)
- Bugfix: Escaped HTML in messages and errors #1890 (relativisticelectron)
- Bugfix: HTML escaped on Cobo and Coldcard Upload Keys page #1871 (wombat6)
- Bugfix: Missing values in tx details #1862 (relativisticelectron)
- Bugfix: during loading: KeyError: 'blocks' #1859 (relativisticelectron)
- Chore: Delete endpoint controller test #1872 (Manolis Mandrapilias)
- Chore: Dynamic fee rate optimisations & Cypress tests #1878 (Manolis Mandrapilias)
- Chore: Reworked extension list #1895 (k9ert)
- Chore: Upgrade to python 3.10 #1688 (relativisticelectron)
- Chore: Use Python 3.9 for black in pre-commit-config #1894 (Manolis Mandrapilias)
- Chore: redirect flash call #1883 (k9ert)

## v1.12.0 August 26, 2022
- Feature: add faucet and exfund extensions #1820 (Stepan Snigirev)
- Feature: Dev tools - Adding full python access via javascript for developers #1842 (relativisticelectron)
- UIUX: Complete overhaul of the tooltips used in Specter Desktop #1813 (Manolis Mandrapilias)
- UIUX: Easier adding and deleting of recipients #1782 (relativisticelectron)
- UIUX: Optimize tx-table for mobile screen #1804 (relativisticelectron)
- Mobile: Some extra height in mobile browsers #1827 (relativisticelectron)
- Bugfix: Allow mouse selection during address label editing for Firefox #1825 (relativisticelectron)
- Bugfix: Another broken html part and b tag #1823 (relativisticelectron)
- Bugfix: Fiat price in address table not visible #1836 (relativisticelectron)
- Bugfix: remove print statement with buggy expression #1822 (k9ert)
- Bugfix: fix explorer issue #1838 #1839 (relativisticelectron)
- Chore: Detecting Liquid chain #1851 (Manolis Mandrapilias)
- Chore: Fix psbt creator api to work with liquid assets when using json #1831 (Stepan Snigirev)
- Chore: Upgrade pyinstaller from 4.9 to 5.2 #1807 (k9ert)
- Docs: Add mobile access question to the FAQ #1829 (Manolis Mandrapilias)
- Docs: some doc fixes, refactorings and ext clarification #1789 (k9ert)
- Docs: Supported Python versions #1847 (Willie Wheeler)

## v1.10.5 July 21, 2022
- Bugfix: startup issues for MacOS App 1815 #1816 (relativisticelectron)
- Feature: generate app_config.py in extgen #1801 (k9ert)

## v1.10.4 July 19, 2022
- Bugfix: Better error-management for run the numbers #1790 (k9ert)
- Bugfix: Consecutively uploading same file twice #1776 (relativisticelectron)
- Bugfix: Fix the messed up translated html #1810 (relativisticelectron)
- Bugfix: make translations safe in jinja2 #1793 (relativisticelectron)
- Bugfix: NoneType has not attribute get in certain circumstances #1802 (k9ert)
- Bugfix: Pagination in transactions and coin selection #1778 (Manolis Mandrapilias)
- Bugfix: Search container overlaying #1787 (Manolis Mandrapilias)
- Bugfix: support extracting xpub of master xkey derivation #1797 (hodlwave)
- Chore: fix broken cirrus build cache for bitcoind #1786 (k9ert)
- Chore: migrating to hwi 2.1.0 #1693 (k9ert)
- Docs: added necessary command to build instructions #1808 (relativisticelectron)
- Docs: Mentioning Acronis as endless pacman cause #1767 (k9ert)
- Feature: Add nix shell #1798 (hodlwave)
- Feature: Extensions - Making more than one Blueprint possible  #1764 (k9ert)
- Feature: Rescan button for empty wallet #1779 (yogendra sankhla)
- UIUX: Improve the transactions view #1746 (Manolis Mandrapilias)
- UIUX: tooltips fix #1806 (relativisticelectron)

## v1.10.3 June 22, 2022
- Bugfix: Display address on device #1774 (Manolis Mandrapilias)
- Bugfix: Longer Timeout for run_the_numbers #1769 (k9ert)
- Bugfix: Rescan won't work for fullnodes without explorer #1771 (k9ert)
- Bugfix: Send max with multiple recipients #1744 (Harshit)
- Bugfix: Start_specter ran twice in sub_open #1768 (k9ert)
- Bugfix: Visual artifact in the electron settings dialog #1754 (djpnewton)
- Chore: Making text-explainer a webcomponent #1752 (Shlok Pandey)
- Chore: Refactor_wallet_manager #1667 (k9ert)
- Docs: Corrected links in development.md #1742 (Ankur)
- Feature: combined test script for cypress and pytest #1749 (relativisticelectron)
- Feature: Drag and drop for PSBT import #1758 (Shlok Pandey)
- UIUX: Fixed html character codes for multisig guide & polishment of about page #1743 (Manolis Mandrapilias)

## v1.10.2 June 03, 2022
- Feature: Basic auth in electron #1730 (djpnewton)
- Feature: Multisig beginner guide #1731 (relativisticelectron)
- Bugfix: Corrected build instructions and made virtuelenv name dynamic #1735 (relativisticelectron)
- Bugfix: issues while using specter as library #1740 (k9ert)
- Bugfix: PDF backup does not open for multisig #1741 (k9ert)
- UIUX: fix typo in error_logs #1739 (Bufo)

## v1.10.0 May 27, 2022
- Feature: adding has_service() method to user #1732 (Kim Neunert)
- Feature: Choose file button for labels import #1682 (Manolis)
- Feature: Customised front end for adding Electrum devices #1622 (relativisticelectron)
- Feature: introducing gunicorn as an alternative WSGI HTTP Server #1721 (Kim Neunert)
- Feature: Message signing via QR code #1567 (Manolis)
- Feature: new extensionpoint specter_persistence_callback #1723 (Kim Neunert)
- Feature: Optimized uncle jim pdf for the Debasafebags. #1706 (f9ert)
- Bugfix: add proper uid to initial config fixes #1714 #1715 (Kim Neunert)
- Bugfix: better error-handling and version checks #1691 (Kim Neunert)
- Bugfix: wrong arguments for requests_session #1719 (Kim Neunert)
- Chore: Adjusted releasing process and adding liquidissuer  #1716 (Kim Neunert)
- Chore: Bump ejs from 3.1.5 to 3.1.7 in /pyinstaller/electron #1697 (dependabot[bot])
- Chore: Change Specter compatibility to ">=3.7,<3.10" #1707 (relativisticelectron)
- Chore: Docker #1696 (Aaron Dewes)
- Chore: embit Upgrade to 0.4.13 (ripemd160 replacement)  #1702 (relativisticelectron)
- Chore: install_noded.sh support for elements binary #1717 (relativisticelectron)
- Chore: misc changes #1733 (Kim Neunert)
- Chore: Non-standard ports for test-cypress.sh #1729 (Kim Neunert)
- Chore: Refactor UTXO scan (and timeout bugfix for utxo_scan) #1687 (Kim Neunert)
- Chore: Removing HWIBridge initialisation on module-level #1720 (Kim Neunert)
- Chore: Upgrade black version for pre-commit #1708 (relativisticelectron)
- Chore: Introducing an issue template #1692 (Kim Neunert)
- Docs: Added support for other distros (Arch/Fedora) #1713 (Ankur)


## v1.9.4 April 28, 2022
- UIUX: Overhaul of UTXO list, handling of locked UTXOs and scrollbar added #1580 (Manolis)
- Bugfix: i18n issue preventing historical proces to work in edge cases #1664 (Kim Neunert)
- Feature: More languages supported for BIP39 mnemonic import #1660 (Kim Neunert/Manolis)
- Docs: Architectural notes #1673 (Kim Neunert)
- Docs: Fix extra / in url in service.md #1659 (Brendan Murphy)
- Chore: Bump electron from 11.5.0 to 13.6.9 #1647 (Kim Neunert)
- Chore: Bump async from 3.2.0 to 3.2.3 #1674 (dependabot[bot])
- Chore: Bump minimist from 1.2.5 to 1.2.6 in /pyinstaller/electron #1637 (dependabot[bot])
- Chore: Updating cypress from 7.1.0 to 9.5.4  #1672 #1676 (Kim Neunert)
- Chore: Upgrade flask (and others) from 1.1.4 to 2.1.1 #1666 (Kim Neunert)

## v1.9.2 April 04, 2022
- Bugfix: Tzdata module missing on windows fixes #1653 #1654 (Kim Neunert)

## v1.9.1 April 02, 2022
- Bugfix: opening non-installed extensions in new window #1650 (Kim Neunert)
- Bugfix: price provider uses wrong user #1640 (Kim Neunert)
- Bugfix: Restore editing of labels #1649 (Kim Neunert)
- Chore: Bump ansi-regex from 4.1.0 to 4.1.1 in /pyinstaller/electron #1643 (dependabot[bot])
- Chore: Bump minimist from 1.2.5 to 1.2.6 #1639 (dependabot[bot])
- Chore: Update elements to 0.21.0.2 #1641 (Kim Neunert)

## v1.9.0 March 30, 2022
- Feature: added better scrollbar for all table-style-lists #1598 (relativisticelectron)
- Feature: CLI and a publishing model for extensions #1566 (Kim Neunert)
- Feature: Import of raw transaction #1591 (relativisticelectron)
- Feature: initial devhelper extension #1547 (Kim Neunert)
- Feature: introduction of url-prefixes and defaults #1561 (Kim Neunert)
- UIUX: add Added hover titles #1621 (relativisticelectron)
- UIUX: Add margin under Device type dropdown #1616 (cypherhoodlum)
- UIUX: Adds KYC warning and link to learn more #1560 (kdmukai)
- UIUX: Add two missing titles in the settings bar #1618 (cypherhoodlum)
- UIUX: Placeholder for amount send #1545 (VCBhatawadekar)
- UIUX: Redesign the main page #1620 (cypherhoodlum)
- UIUX: Renaming and static plugin list teasering + refactoring #1569 (Kim Neunert)
- UIUX: Update icon for Passport signing device #1589 (BitcoinQnA)
- Buffix: Electrum PSBT import fixes #1544  #1548 (relativisticelectron)
- Bugfix: App Icon for Gnome Doc #1158 #1592 (salderma)
- Bugfix: Chore - update black to fix linter failure #1642 (Kim Neunert)
- Bugfix: electrum single-sig wallet import #1573 (relativisticelectron)
- Bugfix: Fixed missing vsize in tx.  This led to no available feerate for RBF #1585 (relativisticelectron)
- Bugfix: fixing the logging-system screwup #1578 (Kim Neunert)
- Bugfix: logging error, caused by passing 2 arguments #1576 (relativisticelectron)
- Bugfix: OAuth2_hostname #1579 (Kim Neunert)
- Bugfix: Price data edge-case, fixes #1554 #1624 (Kim Neunert)
- Bugfix: refactor and fix css #1607 (Kim Neunert)
- Bugfix: Release-process #1608 (Kim Neunert)
- Bugfix: Reserving too many addresses at Swan, fix v2; Bugfix: admin change password #1563 (kdmukai)
- Bugfix: TXs in csv and in the UI now get blocktime for time if confirmed fixes #1552  #1559 (Kim Neunert)
- Bugfix: upgrade pyinstaller #1556 (Kim Neunert)
- Bugfix: versionChecker and downloadloc #1633 (Kim Neunert)
- Chore: Build Script improvements #1612 (Kim Neunert)
- Chore: Bump follow-redirects from 1.14.4 to 1.14.7 #1557 (dependabot[bot])
- Chore: Bump follow-redirects from 1.14.7 to 1.14.8 #1590 (dependabot[bot])
- Chore: Migrate to elements v0.21.0.1 #1601 (Kim Neunert)
- Chore: some build-improvements #1603 (Kim Neunert)
- Chore: Service class refactoring #1623 (Kim Neunert)
- Chore: Price Provider and error-management #1551 (Kim Neunert)
- Docs: Changes that didn't make into merge commit for #1591 #1611 (Manolis)
- Docs: Fix various typos and grammatical errors #1606 (Matt Wesley)
- Docs: Update docs/reverse-proxy.md #1587 (GoofyAF)
- Docs: Update daemon.md #1586 (GoofyAF)


## v1.8.0 January 29, 2022
- Feature: Add Jade multisig support #1520 (Stepan Snigirev)
- Feature: add liquid-testnet support #1527 (Stepan Snigirev)
- Feature: Allow descriptors with xpubs but without derivations (just wpkh(xpub) ) for wallet imports  #1519 (Stepan Snigirev)
- Feature: search improvements #1497 (Kim Neunert)
- Feature: Send dialog refactored and sped up #1454 (Kim Neunert)
- Feature: Service integration - Swan #1517 (kdmukai)
- Bugfix: Coin selection - unselection via toggle #1536 (Manolis)
- Bugfix: deactivate internal Tor for non-AppImages #1499 (Kim Neunert)
- Bugfix: Edge case for electrum label import #1542 (relativisticelectron)
- Bugfix/Feature: Restoring send functionalities and better address validation and fee selection #1532 (Manolis)
- Bugfix: Final Swan service updates #1533 (kdmukai)
- Bugfix: fix jade signing of unconfidential inputs #1528 (Stepan Snigirev)
- Bugfix: fix keypoolrefill perfomance and adjusted callback logic #1508 (Kim Neunert)
- Bugfix: Multiple send bug fixes #1538 (Manolis)
- Bugfix: prevent using keys twice #1500 (Kim Neunert)
- Bugfix: Restore ability to import address labels of unlabeled addresses #1511 (relativisticelectron)
- Bugfix: Revision of test-new-releases.md #1529 (Manolis)
- Bugfix: Servicediscovery in pyinstaller-packages (specterd) #1531 (Kim Neunert)
- Bugfix: service icons breaking liquid #1534 (Stepan Snigirev)
- Bugfix: Very last fixes for Service swan #1537 (Kim Neunert)
- Documentation: message signature #1310 (Kim Neunert)
- Documentation: added endless pacman troubleshooting Guide #1498 (Kim Neunert)
- Documentation: Create document for testing-setups and cleaning up swan #1526 (Kim Neunert)
- Documentation: Update Donation Link #1514 (Moritz)
- I18N: Fixed the translation error. #1507 (2a3dex)
- UIUX: Added suggestion to quit other wallet software when connecting HWI over USB #1535 (Lobbelt)
- UIUX: Improve behaviour for apps #1540 (Kim Neunert)
- UIUX: Fixed help text #1510 (relativisticelectron)
- Chore: Bump HWI to 2.0.2 #1522 (Michael Henke)
- Chore: Fix running bitcoind with docker #1523 (Kim Neunert)

## v1.7.2 November 30, 2021
- Feature: Default blockchain rescan to first Taproot block for Taproot wallets #1479 (kdmukai)
- Feature: Encrypted user data storage #1453 (kdmukai)
- Feature: More options for address labels imports #1470 (Manolis)
- Feature: Improved export and restore hot wallet process #1495 (singlatushar07)
- Bugfix: Adds `no_wait` option to rpc calls #1485 (kdmukai)
- Bugfix: Adjust build-badge to Cirrus #1464 (Kim Neunert)
- Bugfix: csrf-exempt for /toggle_hide_sensitive_info endpoint #1478 (Kim Neunert)
- Bugfix: Custom autohide bugfix #1468 (kdmukai)
- Bugfix: Default state for left nav "Devices" should be hidden #1481 (kdmukai)
- Bugfix: 'Specter' object has no attribute 'user_manager' #1476 (Manolis)
- Bugfix: tests on master #1465 (Kim Neunert)
- Documentation: hosted at docs.specter.solutions #1463 (Kim Neunert)
- Chore: Taproot test case #1482 (kdmukai)

## v1.7.1 November 05, 2021
- Bugfix: Bitcoin Core as default for fee estimation, error handling improvements #1408 (Kim Neunert)
- Bugfix: fix unknown version bug in pip-installs fixes #1442 #1450 (Kim Neunert)
- Bugfix: no threading for update after creation of wallets #1457 (Kim Neunert)
- Bugfix: version.txt does not get detected #1462 (Kim Neunert)
- Chore: Bump electron from 10.2.0 to 11.5.0 in /pyinstaller/electron #1429 (dependabot[bot])
- Chore: Release signature process #1459 (Kim Neunert)

## v1.7.0 October 19, 2021
- Feature: a framework for migrations and migrating single-node #1414 (Kim Neunert)
- Feature: Auto privacy settings #1415 (kdmukai)
- Feature: Better Error-management, logging for the APP and Macos builds improvements #1405 (Kim Neunert)
- Feature: fix rbf-edit with multiple destinations #1412 (Stepan Snigirev)
- Feature: Improve Jade support #1398 (Stepan Snigirev)
- Feature: Uncle jim paperwallet #1359 (Kim Neunert)
- Feature: use change addresses in order #1393 (Stepan Snigirev)
- Bugfix: asset labels issues #1391 (Stepan Snigirev)
- Bugfix: Babel js backtick fix #1383 (kdmukai)
- Bugfix: changing type of a device fixes #1400 #1257 #575 #1402 (Stepan Snigirev)
- Bugfix: CI failure because of missing wget dependency #1375 (Kim Neunert)
- Bugfix: fixes #1357 as pip3 installation of tar.gz-package was broken #1374 (Kim Neunert)
- Bugfix: Refactor wallet class fixes #1394 #1367 #1241 #1101  #1411 (Stepan Snigirev)
- Bugfix: refactor WalletManager and Wallet, improved performance #1424 (Kim Neunert)
- Bugfix: rollback embit to 0.4.5 #1379 (Kim Neunert)
- Bugfix: Some liquid fixes #1401 (Stepan Snigirev)
- Bugfix: tx dump (failing tests) #1397 (Stepan Snigirev)
- Bugfix: various things including json-file data-corruption #1410 (Kim Neunert)
- Bugfix: remove diy simulator warning #1399 (Stepan Snigirev)
- Bugfix: Fix last release liquid issues #1389 (Stepan Snigirev)
- Bugfix: Fix the Test Tor point of reference #1416 (benk10)
- Bugfix: Leading slashes in paths removed #1380 (B-396)
- Docs: Suggest updating pip to resolve `cryptography` installation issues #1349 (Nadav Ivgi)
- Translation: Added localization function to html text #1396 (relativisticelectron)
- Chore: Bump axios from 0.21.1 to 0.21.4 #1387 (dependabot[bot])
- Chore: Ci improvements (#103) #1403 (Kim Neunert)
- Chore: migrate tested bitcoin to new v0.21.1 tag #1316 (Kim Neunert)
- Chore: Release process improvements #1434 (Kim Neunert)
- Chore: Some macos specific adjustments to the install and test-cypress scripts #1428 (Kim Neunert)
- Chore: update dependencies and remove demon-mode #1417 (Kim Neunert)
- Chore: update elements test_target to 0.21.0_rc2 #1409 (Kim Neunert)

## v1.6.0 August 27, 2021
- Devices: Add Passport support #1343 (benk10)
- Devices: Improved Liquid support for Specter-DIY #1358 (Stepan Snigirev)
- Bugfix: Fix Liquid addresses UTXO count #1350 (benk10)
- Bugfix: Fix add keys #1355 (Tushar Singla)
- Bugfix: Fix key import on liquid #1370 (Stepan Snigirev)
- Bugfix: Fix imported labels not being saved #1362 (relativisticelectron)
- Bugfix: Fix add key functionality for hot wallets #1354 (Tushar Singla)
- Bugfix: Use the configured bitcoind data directory #1348 (Nadav Ivgi)
- Bugfix: Delete pending psbts if inputs were spent #1366 (Stepan Snigirev)
- Bugfix: Fix amount and label parsing #1368 (Stepan Snigirev)
- Bugfix: Fix assetlabel and default asset properties for bitcoin #1351 (Stepan Snigirev)
- Feature: Add Export Specter Format for wallets #1345 (Hani Mohammed)
- Feature: Add assets registry for Liquid wallets #1360 (benk10)
- Feature: Add single-key taproot support #1364 (Stepan Snigirev)
- Docs: run tests and avoid elm-tests if you don't want them #1326 (Kim Neunert)
- UI: More information while backing up specter data #1346 (Tushar Singla)
- UI: Warn user when hidden advanced fields are not empty #1356 (benk10)
- UI: Fetch asset labels #1352 (Stepan Snigirev)
- Chore: Bump path-parse from 1.0.6 to 1.0.7 in /pyinstaller/electron #1344 (dependabot[bot])
- Chore: pytest for Electrum address label import #1363 (relativisticelectron)

## v1.5.1 August 10, 2021
- Bugfix: Add newline char when writing bitcoin.conf setting #1325 (jeffthibault)
- Bugfix: Fix specifying datadir for internal node #1315 (benk10)
- Bugfix: Fix login issue for non-English mode #1321 (Kim Neunert)
- Bugfix: Fix Electrum import issues #1318 (benk10)
- Bugfix: Update rpc None error #1333 (Hani Mohammed)
- Bugfix: Fix wallet PDF backup issues #1338 (benk10)
- Feature: Electrum address label import #1314 (relativisticelectron)
- Translation: Update Greek translation  #1317 (glowleaf)
- Translation: Update Hebrew translation #1308 (Sh0ham)
- Translation: Update French translation #1309 (KST-Energy)
- UIUX: Add RTL languages support #1276 (benk10)
- Chore: Automatic Testing and Documentation for Liquid #1286 (Kim Neunert)
- Chore: Refactor internal keypool management #1330 (benk10)
- Chore: Refactor out ugly hack in components JS #1302 (benk10)
- Chore: Make Specter DIY simulator connection error message more descriptive #1337 (Tushar Singla)

## v1.5.0 July 16, 2021
- Feature: Translation (Babel) integration and initial translations #1247 (kdmukai, 2a3dex, rafa1239, Volker Herminghaus, glowleaf, DirkVdk, mutatrum, Kryptoministern, PommbearBTC, Gummybear, sreshta suresh, KST-Energy, alltheseas, dudezoo, Sergei Tikhomirov, Bitpaint)
- Feature: Api framework #1232 (Kim Neunert)
- Bugfix: Delete raw transactions when wallet is deleted #1300 (Stepan Snigirev)
- Bugfix: Fix error when importing transaction #1259 (benk10)
- Bugfix: Fix multi-hot-multisig signing #1294 (Stepan Snigirev)
- Bugfix: Fix saving a transaction as pending #1261 (benk10)
- Bugfix: Fix test connection crash when node can't be reached #1285 (benk10)
- Chore: Improve logging #1282 (Kim Neunert)
- DevOps: Removing blobs and adjusting automations #1299 (Kim Neunert)
- Translation: Update Portuguese translation #1277 (bitsenca)
- Translation: Update Portuguese translation #1279 (KoreaComK)
- Translation: Update Spanish translation (2a3dex)
- Translation: Update Hebrew translation #1288 (Sh0ham)
- Translation: Update messages.po #1290 (Pat4cryptoFR)
- Translation: Update messages.po #1293 (alltheseas)
- Translation: Update French translation #1297 (KST-Energy)
- Translation: Update French translation #1305 (KST-Energy)
- Translation: Update Chinese (Simplified) translation #1275 (kdmukai)
- Translation: Update to Chinese (Traditional) translations #1274 (kdmukai)
- Docs: Adds steps to install Rust compiler dependency #1303 (kdmukai)
- Docs: more details about missing funds #1254 (Kim Neunert)
- Docs: Updates Babel README to remove temporary `kdmukai` fork references #1269 (kdmukai)
- Liquid: Disable elements hot wallet for bitcoin wallets #1295 (Stepan Snigirev)
- Liquid: Add support for unconfidential addresses #1292 (Stepan Snigirev)
- Liquid: Fix addressinfo lookup and category assignments #1296 (Stepan Snigirev)
- Liquid: Fix change address derivation #1304 (Stepan Snigirev)
- Liquid: Fix fee estimation on liquid #1289 (Stepan Snigirev)
- Liquid: Fix nested segwit wallets on liquid #1298 (Stepan Snigirev)
- Liquid: Minor liquid fixes #1301 (Stepan Snigirev)
- Liquid: TxList and AddressList classes for Liquid #1280 (Stepan Snigirev)

## v1.4.6 June 28, 2021
- Feature: Add Keystone device #1237 (Stepan Snigirev)
- Feature: Export device types and labels #1226 (kdmukai)
- Feature: Liquid - asset support #1216 (Stepan Snigirev)
- UIUX: Redesign the Tor settings screen #1245 (benk10)
- Bugfix: Apostrophes in device labels need proper escaping in PDF export template #1246 (kdmukai)
- Bugfix: cleanup annoying test_artifacts #1236 (Kim Neunert)
- Bugfix: Filter non liquid devices from create liquid wallet #1243 (benk10)
- Bugfix: fix elementsd process #1240 (Stepan Snigirev)
- Chore: Bump normalize-url from 4.5.0 to 4.5.1 in /pyinstaller/electron #1223 (dependabot[bot])
- Chore: Bump urllib3 from 1.25.10 to 1.26.5 #1211 (dependabot[bot])
- Chore: Wallet new refactoring #1244 (Kim Neunert)
- Chore: del elm comp from gitlab + ensure master green #1250 (Kim Neunert)
- Chore: refactor psbt-creation #1249 (Kim Neunert)
- Chore: Refactor wallet creation to Wallet.create method #1242 (Stepan Snigirev)

## v1.4.5 June 16, 2021
- Feature: Add Blockstream Jade support #1234 (benk10)
- Feature: Add SeedSigner device #1225 (Stepan Snigirev)
- Feature: Show Liquid icon on node manager #1224 (benk10)
- Bugfix: `non_witness_utxo` hash mismatch problem #1235 (Stepan Snigirev)
- Bugfix: RPC-password as pin for multiple nodes #1231 (Kim Neunert)
- Bugfix: Missing prop setter bugfix #1228 (kdmukai)
- Bugfix: "NameError: name 'protocol' is not defined" #1229 (DerM007)
- Chore: Elements testing #1212 (Kim Neunert)


## v1.4.3 June 10, 2021
- Bugfix: add some liquid fixes #1194 (Stepan Snigirev)
- Feature: Fully unblind liquid transactions sent by Specter #1220 (Stepan Snigirev)

## v1.4.2 June 01, 2021
- Bugfix: unconventional derivations fail regexes #1204 (Stepan Snigirev)
- Chore: Simplify emptiness checks in txlist #1202 (Roman Zeyde)

## v1.4.1 May 30, 2021
- Bugfix: a few typos #1201 (Roman Zeyde)
- Bugfix: Set http as default network protocol if non specified #1199 (benk10)
- Bugfix: Update Tor circuit every request #1200 (benk10)

## v1.4.0 May 28, 2021
- Feature: Broadcast transactions over block explorer via Tor #1183 (benk10)
- Feature: "Verify on device" with Coldcard sugggest using airgap instead of USB connection #1157 (Manolis)
- Feature: Merge in Liquid branch (preparation for Liquid support) #1174 (benk10)
- Feature: Support importing BIP48 xpubs from JSON #1156 (benk10)
- Feature: Managing more than one Node-connection and switch between them #1146 (benk10)
- Feature: Managing multiple internal nodes with testnet(s) support #1165 (benk10)
- Feature: Hide sensitive info mode #1170 (benk10)
- Feature: Add cancel transaction with RBF button and show cancelled transactions status #1197 (benk10)
- UIUX: Updated change text from 'payed' to 'paid' in fee_selection file #1155 (Chris Pollard)
- UIUX: Move backup PDF SLIP132 option to advanced section #1168 (benk10)
- Docs: Update tor.md #1129 (benk10)
- Bugfix: Improve Tor resilience #1161 (Kim Neunert)
- Bugfix: Fix issue with selecting remote USB option #1147 (benk10)
- Bugfix: Fix unremovable linebreak in address label #1171 (benk10)
- Bugfix: Update compatibility for Bitcoin Core v22 "addresses" RPC changes #1180 (benk10)
- Bugfix: Fix broadcast via block explorer #1191 (benk10)
- Bugfix: Fix sensitive info notification and xpub hiding #1189 (benk10)
- Bugfix: Fix xpub format when no node is used #1188 (benk10)
- Bugfix: Fix updating addresses list caching for wallets using Bitcoin Core native wallet descriptors #1193 (benk10)
- Chore: Bump embit version #1186 (Stepan Snigirev)
- Chore: Bump flask-cors from 3.0.8 to 3.0.9 #1149 (dependabot[bot])
- Chore: Bump hosted-git-info from 2.8.8 to 2.8.9 in /pyinstaller/electron #1154 (dependabot[bot])
- Chore: Bump lodash from 4.17.20 to 4.17.21 in /pyinstaller/electron #1159 (dependabot[bot])
- Chore: Update hidapi to 0.10.1 #1141 (Leon Costa)
- Chore: Update hwibridge.md #1178 (kdmukai)
- Chore: Upgrade internal bitcoind version to v0.21.1 #1173 (benk10)

## v1.3.1 April 26, 2021
- Feature: Add unconfirmed tx fees data  #1085 (benk10)
- Feature: Use RPCAuth instead of username + password #1093 (benk10)
- Feature: Return to/ cancel setup process #1091 (benk10)
- UIUX: Show user-friendly error messages when session expires #1087 (benk10)
- UIUX: Use Bitcoin icon set #1080 (benk10)
- Docs: Update faq.md #1123 (Kim Neunert)
- Docs: added build-instructions #1077 (Kim Neunert) 
- Bugfix: BitBox02 timeout issue #1090 (benk10)
- Bugfix: Fix crash if estimatesmartfee fails #1086 (benk10)
- Bugfix: typo/exception #1102 (djpnewton)
- Bugfix: #1073 #1094 (benk10)
- Bugfix: #987 #1088 (benk10)
- Bugfix: arrow down svg #1125 (benk10)
- Bugfix: del user with wallets #1126 (Stepan Snigirev)
- Bugfix: month names #1069 (Kim Neunert)
- Bugfix: truncated PDF #1095 (benk10)
- Bugfix: UI issues #1084 (benk10)
- Bugfix: using correct image for gitlab #1127 (Kim Neunert)
- Bugfix: Improve tx-table and addresses-table render performance #1122 (Will Cosgrove)
- Chore: Bump y18n from 5.0.4 to 5.0.8 in /pyinstaller/electron #1114 (dependabot[bot])
- Chore: Refactoring new device setup #1111 (benk10)
- Chore: allow python version 3.9.X after upgrade to HWI 2.0.1 #1104 (djpnewton)
- Chore: upgrade wait-on and axios #1124 (Kim Neunert)
- Chore: refactor check_methods out of specter #1106 (Kim Neunert)
- Chore: Refactor setup wizard #1120 (benk10)

## v1.3.0 March 29, 2021
- Bugfix: bump embit version, add secp binary #1031 (Stepan Snigirev)
- Bugfix: consolidations issue #1034 (benk10)
- Bugfix: Default bitcoind timeout to 60s for all platforms #1044 (kdmukai)
- Bugfix: Raspberry Pi check; fixing breaking changes when not using built-in Tor #1037 (kdmukai)
- Bugfix: Remove potentially non-final txid #1011 (benk10)
- Bugfix: auto-escaping of wallet.account_map json in pdf backup #976 (djpnewton)
- Bugfix: typo #1008 (Jan Rothen)
- Bugfix: HWI2 integration issues #1045 (benk10)
- Bugfix: misc Fixes for pre-release, mainly proper tor shutdown (#1048) (benk10)
- Bugfix: fix fill_psbt #1050 (Stepan Snigirev)
- Bugfix: exit cleanup #1053 (benk10)
- Bugfix: Fix Windows pyinstaller typo #1064 (benk10)
- Bugfix: Pre release minor fixes #1055 (benk10)
- Bugfix: Remove scientific notations #1067 (benk10)
- Bugfix: Update Bitcoin Core data dir even when installed and update Cobo Vault instructions #1056 (benk10)
- Bugfix: Remove download attribute from link #1061 (Taylor Helsper)
- Chore: Bump jinja2 from 2.11.2 to 2.11.3 #1033 (dependabot[bot])
- Chore: Some more Cypress tests #970 (benk10)
- Chore: Re-applying config change to pass Black formatting #1003 (kdmukai)
- Chore: Cypress travis #997 (Kim Neunert)
- Chore: Bump HWI to 2.0.1 #1060 (benk10)
- Chore: Refactor node setup state and timeout #1058 (benk10)
- Docs: added signature-verification to FAQ #1042 (Kim Neunert)
- Docs: Update DEVELOPMENT.md for Raspi #1032 (kdmukai)
- Docs: update to specify correct docker tag #971 (kdmukai)
- Docs: Fixed typos in faq.md #1004 (Dimitris Tsapakidis)
- Docs: Add link to RaspiBlitz connection guide #1041 (d11n)
- Feature: Add "Abandon transaction" option for low fee txs that have been purged from the mempool #991 (kdmukai)
- Feature: Add full edit transaction for RBF #998 (benk10)
- Feature: Add mempool.space as an option for fee estimation and block explorer #1020 (benk10)
- Feature: many more currencies to the price provider #1021 (benk10)
- Feature: Move wallets loading process to background #1017 (benk10)
- Feature: Setup Bitcoin Core from Specter #1007 (benk10)
- Feature: Show wallets overview for / , resolves #1018 #1019 (benk10)
- Feature: improved the description of the CLI arguments/options #984 (8go)
- Feature: Logging improvements #1043 (Kim Neunert)
- Feature: Move to HWI v2 #1001 (benk10)
- Feature: Specter-DIY: add sd card support #1047 (Stepan Snigirev)
- Feature: Adding regular logs to core-settings-page #1065 (Kim Neunert)
- Feature: Call the checker more often if IBD #1059 (benk10)
- Feature: Pre download core and tor binaries #1062 (benk10)
- UIUX: changing the background color of that input/output (using colors based on the send/receive svg icons) #989 (djpnewton)
- UIUX: HWI Bridge design improvement #1015 (benk10)
- UIUX: Timeout management and other improvements #1057 (Kim Neunert)
- UIUX: Only tor quicksync warning #1054 (Kim Neunert)

## v1.2.0 February 20, 2021
- Bugfix: a minor bug that always shows address as used #927 (jleo84)
- Bugfix: cypress-tests #961 (Kim Neunert)
- Bugfix: Fix key initial format in wallet info #925 (benk10)
- Bugfix: Use the request session API for authentification #958 (Jürgen Hötzel)
- Chore: Bump cryptography from 3.2 to 3.3.2 #943 (dependabot[bot])
- Chore: enable dev-restart-login #960 (Kim Neunert)
- Chore: fix release-notes #928 (Kim Neunert)
- Docs: Typos #941 (Max Hillebrand)
- Feature: Add failed wallets popup #952 (benk10)
- Feature: Freeze UTXO and select UTXO for new transaction from the UTXO tab #956 (benk10)
- Feature: Use descriptor wallet for Bitcoin Core >= v0.21.0 #737 (Sjors Provoost)
- UIUX: Add reason for why device is disabled in new wallet screen #932 (benk10)
- UIUX: pass result of createpsbt call back to calculateEstimatedFee #945 (djpnewton)
- UIUX: Preserve form status when creating a transaction #938 (djpnewton)

## v1.1.0 January 30, 2021
- Bugfix: #784 URL encode to prevent breaking characters on RPC connection #866 (Maxi Dev)
- Bugfix:  #829 - font size and horizontal alignment #900 (Patrick)
- Bugfix: Check whether tx address contains list before enumerating it #855 (Ondrej Calda)
- Bugfix: Fix #605 - Display UI notification after btc core connection test #912 (Patrick)
- Bugfix: Fix key purpose labeling being overwritten #887 (benk10)
- Bugfix: Fix no block height with Bitcoin Core v0.19 #859 (benk10)
- Bugfix: Fix tx info showing wrong input address #865 (benk10)
- Bugfix: ugly fix utxo blockexplorer rescan #897 (Stepan Snigirev)
- Bugfix: Util testing  and small bugfix about multisig treshold  #698 (Manolis)
- Chore: Bump electron from 10.1.3 to 10.2.0 in /pyinstaller/electron #916 (dependabot[bot])
- Devops: Added PyCharm IDE configuration + fixed DEVELOPMENT.md title level hierachy (incl. TOC) #892 (paeet)
- devops: Fixed deprecation warnings #894 (Patrick)
- Devops: Specify that hwi is not compatible with Python 3.9 #883 (Franck Royer)
- Docs: Add existing file #846 (bitballin)
- Docs: Add more info to connect Desktop via TOR #847 (Ramon Tayag)
- Docs: add multisig tradeoffs note and doc #885 (djpnewton)
- Docs: add notes about built in authentication methods #871 (djpnewton)
- Docs: Removing high level consulting request #901 (Callum Macdonald)
- Docs: Update connect-your-node.md #893 (fatrattombala)
- Feature: Add addresses tab allowing users to navigate through derived addresses #781 (jleo84)
- Feature: Added persistent tor setting. #848 (Raj)
- Feature: add rate limiting and registration link expiry #852 (djpnewton)
- Feature: address-tab pagination, sorting and exporting to CSV #873 (jleo84)
- Feature: Auth improvements #860 (benk10)
- Feature: Get whitepaper via timechain #905 (Manolis)
- Feature: improve hints for not working connections #888 (Kim Neunert)
- Feature: Replace address list on receive tab with addresses tab #914 (benk10)
- Feature: SLIP-132 switch for PDF backup key format #849 (Maxi Dev)
- Feature: Support Cobo single key files #915 (benk10)
- UIUX: Add target="_blank" for help links #911 (benk10)
- UIUX: fixed typos in wallet_receive.jinja and wallet_settings.jinja #853 (Zach Zager)
- UIUX: Fixes - TX table toolbar alignment, Network label alignment #899 (Patrick)
- UIUX: Fix typo (puropse -> purpose) #898 (Stacie)
- UIUX: Fix Typos #879 (Franck Royer)
- UIUX: Keep slashes and parentheses in tx labels #861 (Ondrej Calda)
- UIUX: Make `Add Keys` more obvious #884 (Franck Royer)

## v0.11.0-pre1 December 21, 2020
- Feature: Tor settings and tor_only mode #765 (benk10)
- Feature: adding automatic ssl-creation #789 (Kim Neunert)
- Feature: Export CSV data functionality for all table-data with optional historical price data  #758 (benk10)
- Feature: Refactor History Tab and Search in history  #760 (benk10)
- Feature: Cypress Frontend-testing #712 (Kim Neunert)
- docs: fixes #769 #773 (Kim Neunert)
- Bugfix: Remove Notification instead of logging out #755 #791 (benk10)
- Bugfix: wallet name bug in json backup download #790 (Raj)
- Bugfix: Catch exception if addres not found in wallet #783 (benk10)
- Bugfix: spelling #766 (Stevie Zollo)
- UIUX: Switched Address to Label #720 #764 (figgyfigs)

## v0.10.2 December 5, 2020
- HWI: Update udev rules for Specter DIY (#742) (@stepansnigirev)
- HWI: Update communication with Specter DIY (#746) (@stepansnigirev)
- Bugfix: Fix RBF for UTXO consolidation and wrong fee on import tx (#744) (@ben-kaufman)
- Bugfix: Remove export wallet from cc and cobo for singlesig (#743) (@stepansnigirev)
- Bugfix: Fix transaction times issue with Bitcoin Core (#738) (@ben-kaufman)
- Bugfix: Support parsing changed electrum files from Coldcard (#736) (@stepansnigirev)
- Bugfix: Remove listwalletdir call from wallet manager checker (#734) (@stepansnigirev)
- Bugfix: Fix Trezor and Keepkey multisig address verification (#733) (@stepansnigirev)
- Bugfix: Show QR code address verification only for Specter-DIY (#714) (@ben-kaufman)
- Bugfix: Fix typo with links (target="blank" => target="_blank")(#703) (@stepansnigirev)
- Bugfix: Add .python-version to .gitignore (#699) (@Sjors)
- Bugfix: Allow renaming admin account and a few bug fixes (#732) (@ben-kaufman)
- Bugfix: Fix typo:manual configuration (#739)
- Feature: Electrum import and export support (#721) (@ben-kaufman)
- UI: Mobile friendly UI (#731) (@ben-kaufman)
- UI: Add transaction data popup (#692) (@ben-kaufman)
- UI: Move toggling price functionality to the right toolbar (#691) (@ben-kaufman)
- Refactoring: Break down the controller into endpoints (#726) (@ben-kaufman)
- Dependencies: Update pyinstaller requirements.txt (#745) (@ben-kaufman)
- Dependencies: Bump embit version (#728) (@stepansnigirev)
- Dependencies: Update dependencies and use Bitcoin Core v0.20.1 for tests (#687) (@k9ert)
- Devops: Bitcoind without docker (#686) (@k9ert)
- Docs: Update FAQ on how to recover password (#727) (@k9ert)
- Docs: Update FAQ on how to upgrade Specter Desktop (#702) (@k9ert)

## v0.10.0 November 21, 2020
- HWI: Fix integration with Ledger running the latest Bitcoin app (1.5.1) (#650) (@ben-kaufman)
- HWI: Fix BitBox02 integration (#652) (@ben-kaufman)
- Bugfix: Fix spelling mistake (#589) (@danielnordh)
- Bugfix: Fix infinite pacman on backup (#576) (@stepansnigirev)
- Bugfix: Specifying python version better (#574) (@k9ert)
- Bugfix: Fix issue with error popup on Electron app (#609) (@ben-kaufman)
- Bugfix: Fix failing to write backup causing wallet to disappear (#612) (@ben-kaufman)
- Bugfix: Fix isascii for Python3.6 (#623) (@stepansnigirev)
- Bugfix: Fix raw transaction processing (#626) (@stepansnigirev)
- Bugfix: Add context menu to Electron app (#637) (@ben-kaufman)
- Bugfix: Remove "ban" over BIP44 xpubs and set default network to mainnet if Bitcoin Core not detected (#643) (@stepansnigirev)
- Bugfix: Fix paste psbt/ xpub prompts for desktop app + fix typo causing adding multisig issue (#649) (@ben-kaufman)
- Bugfix: Fix signing issue with coldcard and cobo when cosigners' derivation path is not specified properly (#653) (@stepansnigirev)
- Feature: Support Specter file format in import wallet screen (#580) (@ben-kaufman)
- Feature: Use sat/vbytes as fee unit everywhere (#582) (@ben-kaufman)
- Feature: Bundle Tor with macOS and Windows desktop apps (#610) (@ben-kaufman)
- Feature: Add connect to node with QR code option (#611) (@ben-kaufman)
- Feature: Wallet PDF backup (#614, #644) (@ben-kaufman)
- Feature: Show Bitcoin price with amounts (#622) (@ben-kaufman)
- Feature: Support using Specter as an offline signing device and coordinator (#625) (@ben-kaufman)
- Feature: Transactions and addresses caching in CSV file (#625, #639) (@ben-kaufman)
- UI: Add icons for all devices types (#592) (@stepansnigirev)
- UI: New device wizard and various UI improvements (#598, #636, #641) (@ben-kaufman)
- UI: Export wallet from new wallet wizard (#624) (@ben-kaufman)
- UI: Addresses history list pagination and indicate for each address if it is already used or not (#635) (@ben-kaufman)
- UI: Reorganize wallet settings page into tabs (#638) (@ben-kaufman)
- Feature: RBF support (#587) (@ben-kaufman)
- Refactoring: Swap to embit for xpub and address derivation (#588) (@stepansnigirev)
- Refactoring: Improve logs, refactoring and improve checker tests (#595) (@k9ert)
- Devops: Add release script (#594) (@k9ert)
- Devops: Add pre-commit configuration (#596) (@k9ert)
- Docs: Update Tor documentation (#613, #633) (@stepansnigirev)
- Docs: Add daemon documentation (#621) (@stepansnigirev)
- Test: Fix checker test (#616) (@stepansnigirev)

## v0.9.0 November 2, 2020

- Bugfix: Fix hash verification #554 (@ben-kaufman)
- Bugfix: Fix CI related fixes #551 #552 #553 (@ben-kaufman)
- Bugfix: fixes #486 support binary psbt #535 (Stepan Snigirev)
- Bugfix: fix label size #532 (Stepan Snigirev)
- Bugfix: Minor spelling fix #531 (Daniel Mross)
- Bugfix: update coldcard instructions to generic json #527 (Stepan Snigirev)
- Bugfix: Feedback again for non working Core-connections #491 (Kim Neunert)
- Bugfix: fix for proper namespace package cryptoadvance #524 (Kim Neunert)
- Bugfix: Enable macOS dock icon #520 (Chris Beams)
- Bugfix: Scanning of upper-case btc-addresses (Samourai) fixes 479 #510 (Kim Neunert)
- Bugfix: rework discovery of pip installed version #502 (Andreas Zuber)
- Bugfix: fix broken windows build #508 (Kim Neunert)
- Bugfix: Fix amount validation #516 (@ben-kaufman)
- Bugfix: Fix display address on Specter HWI and an error when creating wallets #511 (@ben-kaufman)
- Bugfix: Minor spelling change #485 (Michael Flaxman)
- Bugfix: Update HWI to 1.2.0 closes #500 #476 (#506)
- Bugfix: Blackify (#497) (@mflaxman)
- Bugfix: Specify python version <3.9 (#559) (@mflaxman)
- Performance: Add threaded checker for Bitcoin RPC calls (#558) (@stepansnigirev)
- Feature: Allow manual specterd upload for the desktop app (#560) (@ben-kaufman)
- Feature: add tx hash to psbt filename #548 (Michael Flaxman)
- Feature: backup files on write and rollback to prevent corrupt-data #542 (Stepan Snigirev)
- Feature: Use Electron for desktop app #555 #473 (@ben-kaufman)
- Feature: change wallet export to use alias instead of name #543 (Michael Flaxman)
- Feature: add page loader to get visual feedback while loading #541 (Stepan Snigirev)
- Feature: Now devices can get renamed #534 (Stepan Snigirev)
- Feature: friendly camera error message if camera unavailable #533 (Stepan Snigirev)
- Feature: electrum watch-only export #530 (Michael Flaxman)
- Feature: Improves update version checker #525 (Stepan Snigirev)
- Feature: ask for encryption password at hot wallet only if it's enabled #526 (Stepan Snigirev)
- Feature: BIP39 passphrases, custom derivations and more for hot wallets #514 (@ben-kaufman)
- Feature: Packaging pip-releases as tarballs and sha256-hashes them #523 (Kim Neunert)
- Feature: add support for non-hardened derivation for hot storage #521 (Stepan Snigirev)
- Feature: Support for url context paths #504 (kexkey)
- Feature: add pip-compile and hash support for security/reproducibility #496 (Michael Flaxman)
- Feature add pip-compile and hash support for security/reproducibility (#496) (@mflaxman)
- Feature: All code now blackified (#497) (@mflaxman)
- Refactoring: Remove RPC calls from the UI #557 (@ben-kaufman)
- Refactoring: Refactor preparation for observers #544 (Stepan Snigirev)
- Refactoring: Code Compliance via Black #497 #529 (Michael Flaxman)
- Refactoring: persistence.py #255 #403 (Kim Neunert)
- Refactoring: Update HWI to 1.2.0 #506 (@ben-kaufman)
- Docs: Hardwarewallet Troubleshooting #522 (Kim Neunert)
- Docs: Update hwibridge.md #505 (Kim Neunert)
- Docs: Update FAQ on Coin Control (@moritzwietersheim) (#563)

## v0.8.1 October 1, 2020
- Bugfix: Fix displaying address on BitBox02 (#416) (@stepansnigirev)
- Bugfix: Fix Specter not starting up if Ledger is connected and asleep (#416) (@stepansnigirev)
- Bugfix: Fix wallet-create wizard ignoring passphrase on Trezor One and KeepKey (#420) (@ben-kaufman)
- Bugfix: Fix handling of corrupted wallet file (#422) (@stepansnigirev)
- Bugfix: Fix wrong version number shown on Windows installer (#431) (@k9ert)
- Bugfix: Fix default address labeling issue when importing an old wallet (#435) (@ben-kaufman)
- Bugfix: Fix message signing with Specter-DIY (#440) (@stepansnigirev)
- Bugfix: Fix handling of Bitcoin Core's `disablewallet` mode (#461) (@ben-kaufman)
- Bugfix: Use port 8332 if port was not specified with disabled auto-detect (#462) (@stepansnigirev)
- Bugfix: Fix ColdCard multisig wallet export (#467) (@stepansnigirev)
- Bugfix: Fix Ledger failing to sign transactions with multiple inputs (#468) (@ben-kaufman)
- Bugfix: Fix wallet importing issues (#463) (@k9ert)
- Performance: Improve RPC calls speed (#419) (@stepansnigirev)
- Performance: Move version-checker to a separate thread (#421) (@stepansnigirev)
- Performance: Improve speed of the wallet UTXO tab (#457) (@ben-kaufman)
- Feature: Add addresses labels to wallet backup file (#430) (@ben-kaufman)
- Feature: Notify on desktop app when new Specter version is available (#421, #438) (@stepansnigirev)
- UI: Correct typos in main menus (#424) (@Bayernatoor)
- UI: Fix RPC connection test checkboxes CSS (#427) (@ben-kaufman)
- UI: Show total balances as percentage of the total Bitcoin supply when running the numbers (#429) (@ben-kaufman)
- UI: Show live updates of wallet rescan progress (#432) (@ben-kaufman)
- UI: Add QR code (base64) and file upload (binary, base64) support for PSBT import and export (#469) (@stepansnigirev)
- Refactoring: Add automated PEP8 checks with Black (#286) (@mflaxman)
- Refactoring: Cleaner input weight calculation for estimating transaction fees (#426) (@stepansnigirev)
- Refactoring: Blackify the codebase (#464) (@stepansnigirev)
- Docs: Update the FAQ (#437) (@calkob)
- Docs: Add a note to the README about setting `server=1` for Bitcoin Core GUI (#459) (@Maple44)

## v0.8.0 September 19, 2020
- Build: Refactor the desktop app to run Specter in a separate thread instead of from binaries (#370) (@stepansnigirev)
- Devices: [BitBox02](https://shiftcrypto.ch/bitbox02/) single-sig support (#393, #402) (@ben-kaufman, @stepansnigirev)
- Bugfix: Fix file uploading (#327) (@ben-kaufman)
- Bugfix: Properly handle errors with listwalletdir command (#331) (@stepansnigirev)
- Bugfix: Fix logging ignoring the config (#348) (@k9ert)
- Bugfix: On send screen, make the amount input steps match the unit selected (#350) (@ben-kaufman)
- Bugfix: Fix Bitcoin Core fee calculation (#350, #367, #400) (@ben-kaufman, @stepansnigirev)
- Bugfix: Remove loggings of unrelated logs (#362) (@k9ert)
- Bugfix: Fix fee unit issues by using only sat/vbyte as Specter's fee unit (#372) (@ben-kaufman)
- Bugfix: Fix wallets not showing up and inability to create wallets if a JSON file is damaged (#375)
- Feature: Add option to verify merkle root and block headers (#334) (@mflaxman)
- Feature: Allow pruned nodes to fetch from a block explorer the missing data needed for importing wallet funds when scanning for UTXO (#344) (@stepansnigirev)
- Feature: Add HWI message signing (#345) (@ben-kaufman)
- Feature: Support ColdCard Generic file export format (#349) (@stepansnigirev)
- Feature: Allow configuring the Bitcoin Core RPC connection via environment variables (#351) (@k9ert)
- Feature: Allow specifying BIP44 account number when importing device keys from USB (#360) (@ben-kaufman)
- Feature: Allow arbitrary fee rate (#379) (@stepansnigirev)
- Feature: Allow connecting to a remote Bitcoin Core node over Tor (#383) (@ben-kaufman)
- UI: Make UI mobile-friendly (watch-only mode) (#326) (@ben-kaufman)
- UI: Show current Specter version on the sidebar (#333) (@mflaxman)
- UI: Add wallet keys list to wallet settings (#335) (@ben-kaufman)
- UI: Improve scan for existing funds option when creating a wallet (#337) (@ben-kaufman)
- UI: Allow toggling SLIP-132 format in wallet settings keys list (#343) (@ben-kaufman)
- UI: Add send max amount button (#350) (@ben-kaufman)
- UI: Add free-text transaction creation editor (#350) (@ben-kaufman)
- UI: Add total transaction fee preview when composing a transaction (#350) (@ben-kaufman)
- UI: Add tooltip to the Tor button (#364) (@ben-kaufman)
- UI: Allow resizing QR codes used for communications with airgapped wallets (#380) (@ben-kaufman)
- UI: New single-sig wallet and device setup wizard (#392) (@ben-kaufman)
- UI: Align sidebar contents properly (#394) (@dennisreimann)
- UI: Add about page to the sidebar (#401) (@moritzwietersheim, @ben-kaufman)
- Refactoring: Small cleanup of the JSON-RPC server code (#322) (@PulpCattel)
- Refactoring: Rearrange the utils and helpers files and functions (#352) (@stepansnigirev)
- Devops: Automate Linux binary releases (#324) (@k9ert)
- Devops: Add gen-certificate tool for self-signed certificates (#354) (@stepansnigirev)
- Devops: Automate Windows binary releases (#361) (@k9ert)
- Devops: Make pre-releases possible supporting semver (#371) (@k9ert)
- Docs: Update the FAQ (#328, #378, #387, #395) (@kkdao, @k9ert)
- Docs: Update Tor docs for Linux (#340) (@stepansnigirev)
- Docs: Add Tor document link to the README (#357) (@k9ert)
- Docs: Add FAQ link to the README (#355) (@Siimone)
- Docs: Update FAQ with a question about devices vs. wallets (#357) (@k9ert)
- Docs: Add Help Wanted section to the README (#357) (@moritzwietersheim)

## v0.7.2 August 28, 2020
- Build: Add build scripts for building the release files (#319) (@stepansnigirev)
- Bugfix: In the desktop app, open a remote https/ Tor Specter node in browser instead of Qtweb  (#320) (@stepansnigirev)
- Bugfix: Fix specterd not shutting down after closing desktop app with `cmd+q` (#320) (@stepansnigirev)
- Bugfix: Fix send amount using sats units by default even when using BTC as wallet unit (#318) (@ben-kaufman)
- Bugfix: Fix redirect error after login (#318) (@ben-kaufman)

## v0.7.1 August 26, 2020
- Bugfix: Move docker dependency away from main code (#316) (@stepansnigirev)

## v0.7.0 August 26, 2020
- Build: Create Specter Desktop app  (#273, #308) (@stepansnigirev, @ben-kaufman)
- Bugfix: Fix importing PSBT functionality (#291) (@ben-kaufman)
- Bugfix: Fix issue with using xpub with no derivation (`m` only) (#282) (@hodlwave)
- Bugfix: Fix issue with uploading PSBT from SD card (#292) (@luclefleur)
- Bugfix: Fix error when creating wallet with single quotes in name (#300) (@luclefleur)
- Bugfix: Fix signing issue on Cobo Vault (#301) (@stepansnigirev)
- Bugfix: Fix export format for Cobo Vault and Coldcard (#301) (@stepansnigirev)
- Bugfix: Fix validation of send form when the amount field is empty (#303) (@ben-kaufman)
- Bugfix: Fix issue with creating wallets (#305) (@stepansnigirev)
- Bugfix: Fix BTC to sat unit conversion mistake of x10 on Send tab amount input (#314) (@ben-kaufman)
- Feature: Sats the standard - allow using sats instead of BTC as Specter's unit of account (#306) (@ben-kaufman)
- Feature: Add a list of the wallet's past addresses to the Receive tab (#296) (@ben-kaufman)
- Feature: Run the numbers! (Add calculate total BTC supply options to node info screen) (#304) (@ben-kaufman)
- UI: Ask user to extract backup ZIP before uploading Specter backup folder (#307) (@ben-kaufman)
- UI: Fix Tor popup typo (#310) (@TheCharlatan)
- UI: Configure local and remote HWI in one place (#312) (@stepansnigirev)
- Docs: Add a missing instruction for building with pyinstaller (#285) (@mflaxman)
- Docs: Update README and screenshots (#309) (@ben-kaufman)

## v0.6.1 August 13, 2020
- Devices: Add animated QR codes support for [Cobo Valut](https://cobo.com/hardware-wallet/cobo-vault) (#279) (@stepansnigirev)
- Bugfix: Fix malformed JSON issue when exporting wallet to file in Chrome (#274) (@ben-kaufman)
- Bugfix: Fix issue with importing wallet using a key with no origin derivation data (#274) (@ben-kaufman)
- Bugfix: Fix issue with adding an Electrum device (#276) (@stepansnigirev)
- Bugfix: Fix issue with deleting wallets (#276) (@stepansnigirev)
- Feature: Add Rescan UTXO to improve rescanning speed (#277) (@stepansnigirev)
- HWI: Trezor and KeepKey change address verification (#276) (@stepansnigirev)
- UI: New export options for keys of devices (#275) (@ben-kaufman)
- UI: Add toggle device passphrase option when adding a Trezor or KeepKey device (#278) (@ben-kaufman)
- Refactoring: Restructure the device classes to improve modularity and flexibility (#276) (@stepansnigirev) 
- Refactoring: Improve HWI detect device speed by enumerating only on the specific type needed (#280) (@stepansnigirev) 

## v0.6.0 August 4, 2020
- Build: Create `specterd` and `hwibridge` binaries (#258, #271) (@stepansnigirev)
- Devices: [Cobo Valut](https://cobo.com/hardware-wallet/cobo-vault) multisig support (#268) (@stepansnigirev)
- Bugfix: Fix issues and improve performance by removing local caching (#242) (@ben-kaufman)
- Bugfix: Fix installation issue on ARM machines by removing the BIP32 dependency (#259) (@stepansnigirev)
- Performance: RPC calls optimization (#251) (@stepansnigirev)
- Performance: Support multi RPC calls (#243) (@stepansnigirev)
- Feature: Allow sending transactions with multiple recipients (batch transactions) (#252) (@ben-kaufman)
- Feature: Add full backup and restore of all Specter data (#261) (@ben-kaufman)
- Feature: Dynamically start and manage Specter's Tor Hidden Service from the UI (#257) (@ben-kaufman)
- Feature: Allow user to customize the Bitcoin Core data-dir path (#260) (@ben-kaufman)
- Feature: Automatically derive key origin for depth 0 and 1 (#264) (@hodlwave)
- UI: Add Wallets Overview page showing the combined balance and transactions history of all user's wallets. (#272) (@ben-kaufman)
- UI: Add Bitcoin Core node info dashboard (#267) (@ben-kaufman)
- UI: New landing page and multiple UI fixes. (#269) (@ben-kaufman)
- UI: Make sidebar wallets and devices lists foldable (#263) (@ben-kaufman)
- UI: New status bar at the top right corner with Setting, Tor, and Logout buttons (#263) (@ben-kaufman)
- UI: Reorganize the wallet Receive tab (#263) (@ben-kaufman)
- UI: Disable devices without keys compatible with chosen wallet type when creating a new wallet (#239) (@stepansnigirev)
- UI: Verify device fingerprint on signing to prevent using the wrong device (#240) (@ben-kaufman)
- UI: Redirect to unsigned PSBTs tab in the wallet Send tab if there are any (#245) (@stepansnigirev)
- UI: Remove upgrade warning when running from source (#241) (@stepansnigirev)
- UI: Remove addresses view and move UTXO view to wallet History page (#242) (@ben-kaufman)
- UI: Add auto-detect Bitcoin Core configurations to the Settings page (#249) (@ben-kaufman)
- UI: Various minor UI improvements (text colors, sizes, spaces, etc.) (#263) (@ben-kaufman)
- UI: Wallet transactions history pagination (#242) (@ben-kaufman)
- UI: Minor ColdCard related improvements (#265) (@ben-kaufman)
- UI: Show note on HWIBridge in HWI detect popup if no device is detected (#266) (@ben-kaufman)
- Refactoring: Create a `qr-scanner` HTML component (#248) (@stepansnigirev)
- Test: Fix test issues due to nondeterministic order of tests (#250) (@k9ert)

## v0.5.5 July 15, 2020
- Devices: Support Electrum wallet as a device (#222) (@stepansnigirev)
- Devices: Support Generic device (usable for any PSBT compatible device not directly supported in Specter) (#221) (@stepansnigirev)
- Bugfix: Fix crash when creating a transaction from wallet with a device with type "Other" (#221) (@stepansnigirev)
- Bugfix: Fix crash when adding keys to an existing device (#221) (@stepansnigirev)
- Bugfix: Show proper error messages when combining PSBTs fails due to server error (#221) (@stepansnigirev)
- Bugfix: Fix wallet behavior when passing a finalized transaction in signing page (#221) (@stepansnigirev)
- Bugfix: Fix signature counter displaying wrong number (#223) (@stepansnigirev)
- Bugfix: Fix PSBT xpubs derivation endian format (#232) (@stepansnigirev)
- Bugfix: Fix crash if Bitcoin Core connection fails (#231) (@stepansnigirev)
- HWI: Prepare support for [Trezor and KeepKey multisig change address verification](https://github.com/bitcoin-core/HWI/pull/355) by adding xpubs data to PSBT sent to HWI (#232) (@stepansnigirev)
- HWI: Add toggle passphrase support for Trezor and KeepKey devices (#234) (@ben-kaufman)
- Feature: Export wallet to allow importing it to Specter or other supported wallet softwares (#220) (@ben-kaufman)
- Feature: Import wallet from Specter or other supported wallet softwares (#225) (@ben-kaufman)
- UI: Improved amount validation in new transaction screen (#221) (@stepansnigirev)

## v0.5.4 July 13, 2020
- Devices: (⚠️ Experimental) Support Bitcoin Core hot wallets (#210) (@ben-kaufman)
- Bugfix: Fix issues with Bitcoin Core calls timing out (#214) (@stepansnigirev)
- Bugfix: Fix issues with non standard keys (#209) (@stepansnigirev)
- Refactoring: Refactor HWI Javascript code (#213) (@stepansnigirev)
- UI: Add new exception handler page to give information about errors (#211) (@stepansnigirev)
- UI: Improve keys table (#218) (@stepansnigirev)

## v0.5.3 July 10, 2020
- Bugfix: Fix potential crashes and issues due to multi-threading race conditions (#205) (@stepansnigirev)
- Bugfix: Fix crash if current Specter version could not be obtained (#202) (@stepansnigirev)
- Bugfix: Fix potential issue with wallets not being properly loaded (#197) (@ben-kaufman)
- Feature: User management panel for admin to manage the list of existing users (in multi-user mode) (#194) (@ben-kaufman)
- UI: Fix notification UI in coin-selection and login screens (#192, #195) (@stepansnigirev)
- UI: Fix some notification messages showing up as error messages (#193) (@ben-kaufman)
- UI: List the devices used in a wallet and the wallets using a certain device (#196) (@ben-kaufman)
- UI: Allow changing device type and warn if non was selected on device setup (#201) (@ben-kaufman)
- UI: Clarify why funds are not available when already used in an unsigned transaction and how to free them (#204) (@ben-kaufman)
- UI: Indicate selected device on the sidebar (#206) (@stepansnigirev)

## v0.5.2 July 5, 2020
- Devices: [Cobo Valut](https://cobo.com/hardware-wallet/cobo-vault) single-sig support (#189) (@stepansnigirev)
- Devices: Support Specter-DIY [v1.2.0](https://github.com/cryptoadvance/specter-diy/releases/tag/v1.2.0) (#188) (@stepansnigirev)
- Bugfix: Fix issue with wallets and devices not being loaded properly (#190) (@ben-kaufman)
- Bugfix: Return button to display address on device for Ledger single-sig wallets (#187) (@stepansnigirev)
- Bugfix: Allow same origin requests to HWI Bridge by default (#185) (@stepansnigirev)
- Bugfix: Fix authentication and styles issues (#181) (@stepansnigirev)
- UI: Improve sidebar UI when Bitcoin Core is not connected or not configured (#184) (@stepansnigirev)

## v0.5.1 (v0.5.0 Hotfix) June 30, 2020
- Bugfix: Fix issue with running Specter after installing from pip (@stepansnigirev)

## v0.5.0 June 30, 2020
- Bugfix: Fix compatibility issue with latest Ledger and Trezor firmwares (addresses new BIP143 vulnerability), use HWI 1.1.2 (#178) (@stepansnigirev)
- Bugfix: Don't update explorer if chain is unknown (#174) (@stepansnigirev)
- Bugfix: Fix labels issue with Bitcoin Core v0.20.0 (#160) (@ben-kaufman)
- Feature: Multi-user support (#172) (@ben-kaufman)
- Feature: Import-export PSBT transactions (#175) (@stepansnigirev)
- Feature: Support HWI display multisig address on device (ColdCard, KeepKey, Trezor) (#179) (@ben-kaufman)
- UI: Show installed Specter version and notify on upgrades on the Setting page. (#158) (@k9ert)
- UI: Redesign and improve notifications and error messages (#177, #163) (@stepansnigirev)
- UI: Separate the different areas in the Settings screen into tabs. (#176) (@ben-kaufman)
- UI: Add copy button for QR codes (#173) (@stepansnigirev)
- UI: Change confusing “Pending PSBTs” terminology to “Unsigned PSBTs” (#171) (@ben-kaufman)
- UI: Improve signing UI (#175, #160) (@stepansnigirev, @ben-kaufman)
- UI: Add reject reason to the error on broadcast (#160) (@stepansnigirev)
- UI: New Trezor and Ledger icons (#160) (@stepansnigirev, @ben-kaufman)
- UI: Allow selecting device type manually (#160) (@ben-kaufman)
- Refactoring: Separate `logic.py` into multiple files (#160) (@ben-kaufman)
- Refactoring: Refactor Device, DeviceManager, Wallet, WalletManager classes (#160) (@ben-kaufman)
- Refactoring: Modularize supported device types (#160) (@ben-kaufman)
- Refactoring: Make devices and wallets accessible to each other (#160) (@ben-kaufman)
- Test: Improve test coverage for: Device, DeviceManager, Wallet, WalletManager classes (#160, #170) (@ben-kaufman)
- Test: Support multiple Bitcoin Core versions (#161) (@k9ert)
- Docs: Create FAQ doc (#151) (@kkdao)
- Docs: FAQ table of contents auto-generation (#165) (@k9ert)
- Docs: README updates (#164) (@moritzwietersheim)

## v0.4.0 May 31, 2020
- Mobile friendly UI (#112) (@stepansnigirev)
- Showing transacation details while sending (#130) (@ben-kaufman)
- Being able to copy transaction instead of sending via own node (#232) (@ben-kaufman)
- User feedback for proper connection to Core in settings menu (#139) (@k9ert)
- Bugfix which blocked the use of Coldcard under certain circumstances (#140) (@ben-kaufman)
- Bugfix how funds get represented (#128) (@ben-kaufman)
- A lot of refactorings (especially for template-logic) and tidyups. We also removed some dependencies (@ben-kaufman, @stepansnigirev)

## v0.3.0 May 11, 2020
- QR-Code animations enable to pass more information in smaller chunks (#104) (@gorazdko)
- Renaming and Deleting wallets (#108) (@ben-kaufman)
- addresses and utxo-view for better overview of your funds (#95) (@ben-kaufman)
- Pending PSBTS for partially sign and sign with others devices much later (#100) (@ben-kaufman)
- Support Device passphrases for HWI-wallets (#101) (@ben-kaufman)
- coin selection to control which utxo you want to spend (#40) (@k9ert)
- Display Addresses on device (#120) (@ben-kaufman)
- Windows support (#127) (@stepansnigirev)

## v0.2.0 Mar 27, 2020
- label addresses to get remember where coins are coming from (#94) (@ben-kaufman)
- Optional Authentication with RPC Password (#81) (@k9ert)
- Support custom block explorer for all networks (@ben-kaufman)

## v0.1.2 Mar 6, 2020
- bugfix-release (#84)

## v0.1.1 Feb 29, 2020
- Support for compressed PSBT in QR-codes #80 (@stepansnigirev)
- Use specter-diy to sign via USB (#77) (@stepansnigirev)

## v0.1.0 Feb 27, 2020
- Rescan Blockchain to import older wallets easily (#73) (@stepansnigirev)
- Command-line options for server: daemon, ssl-certs and tor

## v0.0.2 Feb 20, 2020
- First PIP-Release available on [PyPi](https://pypi.org/project/cryptoadvance.specter/#history) (#69) (@k9ert)
- HWI support enables a whole bunch of hardwarewallets to work with specter (#23) (@kdmukai)
- Tor integration (#19) (@kdmukai)
- Support for coldcard (#56) (@kdmukai)
- https support (#64) (@stepansnigirev)

## v0.0.1-alpha Sep 28, 2019
Specter Desktop has been started by @stepansnigirev since Aug 30, 2019.
Thank you Stepan :-).
