from .__init__ import ctypes, typing, abc, SDL_TYPE

from .SDL_scancode import SDL_Scancode

SDL_Keycode: typing.TypeAlias = SDL_TYPE["SDL_Keycode", ctypes.c_uint32]

SDLK_EXTENDED_MASK, SDLK_SCANCODE_MASK = 1 << 29, 1 << 30
SDL_SCANCODE_TO_KEYCODE: abc.Callable[[SDL_Scancode], SDL_Keycode] = lambda x: x | SDLK_SCANCODE_MASK

SDLK_UNKNOWN: int = 0x00000000
SDLK_RETURN: int = 0x0000000d
SDLK_ESCAPE: int = 0x0000001b
SDLK_BACKSPACE: int = 0x00000008
SDLK_TAB: int = 0x00000009
SDLK_SPACE: int = 0x00000020
SDLK_EXCLAIM: int = 0x00000021
SDLK_DBLAPOSTROPHE: int = 0x00000022
SDLK_HASH: int = 0x00000023
SDLK_DOLLAR: int = 0x00000024
SDLK_PERCENT: int = 0x00000025
SDLK_AMPERSAND: int = 0x00000026
SDLK_APOSTROPHE: int = 0x00000027
SDLK_LEFTPAREN: int = 0x00000028
SDLK_RIGHTPAREN: int = 0x00000029
SDLK_ASTERISK: int = 0x0000002a
SDLK_PLUS: int = 0x0000002b
SDLK_COMMA: int = 0x0000002c
SDLK_MINUS: int = 0x0000002d
SDLK_PERIOD: int = 0x0000002e
SDLK_SLASH: int = 0x0000002f
SDLK_0: int = 0x00000030
SDLK_1: int = 0x00000031
SDLK_2: int = 0x00000032
SDLK_3: int = 0x00000033
SDLK_4: int = 0x00000034
SDLK_5: int = 0x00000035
SDLK_6: int = 0x00000036
SDLK_7: int = 0x00000037
SDLK_8: int = 0x00000038
SDLK_9: int = 0x00000039
SDLK_COLON: int = 0x0000003a
SDLK_SEMICOLON: int = 0x0000003b
SDLK_LESS: int = 0x0000003c
SDLK_EQUALS: int = 0x0000003d
SDLK_GREATER: int = 0x0000003e
SDLK_QUESTION: int = 0x0000003f
SDLK_AT: int = 0x00000040
SDLK_LEFTBRACKET: int = 0x0000005b
SDLK_BACKSLASH: int = 0x0000005c
SDLK_RIGHTBRACKET: int = 0x0000005d
SDLK_CARET: int = 0x0000005e
SDLK_UNDERSCORE: int = 0x0000005f
SDLK_GRAVE: int = 0x00000060
SDLK_A: int = 0x00000061
SDLK_B: int = 0x00000062
SDLK_C: int = 0x00000063
SDLK_D: int = 0x00000064
SDLK_E: int = 0x00000065
SDLK_F: int = 0x00000066
SDLK_G: int = 0x00000067
SDLK_H: int = 0x00000068
SDLK_I: int = 0x00000069
SDLK_J: int = 0x0000006a
SDLK_K: int = 0x0000006b
SDLK_L: int = 0x0000006c
SDLK_M: int = 0x0000006d
SDLK_N: int = 0x0000006e
SDLK_O: int = 0x0000006f
SDLK_P: int = 0x00000070
SDLK_Q: int = 0x00000071
SDLK_R: int = 0x00000072
SDLK_S: int = 0x00000073
SDLK_T: int = 0x00000074
SDLK_U: int = 0x00000075
SDLK_V: int = 0x00000076
SDLK_W: int = 0x00000077
SDLK_X: int = 0x00000078
SDLK_Y: int = 0x00000079
SDLK_Z: int = 0x0000007a
SDLK_LEFTBRACE: int = 0x0000007b
SDLK_PIPE: int = 0x0000007c
SDLK_RIGHTBRACE: int = 0x0000007d
SDLK_TILDE: int = 0x0000007e
SDLK_DELETE: int = 0x0000007f
SDLK_PLUSMINUS: int = 0x000000b1
SDLK_CAPSLOCK: int = 0x40000039
SDLK_F1: int = 0x4000003a
SDLK_F2: int = 0x4000003b
SDLK_F3: int = 0x4000003c
SDLK_F4: int = 0x4000003d
SDLK_F5: int = 0x4000003e
SDLK_F6: int = 0x4000003f
SDLK_F7: int = 0x40000040
SDLK_F8: int = 0x40000041
SDLK_F9: int = 0x40000042
SDLK_F10: int = 0x40000043
SDLK_F11: int = 0x40000044
SDLK_F12: int = 0x40000045
SDLK_PRINTSCREEN: int = 0x40000046
SDLK_SCROLLLOCK: int = 0x40000047
SDLK_PAUSE: int = 0x40000048
SDLK_INSERT: int = 0x40000049
SDLK_HOME: int = 0x4000004a
SDLK_PAGEUP: int = 0x4000004b
SDLK_END: int = 0x4000004d
SDLK_PAGEDOWN: int = 0x4000004e
SDLK_RIGHT: int = 0x4000004f
SDLK_LEFT: int = 0x40000050
SDLK_DOWN: int = 0x40000051
SDLK_UP: int = 0x40000052
SDLK_NUMLOCKCLEAR: int = 0x40000053
SDLK_KP_DIVIDE: int = 0x40000054
SDLK_KP_MULTIPLY: int = 0x40000055
SDLK_KP_MINUS: int = 0x40000056
SDLK_KP_PLUS: int = 0x40000057
SDLK_KP_ENTER: int = 0x40000058
SDLK_KP_1: int = 0x40000059
SDLK_KP_2: int = 0x4000005a
SDLK_KP_3: int = 0x4000005b
SDLK_KP_4: int = 0x4000005c
SDLK_KP_5: int = 0x4000005d
SDLK_KP_6: int = 0x4000005e
SDLK_KP_7: int = 0x4000005f
SDLK_KP_8: int = 0x40000060
SDLK_KP_9: int = 0x40000061
SDLK_KP_0: int = 0x40000062
SDLK_KP_PERIOD: int = 0x40000063
SDLK_APPLICATION: int = 0x40000065
SDLK_POWER: int = 0x40000066
SDLK_KP_EQUALS: int = 0x40000067
SDLK_F13: int = 0x40000068
SDLK_F14: int = 0x40000069
SDLK_F15: int = 0x4000006a
SDLK_F16: int = 0x4000006b
SDLK_F17: int = 0x4000006c
SDLK_F18: int = 0x4000006d
SDLK_F19: int = 0x4000006e
SDLK_F20: int = 0x4000006f
SDLK_F21: int = 0x40000070
SDLK_F22: int = 0x40000071
SDLK_F23: int = 0x40000072
SDLK_F24: int = 0x40000073
SDLK_EXECUTE: int = 0x40000074
SDLK_HELP: int = 0x40000075
SDLK_MENU: int = 0x40000076
SDLK_SELECT: int = 0x40000077
SDLK_STOP: int = 0x40000078
SDLK_AGAIN: int = 0x40000079
SDLK_UNDO: int = 0x4000007a
SDLK_CUT: int = 0x4000007b
SDLK_COPY: int = 0x4000007c
SDLK_PASTE: int = 0x4000007d
SDLK_FIND: int = 0x4000007e
SDLK_MUTE: int = 0x4000007f
SDLK_VOLUMEUP: int = 0x40000080
SDLK_VOLUMEDOWN: int = 0x40000081
SDLK_KP_COMMA: int = 0x40000085
SDLK_KP_EQUALSAS400: int = 0x40000086
SDLK_ALTERASE: int = 0x40000099
SDLK_SYSREQ: int = 0x4000009a
SDLK_CANCEL: int = 0x4000009b
SDLK_CLEAR: int = 0x4000009c
SDLK_PRIOR: int = 0x4000009d
SDLK_RETURN2: int = 0x4000009e
SDLK_SEPARATOR: int = 0x4000009f
SDLK_OUT: int = 0x400000a0
SDLK_OPER: int = 0x400000a1
SDLK_CLEARAGAIN: int = 0x400000a2
SDLK_CRSEL: int = 0x400000a3
SDLK_EXSEL: int = 0x400000a4
SDLK_KP_00: int = 0x400000b0
SDLK_KP_000: int = 0x400000b1
SDLK_THOUSANDSSEPARATOR: int = 0x400000b2
SDLK_DECIMALSEPARATOR: int = 0x400000b3
SDLK_CURRENCYUNIT: int = 0x400000b4
SDLK_CURRENCYSUBUNIT: int = 0x400000b5
SDLK_KP_LEFTPAREN: int = 0x400000b6
SDLK_KP_RIGHTPAREN: int = 0x400000b7
SDLK_KP_LEFTBRACE: int = 0x400000b8
SDLK_KP_RIGHTBRACE: int = 0x400000b9
SDLK_KP_TAB: int = 0x400000ba
SDLK_KP_BACKSPACE: int = 0x400000bb
SDLK_KP_A: int = 0x400000bc
SDLK_KP_B: int = 0x400000bd
SDLK_KP_C: int = 0x400000be
SDLK_KP_D: int = 0x400000bf
SDLK_KP_E: int = 0x400000c0
SDLK_KP_F: int = 0x400000c1
SDLK_KP_XOR: int = 0x400000c2
SDLK_KP_POWER: int = 0x400000c3
SDLK_KP_PERCENT: int = 0x400000c4
SDLK_KP_LESS: int = 0x400000c5
SDLK_KP_GREATER: int = 0x400000c6
SDLK_KP_AMPERSAND: int = 0x400000c7
SDLK_KP_DBLAMPERSAND: int = 0x400000c8
SDLK_KP_VERTICALBAR: int = 0x400000c9
SDLK_KP_DBLVERTICALBAR: int = 0x400000ca
SDLK_KP_COLON: int = 0x400000cb
SDLK_KP_HASH: int = 0x400000cc
SDLK_KP_SPACE: int = 0x400000cd
SDLK_KP_AT: int = 0x400000ce
SDLK_KP_EXCLAM: int = 0x400000cf
SDLK_KP_MEMSTORE: int = 0x400000d0
SDLK_KP_MEMRECALL: int = 0x400000d1
SDLK_KP_MEMCLEAR: int = 0x400000d2
SDLK_KP_MEMADD: int = 0x400000d3
SDLK_KP_MEMSUBTRACT: int = 0x400000d4
SDLK_KP_MEMMULTIPLY: int = 0x400000d5
SDLK_KP_MEMDIVIDE: int = 0x400000d6
SDLK_KP_PLUSMINUS: int = 0x400000d7
SDLK_KP_CLEAR: int = 0x400000d8
SDLK_KP_CLEARENTRY: int = 0x400000d9
SDLK_KP_BINARY: int = 0x400000da
SDLK_KP_OCTAL: int = 0x400000db
SDLK_KP_DECIMAL: int = 0x400000dc
SDLK_KP_HEXADECIMAL: int = 0x400000dd
SDLK_LCTRL: int = 0x400000e0
SDLK_LSHIFT: int = 0x400000e1
SDLK_LALT: int = 0x400000e2
SDLK_LGUI: int = 0x400000e3
SDLK_RCTRL: int = 0x400000e4
SDLK_RSHIFT: int = 0x400000e5
SDLK_RALT: int = 0x400000e6
SDLK_RGUI: int = 0x400000e7
SDLK_MODE: int = 0x40000101
SDLK_SLEEP: int = 0x40000102
SDLK_WAKE: int = 0x40000103
SDLK_CHANNEL_INCREMENT: int = 0x40000104
SDLK_CHANNEL_DECREMENT: int = 0x40000105
SDLK_MEDIA_PLAY: int = 0x40000106
SDLK_MEDIA_PAUSE: int = 0x40000107
SDLK_MEDIA_RECORD: int = 0x40000108
SDLK_MEDIA_FAST_FORWARD: int = 0x40000109
SDLK_MEDIA_REWIND: int = 0x4000010a
SDLK_MEDIA_NEXT_TRACK: int = 0x4000010b
SDLK_MEDIA_PREVIOUS_TRACK: int = 0x4000010c
SDLK_MEDIA_STOP: int = 0x4000010d
SDLK_MEDIA_EJECT: int = 0x4000010e
SDLK_MEDIA_PLAY_PAUSE: int = 0x4000010f
SDLK_MEDIA_SELECT: int = 0x40000110
SDLK_AC_NEW: int = 0x40000111
SDLK_AC_OPEN: int = 0x40000112
SDLK_AC_CLOSE: int = 0x40000113
SDLK_AC_EXIT: int = 0x40000114
SDLK_AC_SAVE: int = 0x40000115
SDLK_AC_PRINT: int = 0x40000116
SDLK_AC_PROPERTIES: int = 0x40000117
SDLK_AC_SEARCH: int = 0x40000118
SDLK_AC_HOME: int = 0x40000119
SDLK_AC_BACK: int = 0x4000011a
SDLK_AC_FORWARD: int = 0x4000011b
SDLK_AC_STOP: int = 0x4000011c
SDLK_AC_REFRESH: int = 0x4000011d
SDLK_AC_BOOKMARKS: int = 0x4000011e
SDLK_SOFTLEFT: int = 0x4000011f
SDLK_SOFTRIGHT: int = 0x40000120
SDLK_CALL: int = 0x40000121
SDLK_ENDCALL: int = 0x40000122
SDLK_LEFT_TAB: int = 0x20000001
SDLK_LEVEL5_SHIFT: int = 0x20000002
SDLK_MULTI_KEY_COMPOSE: int = 0x20000003
SDLK_LMETA: int = 0x20000004
SDLK_RMETA: int = 0x20000005
SDLK_LHYPER: int = 0x20000006
SDLK_RHYPER: int = 0x20000007

SDL_Keymod: typing.TypeAlias = SDL_TYPE["SDL_Keymod", ctypes.c_uint16]

SDL_KMOD_NONE: int = 0x0000
SDL_KMOD_LSHIFT: int = 0x0001
SDL_KMOD_RSHIFT: int = 0x0002
SDL_KMOD_LEVEL5: int = 0x0004
SDL_KMOD_LCTRL: int = 0x0040
SDL_KMOD_RCTRL: int = 0x0080
SDL_KMOD_LALT: int = 0x0100
SDL_KMOD_RALT: int = 0x0200
SDL_KMOD_LGUI: int = 0x0400
SDL_KMOD_RGUI: int = 0x0800
SDL_KMOD_NUM: int = 0x1000
SDL_KMOD_CAPS: int = 0x2000
SDL_KMOD_MODE: int = 0x4000
SDL_KMOD_SCROLL: int = 0x8000
SDL_KMOD_CTRL = SDL_KMOD_LCTRL | SDL_KMOD_RCTRL
SDL_KMOD_SHIFT = SDL_KMOD_LSHIFT | SDL_KMOD_RSHIFT
SDL_KMOD_ALT = SDL_KMOD_LALT | SDL_KMOD_RALT
SDL_KMOD_GUI = SDL_KMOD_LGUI | SDL_KMOD_RGUI