"""Constants."""

LOCAL_CPDID = "01"

# Defaults
DEFAULT_PROTOCOL_PORT = 10000
DEFAULT_PROTOCOL_TIMEOUT = 10.0
DEFAULT_RECONNECT_DELAY = 10.0

# Connection
STATE_CONNECTED = "connected"
STATE_DISCONNECTED = "disconnected"
STATE_RECONNECTING = "reconnecting"

# Control Protocol Statuses
SUCCESS = 0
ERROR_MESSAGE_TO_LONG = 1
ERROR_MESSAGE_INVALID_CHARACTERS = 2
ERROR_CHECKSUM_ERROR = 3
ERROR_INVALID_DEVICE = 4
ERROR_DEVICE_UNAVAILABLE = 5
ERROR_INVALID_ZONE_SYNTAX = 6
ERROR_INVALID_ZONE = 7
ERROR_INVALID_REQUEST = 10
ERROR_INVALID_NUMBER_PARAMETERS = 11
ERROR_INVALID_PARAMETER = 12
ERROR_DEVICE_ID_CONFLICT = 13
ERROR_INVALID_SEQ_NUMBER = 14
ERROR_INVALID_PASSCODE = 16
ERROR_INVALID_CONTENT_HANDLE = 17
ERROR_NETWORK_ERROR = 18
ERROR_INVALID_SERIAL_SYNTAX = 19
ERROR_DEVICE_IN_STANDBY = 20
ERROR_REJECTED_WHILE_PAIRED = 32

ERROR_UNDETERMINED_ERROR = 999
RESPONSE_ERROR = {
    SUCCESS: "Success",
    ERROR_MESSAGE_TO_LONG: "Message too long",
    ERROR_MESSAGE_INVALID_CHARACTERS: "Message contains invalid characters",
    ERROR_CHECKSUM_ERROR: "Checksum error",
    ERROR_INVALID_DEVICE: "Invalid device",
    ERROR_DEVICE_UNAVAILABLE: "Device unavailable",
    ERROR_INVALID_ZONE_SYNTAX: "Invalid zone syntax",
    ERROR_INVALID_ZONE: "Invalid zone",
    ERROR_INVALID_REQUEST: "Invalid request",
    ERROR_INVALID_NUMBER_PARAMETERS: "Invalid number of parameters",
    ERROR_INVALID_PARAMETER: "Invalid parameter",
    ERROR_DEVICE_ID_CONFLICT: "Device identifier conflict",
    ERROR_INVALID_SEQ_NUMBER: "Invalid sequence number",
    ERROR_INVALID_PASSCODE: "Invalid passcode",
    ERROR_INVALID_CONTENT_HANDLE: "Invalid content handle",
    ERROR_NETWORK_ERROR: "Network error",
    ERROR_INVALID_SERIAL_SYNTAX: "Invalid serial syntax",
    ERROR_DEVICE_IN_STANDBY: "Device in standby",
    ERROR_REJECTED_WHILE_PAIRED: "Command is rejected while in paired state",
    ERROR_UNDETERMINED_ERROR: "Undetermined error",
}

#
# Control Protocol Messages
#

SYSTEM_PAIRING_INFO = "SYSTEM_PAIRING_INFO"
SYSTEM_VERSION = "SYSTEM_VERSION"
DEVICE_INFO = "DEVICE_INFO"
ZONE_CAPABILITIES = "ZONE_CAPABILITIES"
NUM_ZONES = "NUM_ZONES"
DEVICE_TYPE_NAME = "DEVICE_TYPE_NAME"
FRIENDLY_SYSTEM_NAME = "FRIENDLY_SYSTEM_NAME"
FRIENDLY_NAME = "FRIENDLY_NAME"
AVAILABLE_DEVICES = "AVAILABLE_DEVICES"
AVAILABLE_DEVICES_BY_SERIAL_NUMBER = "AVAILABLE_DEVICES_BY_SERIAL_NUMBER"
PLAYING_TITLE_NAME = "PLAYING_TITLE_NAME"
TITLE_NAME = "TITLE_NAME"
HIGHLIGHTED_SELECTION = "HIGHLIGHTED_SELECTION"
CONTENT_DETAILS = "CONTENT_DETAILS"
CONTENT_DETAILS_OVERVIEW = "CONTENT_DETAILS_OVERVIEW"
ENABLE_EVENTS = "ENABLE_EVENTS"
ENTER_STANDBY = "ENTER_STANDBY"
LEAVE_STANDBY = "LEAVE_STANDBY"
PLAY = "PLAY"
PAUSE = "PAUSE"
STOP = "STOP"
NEXT = "NEXT"
PREVIOUS = "PREVIOUS"
REPLAY = "REPLAY"
SCAN_FORWARD = "SCAN_FORWARD"
SCAN_REVERSE = "SCAN_REVERSE"
SELECT = "SELECT"
UP = "UP"
DOWN = "DOWN"
LEFT = "LEFT"
RIGHT = "RIGHT"
CANCEL = "CANCEL"
GO_MOVIE_COVERS = "GO_MOVIE_COVERS"
KALEIDESCAPE_MENU_TOGGLE = "KALEIDESCAPE_MENU_TOGGLE"

DEVICE_POWER_STATE = "DEVICE_POWER_STATE"
DEVICE_POWER_STATE_STANDBY = "standby"
DEVICE_POWER_STATE_ON = "on"
DEVICE_ZONE_STATE_DISABLED = "disabled"
DEVICE_ZONE_STATE_AVAILABLE = "available"

SYSTEM_READINESS_STATE = "SYSTEM_READINESS_STATE"
SYSTEM_READINESS_STATE_READY = "ready"
SYSTEM_READINESS_STATE_BECOMING_READY = "becoming_ready"
SYSTEM_READINESS_STATE_IDLE = "idle"

PLAY_STATUS = "PLAY_STATUS"
PLAY_STATUS_NONE = "none"
PLAY_STATUS_PAUSED = "paused"
PLAY_STATUS_PLAYING = "playing"
PLAY_STATUS_FORWARD = "forward"
PLAY_STATUS_REVERSE = "reverse"

MOVIE_LOCATION = "MOVIE_LOCATION"
MOVIE_LOCATION_NONE = "none"
MOVIE_LOCATION_CONTENT = "content"
MOVIE_LOCATION_INTERMISSION = "intermission"
MOVIE_LOCATION_CREDITS = "credits"
MOVIE_LOCATION_DISC_MENU = "disc_menu"

MOVIE_MEDIA_TYPE = "MOVIE_MEDIA_TYPE"
MOVIE_MEDIA_TYPE_NONE = "none"
MOVIE_MEDIA_TYPE_DVD = "dvd"
MOVIE_MEDIA_TYPE_STREAM = "stream"
MOVIE_MEDIA_TYPE_BLURAY = "bluray"

UI_STATE = "UI_STATE"
UI_STATE_SCREEN = "screen"
UI_STATE_SCREEN_UNKNOWN = "unknown"
UI_STATE_SCREEN_MOVIE_LIST = "movie_list"
UI_STATE_SCREEN_MOVIE_COLLECTIONS = "movie_collections"
UI_STATE_SCREEN_MOVIE_COVERS = "movie_covers"
UI_STATE_SCREEN_PARENTAL_CONTROL = "parental_control"
UI_STATE_SCREEN_PLAYING_MOVIE = "playing_movie"
UI_STATE_SCREEN_SYSTEM_STATUS = "system_status"
UI_STATE_SCREEN_MUSIC_LIST = "music_list"
UI_STATE_SCREEN_MUSIC_COVERS = "music_covers"
UI_STATE_SCREEN_MUSIC_COLLECTIONS = "music_collections"
UI_STATE_SCREEN_MUSIC_NOW_PLAYING = "music_now_playing"
UI_STATE_SCREEN_VAULT_SUMMARY = "vault_summary"
UI_STATE_SCREEN_SYSTEM_SETTINGS = "system_settings"
UI_STATE_SCREEN_MOVIE_STORE = "movie_store"
UI_STATE_SCREEN_PAIRED_UNIT_LOBBY = "paired_unit_lobby"
UI_STATE_POPUP = "popup"
UI_STATE_POPUP_NONE = "none"
UI_STATE_POPUP_DETAILS = "details"
UI_STATE_POPUP_MOVIE_STATUS = "movie_status"
UI_STATE_POPUP_MOVIE_NOT_STATUS = "movie_not_status"
UI_STATE_DIALOG = "dialog"
UI_STATE_DIALOG_NONE = "none"
UI_STATE_DIALOG_MENU = "menu"
UI_STATE_DIALOG_PASSCODE = "passcode"
UI_STATE_DIALOG_QUESTION = "question"
UI_STATE_DIALOG_INFORMATION = "information"
UI_STATE_DIALOG_WARNING = "warning"
UI_STATE_DIALOG_ERROR = "error"
UI_STATE_DIALOG_PREPLAY = "preplay"
UI_STATE_DIALOG_WARRANTY = "warranty"
UI_STATE_DIALOG_KEYBOARD = "keyboard"
UI_STATE_DIALOG_IP_CONFIG = "ip_config"
UI_STATE_SAVER = "saver"
UI_STATE_SAVER_INACTIVE = "inactive"
UI_STATE_SAVER_ACTIVE = "active"

VIDEO_MODE = "VIDEO_MODE"
VIDEO_MODE_NONE = "none"
VIDEO_MODE_480I60_4X3 = "480i60_4:3"
VIDEO_MODE_480I60_16X9 = "480i60_16:9"
VIDEO_MODE_480P60_4X3 = "480p60_4:3"
VIDEO_MODE_480P60_16X9 = "480p60_16:9"
VIDEO_MODE_576I50_4X3 = "576i50_4:3"
VIDEO_MODE_576I50_16X9 = "576i50_16:9"
VIDEO_MODE_576P50_4X3 = "576p50_4:3"
VIDEO_MODE_576P50_16X9 = "576p50_16:9"
VIDEO_MODE_720P60_NTSC_HD = "720p60_ntsc_hd"
VIDEO_MODE_720P50_PAL_HD = "720p50_pal_hd"
VIDEO_MODE_1080I60_16X9 = "1080i60_16:9"
VIDEO_MODE_1080I50_16X9 = "1080i50_16:9"
VIDEO_MODE_1080P60_16X9 = "1080p60_16:9"
VIDEO_MODE_1080P50_16X9 = "1080p50_16:9"
VIDEO_MODE_1080P24_16X9 = "1080p24_16:9"
VIDEO_MODE_480I60_64X27 = "480i60_64:27"
VIDEO_MODE_576I50_64X27 = "576i50_64:27"
VIDEO_MODE_1080I60_64X27 = "1080i60_64:27"
VIDEO_MODE_1080I50_64X27 = "1080i50_64:27"
VIDEO_MODE_1080P60_64X27 = "1080p60_64:27"
VIDEO_MODE_1080P50_64X27 = "1080p50_64:27"
VIDEO_MODE_1080P23976_64X27 = "1080p23976_64:27"
VIDEO_MODE_1080P24_64X27 = "1080p24_64:27"
VIDEO_MODE_3840X2160P23976_16X9 = "3840x2160p23976_16:9"
VIDEO_MODE_3840X2160P23976_64X27 = "3840x2160p23976_64:27"
VIDEO_MODE_3840X2160P30_16X9 = "3840x2160p30_16:9"
VIDEO_MODE_3840X2160P30_64X27 = "3840x2160p30_64:27"
VIDEO_MODE_3840X2160P60_16X9 = "3840x2160p60_16:9"
VIDEO_MODE_3840X2160P60_64X27 = "3840x2160p60_64:27"
VIDEO_MODE_3840X2160P25_16X9 = "3840x2160p25_16:9"
VIDEO_MODE_3840X2160P25_64X27 = "3840x2160p25_64:27"
VIDEO_MODE_3840X2160P50_16X9 = "3840x2160p50_16:9"
VIDEO_MODE_3840X2160P50_64X27 = "3840x2160p50_64:27"
VIDEO_MODE_3840X2160P24_16X9 = "3840x2160p24_16:9"
VIDEO_MODE_3840X2160P24_64X27 = "3840x2160p24_64:27"

VIDEO_COLOR = "VIDEO_COLOR"
VIDEO_COLOR_EOTF = "eotf"
VIDEO_COLOR_EOTF_UNKNOWN = "unknown"
VIDEO_COLOR_EOTF_SDR = "sdr"
VIDEO_COLOR_EOTF_HDR = "hdr"
VIDEO_COLOR_EOTF_SMTPEST2084 = "smtpest2084"
VIDEO_COLOR_SPACE = "space"
VIDEO_COLOR_SPACE_DEFAULT = "default"
VIDEO_COLOR_SPACE_RGB = "rgb"
VIDEO_COLOR_SPACE_BT601 = "bt601"
VIDEO_COLOR_SPACE_BT709 = "bt709"
VIDEO_COLOR_SPACE_BT2020 = "bt2020"
VIDEO_COLOR_DEPTH = "depth"
VIDEO_COLOR_DEPTH_UNKNOWN = "unknown"
VIDEO_COLOR_DEPTH_24BIT = "24bit"
VIDEO_COLOR_DEPTH_30BIT = "30bit"
VIDEO_COLOR_DEPTH_36BIT = "36bit"
VIDEO_COLOR_SAMPLING = "sampling"
VIDEO_COLOR_SAMPLING_NONE = "none"
VIDEO_COLOR_SAMPLING_RGB = "rgb"
VIDEO_COLOR_SAMPLING_YCBCR422 = "ycbcr422"
VIDEO_COLOR_SAMPLING_YCBCR444 = "ycbcr444"
VIDEO_COLOR_SAMPLING_YCBCR420 = "ycbcr420"

SCREEN_MASK = "SCREEN_MASK"
SCREEN_MASK_ASPECT_RATIO_NONE = "none"
SCREEN_MASK_ASPECT_RATIO_133 = "1.33"
SCREEN_MASK_ASPECT_RATIO_166 = "1.66"
SCREEN_MASK_ASPECT_RATIO_178 = "1.78"
SCREEN_MASK_ASPECT_RATIO_185 = "1.85"
SCREEN_MASK_ASPECT_RATIO_235 = "2.35"

SCREEN_MASK2 = "SCREEN_MASK2"

CINEMASCAPE_MODE = "CINEMASCAPE_MODE"
CINEMASCAPE_MODE_NONE = "none"
CINEMASCAPE_MODE_ANAMORPHIC = "anamorphic"
CINEMASCAPE_MODE_LETTERBOX = "letterbox"
CINEMASCAPE_MODE_NATIVE = "native"

CINEMASCAPE_MASK = "CINEMASCAPE_MASK"
