/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.WordCase;
import org.apache.lucene.analysis.hunspell.WordContext;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.FST;

final class Stemmer {
    private final Dictionary dictionary;
    private final int formStep;

    public Stemmer(Dictionary dictionary) {
        this.dictionary = dictionary;
        this.formStep = dictionary.formStep();
    }

    public List<CharsRef> stem(String word) {
        return this.stem(word.toCharArray(), word.length());
    }

    public List<CharsRef> stem(char[] word, int length) {
        CharsRef scratchSegment;
        if (this.dictionary.mayNeedInputCleaning() && this.dictionary.needsInputCleaning(scratchSegment = new CharsRef(word, 0, length))) {
            StringBuilder segment = new StringBuilder();
            this.dictionary.cleanInput(scratchSegment, segment);
            char[] scratchBuffer = new char[segment.length()];
            length = segment.length();
            segment.getChars(0, length, scratchBuffer, 0);
            word = scratchBuffer;
        }
        ArrayList<CharsRef> list = new ArrayList<CharsRef>();
        if (length == 0) {
            return list;
        }
        RootProcessor processor = (stem, formID, stemException) -> {
            list.add(this.newStem(stem, stemException));
            return true;
        };
        if (!this.doStem(word, 0, length, WordContext.SIMPLE_WORD, processor)) {
            return list;
        }
        WordCase wordCase = this.caseOf(word, length);
        if (wordCase == WordCase.UPPER || wordCase == WordCase.TITLE) {
            CaseVariationProcessor variationProcessor = (variant, varLength, originalCase) -> this.doStem(variant, 0, varLength, WordContext.SIMPLE_WORD, processor);
            this.varyCase(word, length, wordCase, variationProcessor);
        }
        return list;
    }

    boolean varyCase(char[] word, int length, WordCase wordCase, CaseVariationProcessor processor) {
        char[] titleBuffer;
        char[] cArray = titleBuffer = wordCase == WordCase.UPPER ? this.caseFoldTitle(word, length) : null;
        if (wordCase == WordCase.UPPER) {
            char[] aposCase = Stemmer.capitalizeAfterApostrophe(titleBuffer, length);
            if (aposCase != null && !processor.process(aposCase, length, wordCase)) {
                return false;
            }
            if (!processor.process(titleBuffer, length, wordCase)) {
                return false;
            }
            if (this.dictionary.checkSharpS && !this.varySharpS(titleBuffer, length, processor)) {
                return false;
            }
        }
        if (this.dictionary.isDotICaseChangeDisallowed(word)) {
            return true;
        }
        char[] lowerBuffer = this.caseFoldLower(titleBuffer != null ? titleBuffer : word, length);
        if (!processor.process(lowerBuffer, length, wordCase)) {
            return false;
        }
        return wordCase != WordCase.UPPER || !this.dictionary.checkSharpS || this.varySharpS(lowerBuffer, length, processor);
    }

    WordCase caseOf(char[] word, int length) {
        if (this.dictionary.ignoreCase || length == 0 || Character.isLowerCase(word[0])) {
            return WordCase.MIXED;
        }
        return WordCase.caseOf(word, length);
    }

    private char[] caseFoldTitle(char[] word, int length) {
        char[] titleBuffer = new char[length];
        System.arraycopy(word, 0, titleBuffer, 0, length);
        for (int i = 1; i < length; ++i) {
            titleBuffer[i] = this.dictionary.caseFold(titleBuffer[i]);
        }
        return titleBuffer;
    }

    private char[] caseFoldLower(char[] word, int length) {
        char[] lowerBuffer = new char[length];
        System.arraycopy(word, 0, lowerBuffer, 0, length);
        lowerBuffer[0] = this.dictionary.caseFold(lowerBuffer[0]);
        return lowerBuffer;
    }

    private static char[] capitalizeAfterApostrophe(char[] word, int length) {
        for (int i = 1; i < length - 1; ++i) {
            char next;
            char upper;
            if (word[i] != '\'' || (upper = Character.toUpperCase(next = word[i + 1])) == next) continue;
            char[] copy = ArrayUtil.copyOfSubArray(word, 0, length);
            copy[i + 1] = Character.toUpperCase(upper);
            return copy;
        }
        return null;
    }

    private boolean varySharpS(final char[] word, final int length, CaseVariationProcessor processor) {
        Stream<String> result = new Object(){

            int findSS(int start) {
                for (int i = start; i < length - 1; ++i) {
                    if (word[i] != 's' || word[i + 1] != 's') continue;
                    return i;
                }
                return -1;
            }

            Stream<String> replaceSS(int start, int depth) {
                if (depth > 5) {
                    return Stream.of(new String(word, start, length - start));
                }
                int ss = this.findSS(start);
                if (ss < 0) {
                    return null;
                }
                String prefix = new String(word, start, ss - start);
                Stream<String> tails = this.replaceSS(ss + 2, depth + 1);
                if (tails == null) {
                    tails = Stream.of(new String(word, ss + 2, length - ss - 2));
                }
                return tails.flatMap(s -> Stream.of(prefix + "ss" + s, prefix + "\u00df" + s));
            }
        }.replaceSS(0, 0);
        if (result == null) {
            return true;
        }
        String src = new String(word, 0, length);
        for (String s : result.collect(Collectors.toList())) {
            if (s.equals(src) || processor.process(s.toCharArray(), s.length(), null)) continue;
            return false;
        }
        return true;
    }

    boolean doStem(char[] word, int offset, int length, WordContext context2, RootProcessor processor) {
        IntsRef forms = this.dictionary.lookupWord(word, offset, length);
        if (forms != null) {
            for (int i = 0; i < forms.length; i += this.formStep) {
                int entryId = forms.ints[forms.offset + i];
                if (this.dictionary.hasFlag(entryId, this.dictionary.needaffix)) continue;
                if ((context2 == WordContext.COMPOUND_BEGIN || context2 == WordContext.COMPOUND_MIDDLE) && this.dictionary.hasFlag(entryId, this.dictionary.compoundForbid)) {
                    return false;
                }
                if (!this.isRootCompatibleWithContext(context2, -1, entryId) || this.callProcessor(word, offset, length, processor, forms, i)) continue;
                return false;
            }
        }
        return this.stem(word, offset, length, context2, -1, '\u0000', -1, 0, true, false, processor);
    }

    public List<CharsRef> uniqueStems(char[] word, int length) {
        List<CharsRef> stems = this.stem(word, length);
        if (stems.size() < 2) {
            return stems;
        }
        CharArraySet terms = new CharArraySet(8, this.dictionary.ignoreCase);
        ArrayList<CharsRef> deduped = new ArrayList<CharsRef>();
        for (CharsRef s : stems) {
            if (terms.contains(s)) continue;
            deduped.add(s);
            terms.add(s);
        }
        return deduped;
    }

    private String stemException(int morphDataId) {
        if (morphDataId > 0) {
            int start;
            String data = this.dictionary.morphData.get(morphDataId);
            int n = start = data.startsWith("st:") ? 0 : data.indexOf(" st:");
            if (start >= 0) {
                int nextSpace = data.indexOf(32, start + 3);
                return data.substring(start + 3, nextSpace < 0 ? data.length() : nextSpace);
            }
        }
        return null;
    }

    private CharsRef newStem(CharsRef stem, int morphDataId) {
        String exception = this.stemException(morphDataId);
        if (this.dictionary.oconv != null) {
            StringBuilder scratchSegment = new StringBuilder();
            if (exception != null) {
                scratchSegment.append(exception);
            } else {
                scratchSegment.append(stem.chars, stem.offset, stem.length);
            }
            this.dictionary.oconv.applyMappings(scratchSegment);
            char[] cleaned = new char[scratchSegment.length()];
            scratchSegment.getChars(0, cleaned.length, cleaned, 0);
            return new CharsRef(cleaned, 0, cleaned.length);
        }
        if (exception != null) {
            return new CharsRef(exception);
        }
        return stem;
    }

    private boolean stem(char[] word, int offset, int length, WordContext context2, int previous, char prevFlag, int prefixId, int recursionDepth, boolean doPrefix, boolean previousWasPrefix, RootProcessor processor) {
        boolean pureAffix;
        char[] strippedWord;
        int j;
        int i;
        int limit;
        IntsRef output;
        FST.BytesReader reader;
        FST<IntsRef> fst;
        FST.Arc<IntsRef> arc = new FST.Arc<IntsRef>();
        if (doPrefix && this.dictionary.prefixes != null) {
            fst = this.dictionary.prefixes;
            reader = fst.getBytesReader();
            fst.getFirstArc(arc);
            output = (IntsRef)fst.outputs.getNoOutput();
            limit = this.dictionary.fullStrip ? length + 1 : length;
            for (i = 0; i < limit && (i <= 0 || (output = Dictionary.nextArc(fst, arc, reader, output, word[offset + i - 1])) != null); ++i) {
                if (!arc.isFinal()) continue;
                IntsRef prefixes = fst.outputs.add(output, (IntsRef)arc.nextFinalOutput());
                for (j = 0; j < prefixes.length; ++j) {
                    int prefix = prefixes.ints[prefixes.offset + j];
                    if (prefix == previous || !this.isAffixCompatible(prefix, prevFlag, recursionDepth, true, false, context2) || (strippedWord = this.stripAffix(word, offset, length, i, prefix, true)) == null || this.applyAffix(strippedWord, (pureAffix = strippedWord == word) ? offset + i : 0, pureAffix ? length - i : strippedWord.length, context2, prefix, previous, -1, recursionDepth, true, processor)) continue;
                    return false;
                }
            }
        }
        if (this.dictionary.suffixes != null) {
            fst = this.dictionary.suffixes;
            reader = fst.getBytesReader();
            fst.getFirstArc(arc);
            output = (IntsRef)fst.outputs.getNoOutput();
            limit = this.dictionary.fullStrip ? 0 : 1;
            for (i = length; i >= limit && (i >= length || (output = Dictionary.nextArc(fst, arc, reader, output, word[offset + i])) != null); --i) {
                if (!arc.isFinal()) continue;
                IntsRef suffixes = fst.outputs.add(output, (IntsRef)arc.nextFinalOutput());
                for (j = 0; j < suffixes.length; ++j) {
                    int suffix = suffixes.ints[suffixes.offset + j];
                    if (suffix == previous || !this.isAffixCompatible(suffix, prevFlag, recursionDepth, false, previousWasPrefix, context2) || (strippedWord = this.stripAffix(word, offset, length, length - i, suffix, false)) == null || this.applyAffix(strippedWord, (pureAffix = strippedWord == word) ? offset : 0, pureAffix ? i : strippedWord.length, context2, suffix, previous, prefixId, recursionDepth, false, processor)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private char[] stripAffix(char[] word, int offset, int length, int affixLen, int affix, boolean isPrefix) {
        int stripStart;
        int deAffixedLen = length - affixLen;
        char stripOrd = this.dictionary.affixData(affix, 1);
        int stripEnd = this.dictionary.stripOffsets[stripOrd + '\u0001'];
        int stripLen = stripEnd - (stripStart = this.dictionary.stripOffsets[stripOrd]);
        if (stripLen + deAffixedLen == 0) {
            return null;
        }
        char[] stripData = this.dictionary.stripData;
        int condition = this.dictionary.getAffixCondition(affix);
        if (condition != 0) {
            int deAffixedOffset;
            int n = deAffixedOffset = isPrefix ? offset + affixLen : offset;
            if (!this.dictionary.patterns.get(condition).acceptsStem(word, deAffixedOffset, deAffixedLen)) {
                return null;
            }
        }
        if (stripLen == 0) {
            return word;
        }
        char[] strippedWord = new char[stripLen + deAffixedLen];
        System.arraycopy(word, offset + (isPrefix ? affixLen : 0), strippedWord, isPrefix ? stripLen : 0, deAffixedLen);
        System.arraycopy(stripData, stripStart, strippedWord, isPrefix ? 0 : deAffixedLen, stripLen);
        return strippedWord;
    }

    private boolean isAffixCompatible(int affix, char prevFlag, int recursionDepth, boolean isPrefix, boolean previousWasPrefix, WordContext context2) {
        char append = this.dictionary.affixData(affix, 3);
        if (context2.isCompound()) {
            if (!isPrefix && this.dictionary.hasFlag(append, this.dictionary.compoundForbid)) {
                return false;
            }
            if (!context2.isAffixAllowedWithoutSpecialPermit(isPrefix) && !this.dictionary.hasFlag(append, this.dictionary.compoundPermit)) {
                return false;
            }
            if (context2 == WordContext.COMPOUND_END && !isPrefix && !previousWasPrefix && this.dictionary.hasFlag(append, this.dictionary.onlyincompound)) {
                return false;
            }
        } else if (this.dictionary.hasFlag(append, this.dictionary.onlyincompound)) {
            return false;
        }
        if (recursionDepth == 0) {
            return true;
        }
        if (this.dictionary.isCrossProduct(affix)) {
            return previousWasPrefix || this.dictionary.hasFlag(append, prevFlag);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean applyAffix(char[] strippedWord, int offset, int length, WordContext context2, int affix, int previousAffix, int prefixId, int recursionDepth, boolean prefix, RootProcessor processor) {
        boolean doPrefix;
        IntsRef forms;
        char flag = this.dictionary.affixData(affix, 0);
        boolean skipLookup = this.needsAnotherAffix(affix, previousAffix, !prefix, prefixId);
        IntsRef intsRef = forms = skipLookup ? null : this.dictionary.lookupWord(strippedWord, offset, length);
        if (forms != null) {
            for (int i = 0; i < forms.length; i += this.formStep) {
                char prefixFlag;
                boolean chainedPrefix;
                int entryId = forms.ints[forms.offset + i];
                if (!this.dictionary.hasFlag(entryId, flag) && !this.isFlagAppendedByAffix(prefixId, flag)) continue;
                boolean bl = chainedPrefix = this.dictionary.complexPrefixes && recursionDepth == 1 && prefix;
                if (!chainedPrefix && prefixId >= 0 && !this.dictionary.hasFlag(entryId, prefixFlag = this.dictionary.affixData(prefixId, 0)) && !this.isFlagAppendedByAffix(affix, prefixFlag) || !this.isRootCompatibleWithContext(context2, affix, entryId) || this.callProcessor(strippedWord, offset, length, processor, forms, i)) continue;
                return false;
            }
        }
        if (!this.dictionary.isCrossProduct(affix) || recursionDepth > 1) return true;
        if (recursionDepth == 0) {
            if (prefix) {
                prefixId = affix;
                doPrefix = this.dictionary.complexPrefixes && this.dictionary.isSecondStagePrefix(flag);
                return this.stem(strippedWord, offset, length, context2, affix, flag, prefixId, recursionDepth + 1, doPrefix, prefix, processor);
            } else {
                if (this.dictionary.complexPrefixes || !this.dictionary.isSecondStageSuffix(flag)) return true;
                doPrefix = false;
            }
            return this.stem(strippedWord, offset, length, context2, affix, flag, prefixId, recursionDepth + 1, doPrefix, prefix, processor);
        } else {
            doPrefix = false;
            if (prefix && this.dictionary.complexPrefixes) {
                prefixId = affix;
                return this.stem(strippedWord, offset, length, context2, affix, flag, prefixId, recursionDepth + 1, doPrefix, prefix, processor);
            } else {
                if (!prefix && !this.dictionary.complexPrefixes && this.dictionary.isSecondStageSuffix(flag)) return this.stem(strippedWord, offset, length, context2, affix, flag, prefixId, recursionDepth + 1, doPrefix, prefix, processor);
                return true;
            }
        }
    }

    private boolean isRootCompatibleWithContext(WordContext context2, int lastAffix, int entryId) {
        if (!context2.isCompound() && this.dictionary.hasFlag(entryId, this.dictionary.onlyincompound)) {
            return false;
        }
        if (context2.isCompound() && context2 != WordContext.COMPOUND_RULE_END) {
            char cFlag = context2.requiredFlag(this.dictionary);
            return this.dictionary.hasFlag(entryId, cFlag) || this.isFlagAppendedByAffix(lastAffix, cFlag) || this.dictionary.hasFlag(entryId, this.dictionary.compoundFlag) || this.isFlagAppendedByAffix(lastAffix, this.dictionary.compoundFlag);
        }
        return true;
    }

    private boolean callProcessor(char[] word, int offset, int length, RootProcessor processor, IntsRef forms, int i) {
        CharsRef stem = new CharsRef(word, offset, length);
        int morphDataId = this.dictionary.hasCustomMorphData ? forms.ints[forms.offset + i + 1] : 0;
        return processor.processRoot(stem, forms.ints[forms.offset + i], morphDataId);
    }

    private boolean needsAnotherAffix(int affix, int previousAffix, boolean isSuffix, int prefixId) {
        char circumfix = this.dictionary.circumfix;
        if (isSuffix && this.isFlagAppendedByAffix(prefixId, circumfix) != this.isFlagAppendedByAffix(affix, circumfix)) {
            return true;
        }
        if (this.isFlagAppendedByAffix(affix, this.dictionary.needaffix)) {
            return !isSuffix || previousAffix < 0 || this.isFlagAppendedByAffix(previousAffix, this.dictionary.needaffix);
        }
        return false;
    }

    private boolean isFlagAppendedByAffix(int affixId, char flag) {
        if (affixId < 0 || flag == '\u0000') {
            return false;
        }
        char appendId = this.dictionary.affixData(affixId, 3);
        return this.dictionary.hasFlag(appendId, flag);
    }

    static interface RootProcessor {
        public boolean processRoot(CharsRef var1, int var2, int var3);
    }

    static interface CaseVariationProcessor {
        public boolean process(char[] var1, int var2, WordCase var3);
    }
}

