/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

public class RiotChars {
    public static boolean isAlpha(int codepoint) {
        return Character.isLetter(codepoint);
    }

    public static boolean isAlphaNumeric(int codepoint) {
        return Character.isLetterOrDigit(codepoint);
    }

    public static boolean isA2Z(int ch) {
        return RiotChars.range(ch, 97, 122) || RiotChars.range(ch, 65, 90);
    }

    public static boolean isA2ZN(int ch) {
        return RiotChars.range(ch, 97, 122) || RiotChars.range(ch, 65, 90) || RiotChars.range(ch, 48, 57);
    }

    public static boolean isDigit(int ch) {
        return RiotChars.range(ch, 48, 57);
    }

    public static boolean isWhitespace(int ch) {
        return RiotChars.isHorizontalWhitespace(ch) || RiotChars.isNewlineChar(ch) || ch == 12;
    }

    public static boolean isHorizontalWhitespace(int ch) {
        return ch == 32 || ch == 9;
    }

    public static boolean isNewlineChar(int ch) {
        return ch == 13 || ch == 10;
    }

    public static boolean isPNCharsBase(int ch) {
        return RiotChars.range(ch, 97, 122) || RiotChars.range(ch, 65, 90) || RiotChars.range(ch, 192, 214) || RiotChars.range(ch, 216, 246) || RiotChars.range(ch, 248, 767) || RiotChars.range(ch, 880, 893) || RiotChars.range(ch, 895, 8191) || RiotChars.range(ch, 8204, 8205) || RiotChars.range(ch, 8304, 8591) || RiotChars.range(ch, 11264, 12271) || RiotChars.range(ch, 12289, 55295) || RiotChars.range(ch, 55296, 57343) || RiotChars.range(ch, 63744, 64975) || RiotChars.range(ch, 65008, 65533) || RiotChars.range(ch, 65536, 983039);
    }

    public static boolean isPNChars_U(int ch) {
        return RiotChars.isPNCharsBase(ch) || ch == 95;
    }

    public static boolean isPNChars_U_N(int ch) {
        return RiotChars.isPNCharsBase(ch) || ch == 95 || RiotChars.isDigit(ch);
    }

    public static boolean isPNChars(int ch) {
        return RiotChars.isPNChars_U(ch) || RiotChars.isDigit(ch) || ch == 45 || ch == 183 || RiotChars.range(ch, 768, 879) || RiotChars.range(ch, 8255, 8256);
    }

    public static boolean isPN_LOCAL_ESC(char ch) {
        switch (ch) {
            case '!': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ';': 
            case '=': 
            case '?': 
            case '@': 
            case '_': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public static boolean isHexChar(int ch) {
        return RiotChars.range(ch, 48, 57) || RiotChars.range(ch, 97, 102) || RiotChars.range(ch, 65, 70);
    }

    public static boolean isHexCharLC(int ch) {
        return RiotChars.range(ch, 48, 57) || RiotChars.range(ch, 97, 102);
    }

    public static boolean isHexCharUC(int ch) {
        return RiotChars.range(ch, 48, 57) || RiotChars.range(ch, 65, 70);
    }

    public static int valHexChar(int ch) {
        if (RiotChars.range(ch, 48, 57)) {
            return ch - 48;
        }
        if (RiotChars.range(ch, 97, 102)) {
            return ch - 97 + 10;
        }
        if (RiotChars.range(ch, 65, 70)) {
            return ch - 65 + 10;
        }
        return -1;
    }

    public static boolean range(int ch, int a, int b) {
        return ch >= a && ch <= b;
    }
}

