/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import java.io.File;
import java.io.IOException;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextDatasetFactory;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexConfig;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.assembler.DefineAnalyzersAssembler;
import org.apache.jena.query.text.assembler.DefineFiltersAssembler;
import org.apache.jena.query.text.assembler.DefineTokenizersAssembler;
import org.apache.jena.query.text.assembler.PropListsAssembler;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.FSDirectory;

public class TextIndexLuceneAssembler
extends AssemblerBase {
    @Override
    public TextIndex open(Assembler a, Resource root2, Mode mode) {
        try {
            Statement defAnalyzersStatement;
            Statement propListsStmt;
            BaseDirectory directory;
            if (!GraphUtils.exactlyOneProperty(root2, TextVocab.pDirectory)) {
                throw new TextIndexException("No 'text:directory' property on " + root2);
            }
            RDFNode n = root2.getProperty(TextVocab.pDirectory).getObject();
            if (n.isLiteral()) {
                String literalValue = n.asLiteral().getLexicalForm();
                if (literalValue.equals("mem")) {
                    directory = new ByteBuffersDirectory();
                } else {
                    File dir = new File(literalValue);
                    directory = FSDirectory.open(dir.toPath());
                }
            } else {
                Resource x = n.asResource();
                String path = IRILib.IRIToFilename(x.getURI());
                File dir = new File(path);
                directory = FSDirectory.open(dir.toPath());
            }
            String queryParser = null;
            Statement queryParserStatement = root2.getProperty(TextVocab.pQueryParser);
            if (null != queryParserStatement) {
                RDFNode qpNode = queryParserStatement.getObject();
                if (!qpNode.isResource()) {
                    throw new TextIndexException("Text query parser property is not a resource : " + qpNode);
                }
                Resource parserResource = (Resource)qpNode;
                queryParser = parserResource.getLocalName();
            }
            boolean isMultilingualSupport = false;
            Statement mlSupportStatement = root2.getProperty(TextVocab.pMultilingualSupport);
            if (null != mlSupportStatement) {
                RDFNode mlsNode = mlSupportStatement.getObject();
                if (!mlsNode.isLiteral()) {
                    throw new TextIndexException("text:multilingualSupport property must be a boolean : " + mlsNode);
                }
                isMultilingualSupport = mlsNode.asLiteral().getBoolean();
            }
            int maxBasicQueries = 1024;
            Statement maxBasicQueriesStatement = root2.getProperty(TextVocab.pMaxBasicQueries);
            if (null != maxBasicQueriesStatement) {
                RDFNode mbqNode = maxBasicQueriesStatement.getObject();
                if (!mbqNode.isLiteral()) {
                    throw new TextIndexException("text:maxBasicQueries property must be a int : " + mbqNode);
                }
                try {
                    maxBasicQueries = mbqNode.asLiteral().getInt();
                }
                catch (RuntimeException ex) {
                    throw new TextIndexException("text:maxBasicQueries property must be a int : " + mbqNode + "(" + ex.getMessage() + ")");
                }
            }
            if (null != (propListsStmt = root2.getProperty(TextVocab.pPropLists))) {
                RDFNode aNode = propListsStmt.getObject();
                if (!aNode.isResource()) {
                    throw new TextIndexException("text:propLists property is not a resource (list) : " + aNode);
                }
                PropListsAssembler.open(a, (Resource)aNode);
            }
            if (null != (defAnalyzersStatement = root2.getProperty(TextVocab.pDefAnalyzers))) {
                RDFNode aNode = defAnalyzersStatement.getObject();
                if (!aNode.isResource()) {
                    throw new TextIndexException("text:defineAnalyzers property is not a resource (list) : " + aNode);
                }
                DefineFiltersAssembler.open(a, (Resource)aNode);
                DefineTokenizersAssembler.open(a, (Resource)aNode);
                boolean addedLangs = DefineAnalyzersAssembler.open(a, (Resource)aNode);
                if (addedLangs) {
                    if (!isMultilingualSupport) {
                        Log.warn(this, "Multilingual support implicitly enabled by text:defineAnalyzers");
                    }
                    isMultilingualSupport = true;
                }
            }
            Analyzer analyzer = null;
            Statement analyzerStatement = root2.getProperty(TextVocab.pAnalyzer);
            if (null != analyzerStatement) {
                RDFNode aNode = analyzerStatement.getObject();
                if (!aNode.isResource()) {
                    throw new TextIndexException("Text analyzer property is not a resource : " + aNode);
                }
                Resource analyzerResource = (Resource)aNode;
                analyzer = (Analyzer)a.open(analyzerResource);
            }
            Analyzer queryAnalyzer = null;
            Statement queryAnalyzerStatement = root2.getProperty(TextVocab.pQueryAnalyzer);
            if (null != queryAnalyzerStatement) {
                RDFNode qaNode = queryAnalyzerStatement.getObject();
                if (!qaNode.isResource()) {
                    throw new TextIndexException("Text query analyzer property is not a resource : " + qaNode);
                }
                Resource analyzerResource = (Resource)qaNode;
                queryAnalyzer = (Analyzer)a.open(analyzerResource);
            }
            boolean storeValues = false;
            Statement storeValuesStatement = root2.getProperty(TextVocab.pStoreValues);
            if (null != storeValuesStatement) {
                RDFNode svNode = storeValuesStatement.getObject();
                if (!svNode.isLiteral()) {
                    throw new TextIndexException("text:storeValues property must be a boolean : " + svNode);
                }
                storeValues = svNode.asLiteral().getBoolean();
            }
            boolean ignoreIndexErrs = false;
            Statement ignoreIndexErrsStatement = root2.getProperty(TextVocab.pIgnoreIndexErrors);
            if (null != ignoreIndexErrsStatement) {
                RDFNode iieNode = ignoreIndexErrsStatement.getObject();
                if (!iieNode.isLiteral()) {
                    throw new TextIndexException("text:ignoreIndexErrors property must be a boolean : " + iieNode);
                }
                ignoreIndexErrs = iieNode.asLiteral().getBoolean();
            }
            boolean cacheQueries = true;
            Statement cacheQueriesStatement = root2.getProperty(TextVocab.pCacheQueries);
            if (null != cacheQueriesStatement) {
                RDFNode cqNode = cacheQueriesStatement.getObject();
                if (!cqNode.isLiteral()) {
                    throw new TextIndexException("text:cacheQueries property must be a boolean : " + cqNode);
                }
                cacheQueries = cqNode.asLiteral().getBoolean();
            }
            Resource r = GraphUtils.getResourceValue(root2, TextVocab.pEntityMap);
            EntityDefinition docDef = (EntityDefinition)a.open(r);
            TextIndexConfig config = new TextIndexConfig(docDef);
            config.setAnalyzer(analyzer);
            config.setQueryAnalyzer(queryAnalyzer);
            config.setQueryParser(queryParser);
            config.setMultilingualSupport(isMultilingualSupport);
            config.setMaxBasicQueries(maxBasicQueries);
            config.setValueStored(storeValues);
            config.setIgnoreIndexErrors(ignoreIndexErrs);
            docDef.setCacheQueries(cacheQueries);
            return TextDatasetFactory.createLuceneIndex(directory, config);
        }
        catch (IOException e2) {
            IO.exception(e2);
            return null;
        }
    }
}

