/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;

public class ThreadLib {
    private static ExecutorService executor = Executors.newCachedThreadPool();

    public static void async(Runnable r) {
        Semaphore semaStart = new Semaphore(0, true);
        Runnable r2 = () -> {
            semaStart.release(1);
            r.run();
        };
        executor.execute(r2);
        semaStart.acquireUninterruptibly();
    }

    public static void syncOtherThread(Runnable r) {
        ThreadLib.runCallable(() -> {
            r.run();
            return null;
        });
    }

    public static <T> T syncCallThread(Supplier<T> r) {
        return (T)ThreadLib.runCallable(() -> {
            Object t = r.get();
            return t;
        });
    }

    private static <T> T runCallable(Callable<T> action) {
        try {
            return executor.submit(action).get();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static void withBeforeAfter(Runnable action, Runnable before, Runnable after) {
        before.run();
        try {
            action.run();
        }
        finally {
            after.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V callWithBeforeAfter(Supplier<V> action, Runnable before, Runnable after) {
        before.run();
        try {
            V v = action.get();
            return v;
        }
        finally {
            after.run();
        }
    }

    public static void withAfter(Runnable action, Runnable after) {
        try {
            action.run();
        }
        finally {
            after.run();
        }
    }

    public static <V> V callWithAfter(Supplier<V> action, Runnable after) {
        try {
            V v = action.get();
            return v;
        }
        finally {
            after.run();
        }
    }

    public static <V> V callWithLock(Lock lock, Supplier<V> r) {
        return ThreadLib.callWithBeforeAfter(r, () -> lock.lock(), () -> lock.unlock());
    }

    public static void withLock(Lock lock, Runnable r) {
        ThreadLib.withBeforeAfter(r, () -> lock.lock(), () -> lock.unlock());
    }
}

