# pytest-anki
#
# Copyright (C)  2019-2022 Aristotelis P. <https://glutanimate.com/>
#                and contributors (see CONTRIBUTORS file)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version, with the additions
# listed at the end of the license file that accompanied this program.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# NOTE: This program is subject to certain additional terms pursuant to
# Section 7 of the GNU Affero General Public License.  You should have
# received a copy of these additional terms immediately following the
# terms and conditions of the GNU Affero General Public License that
# accompanied this program.
#
# If not, please request a copy through one of the means of contact
# listed here: <https://glutanimate.com/contact/>.
#
# Any modifications to this file must keep this entire header intact.

import json
from dataclasses import dataclass
from pathlib import Path

from packaging.version import Version

_ANKI_CURRENT_FILE = "anki-current.json"
_ANKI_CURRENT_FILE_PATH = Path(__file__).parent / _ANKI_CURRENT_FILE


@dataclass
class LatestTestedLibraryVersions:
    anki: Version
    python: Version
    pyqt: Version
    pyqtwebengine: Version
    chrome: Version


def get_latest_tested_lib_versions() -> LatestTestedLibraryVersions:
    with _ANKI_CURRENT_FILE_PATH.open("r", encoding="utf-8") as anki_current_file:
        anki_current_data = json.load(anki_current_file)
    return LatestTestedLibraryVersions(
        **{key: Version(value) for key, value in anki_current_data.items()}
    )
