"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GENERIC_AVATAR = void 0;
exports.generateGravatarUrl = generateGravatarUrl;

var _lodash = _interopRequireDefault(require("lodash"));

var _cryptoUtils = require("../lib/crypto-utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// @flow
// this is a generic avatar
// https://www.iconfinder.com/icons/403017/anonym_avatar_default_head_person_unknown_user_icon
// license: free commercial usage
const GENERIC_AVATAR = 'data:image/svg+xml;utf8,' + encodeURIComponent('<svg height="100" viewBox="-27 24 100 100" width="100" xmlns="http://www.w3.org/' + '2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><defs><circle cx="23" cy="7' + '4" id="a" r="50"/></defs><use fill="#F5EEE5" overflow="visible" xlink:href="#a"/' + '><clipPath id="b"><use overflow="visible" xlink:href="#a"/></clipPath><g clip-pa' + 'th="url(#b)"><defs><path d="M36 95.9c0 4 4.7 5.2 7.1 5.8 7.6 2 22.8 5.9 22.8 5.9' + ' 3.2 1.1 5.7 3.5 7.1 6.6v9.8H-27v-9.8c1.3-3.1 3.9-5.5 7.1-6.6 0 0 15.2-3.9 22.8-' + '5.9 2.4-.6 7.1-1.8 7.1-5.8V85h26v10.9z" id="c"/></defs><use fill="#E6C19C" overf' + 'low="visible" xlink:href="#c"/><clipPath id="d"><use overflow="visible" xlink:hr' + 'ef="#c"/></clipPath><path clip-path="url(#d)" d="M23.2 35h.2c3.3 0 8.2.2 11.4 2 ' + '3.3 1.9 7.3 5.6 8.5 12.1 2.4 13.7-2.1 35.4-6.3 42.4-4 6.7-9.8 9.2-13.5 9.4H23h-.' + '1c-3.7-.2-9.5-2.7-13.5-9.4-4.2-7-8.7-28.7-6.3-42.4 1.2-6.5 5.2-10.2 8.5-12.1 3.2' + '-1.8 8.1-2 11.4-2h.2z" fill="#D4B08C"/></g><path d="M22.6 40c19.1 0 20.7 13.8 20' + '.8 15.1 1.1 11.9-3 28.1-6.8 33.7-4 5.9-9.8 8.1-13.5 8.3h-.5c-3.8-.3-9.6-2.5-13.6' + '-8.4-3.8-5.6-7.9-21.8-6.8-33.8C2.3 53.7 3.5 40 22.6 40z" fill="#F2CEA5"/></svg>');
/**
 * Generate gravatar url from email address
 */

exports.GENERIC_AVATAR = GENERIC_AVATAR;

function generateGravatarUrl(email = '', online = true) {
  if (online && _lodash.default.isString(email) && _lodash.default.size(email) > 0) {
    email = email.trim().toLocaleLowerCase();
    const emailMD5 = (0, _cryptoUtils.stringToMD5)(email);
    return `https://www.gravatar.com/avatar/${emailMD5}`;
  }

  return GENERIC_AVATAR;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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