"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupUpLinks = setupUpLinks;
exports.updateVersionsHiddenUpLink = updateVersionsHiddenUpLink;

var _upStorage = _interopRequireDefault(require("./up-storage"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Set up the Up Storage for each link.
 */
function setupUpLinks(config) {
  const uplinks = {};

  for (const uplinkName in config.uplinks) {
    if (Object.prototype.hasOwnProperty.call(config.uplinks, uplinkName)) {
      // instance for each up-link definition
      const proxy = new _upStorage.default(config.uplinks[uplinkName], config);
      proxy.upname = uplinkName;
      uplinks[uplinkName] = proxy;
    }
  }

  return uplinks;
}

function updateVersionsHiddenUpLink(versions, upLink) {
  for (const i in versions) {
    if (Object.prototype.hasOwnProperty.call(versions, i)) {
      const version = versions[i]; // holds a "hidden" value to be used by the package storage.
      // $FlowFixMe

      version[Symbol.for('__verdaccio_uplink')] = upLink.upname;
    }
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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