"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeVersions = mergeVersions;

var _lodash = _interopRequireDefault(require("lodash"));

var _semver = _interopRequireDefault(require("semver"));

var _constants = require("./constants");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Function gets a local info and an info from uplinks and tries to merge it
 exported for unit tests only.
  * @param {*} local
  * @param {*} up
  * @param {*} config
  * @static
  */
function mergeVersions(local, up) {
  // copy new versions to a cache
  // NOTE: if a certain version was updated, we can't refresh it reliably
  for (const i in up.versions) {
    if (_lodash.default.isNil(local.versions[i])) {
      local.versions[i] = up.versions[i];
    }
  }

  for (const i in up[_constants.DIST_TAGS]) {
    if (local[_constants.DIST_TAGS][i] !== up[_constants.DIST_TAGS][i]) {
      if (!local[_constants.DIST_TAGS][i] || _semver.default.lte(local[_constants.DIST_TAGS][i], up[_constants.DIST_TAGS][i])) {
        local[_constants.DIST_TAGS][i] = up[_constants.DIST_TAGS][i];
      }

      if (i === 'latest' && local[_constants.DIST_TAGS][i] === up[_constants.DIST_TAGS][i]) {
        // if remote has more fresh package, we should borrow its readme
        local.readme = up.readme;
      }
    }
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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