"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FORMAT_DATE = exports.CUSTOM_PAD_LENGTH = void 0;
exports.formatLoggingDate = formatLoggingDate;
exports.padLeft = padLeft;
exports.padRight = padRight;

var _dayjs = _interopRequireDefault(require("dayjs"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const FORMAT_DATE = 'YYYY-MM-DD HH:mm:ss';
exports.FORMAT_DATE = FORMAT_DATE;
const CUSTOM_PAD_LENGTH = 1;
exports.CUSTOM_PAD_LENGTH = CUSTOM_PAD_LENGTH;

function formatLoggingDate(time) {
  return (0, _dayjs.default)(time).format(FORMAT_DATE);
}

function padLeft(message) {
  return message.padStart(message.length + CUSTOM_PAD_LENGTH, ' ');
}

function padRight(message, max = message.length + CUSTOM_PAD_LENGTH) {
  return message.padEnd(max, ' ');
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJGT1JNQVRfREFURSIsIkNVU1RPTV9QQURfTEVOR1RIIiwiZm9ybWF0TG9nZ2luZ0RhdGUiLCJ0aW1lIiwiZGF5anMiLCJmb3JtYXQiLCJwYWRMZWZ0IiwibWVzc2FnZSIsInBhZFN0YXJ0IiwibGVuZ3RoIiwicGFkUmlnaHQiLCJtYXgiLCJwYWRFbmQiXSwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvbGliL2xvZ2dlci91dGlscy50cyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgZGF5anMgZnJvbSAnZGF5anMnO1xuXG5leHBvcnQgY29uc3QgRk9STUFUX0RBVEUgPSAnWVlZWS1NTS1ERCBISDptbTpzcyc7XG5leHBvcnQgY29uc3QgQ1VTVE9NX1BBRF9MRU5HVEggPSAxO1xuXG5leHBvcnQgZnVuY3Rpb24gZm9ybWF0TG9nZ2luZ0RhdGUodGltZTogc3RyaW5nKTogc3RyaW5nIHtcbiAgcmV0dXJuIGRheWpzKHRpbWUpLmZvcm1hdChGT1JNQVRfREFURSk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBwYWRMZWZ0KG1lc3NhZ2U6IHN0cmluZykge1xuICByZXR1cm4gbWVzc2FnZS5wYWRTdGFydChtZXNzYWdlLmxlbmd0aCArIENVU1RPTV9QQURfTEVOR1RILCAnICcpO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gcGFkUmlnaHQobWVzc2FnZTogc3RyaW5nLCBtYXggPSBtZXNzYWdlLmxlbmd0aCArIENVU1RPTV9QQURfTEVOR1RIKSB7XG4gIHJldHVybiBtZXNzYWdlLnBhZEVuZChtYXgsICcgJyk7XG59XG4iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7QUFBQTs7OztBQUVPLE1BQU1BLFdBQVcsR0FBRyxxQkFBcEI7O0FBQ0EsTUFBTUMsaUJBQWlCLEdBQUcsQ0FBMUI7OztBQUVBLFNBQVNDLGlCQUFULENBQTJCQyxJQUEzQixFQUFpRDtFQUN0RCxPQUFPLElBQUFDLGNBQUEsRUFBTUQsSUFBTixFQUFZRSxNQUFaLENBQW1CTCxXQUFuQixDQUFQO0FBQ0Q7O0FBRU0sU0FBU00sT0FBVCxDQUFpQkMsT0FBakIsRUFBa0M7RUFDdkMsT0FBT0EsT0FBTyxDQUFDQyxRQUFSLENBQWlCRCxPQUFPLENBQUNFLE1BQVIsR0FBaUJSLGlCQUFsQyxFQUFxRCxHQUFyRCxDQUFQO0FBQ0Q7O0FBRU0sU0FBU1MsUUFBVCxDQUFrQkgsT0FBbEIsRUFBbUNJLEdBQUcsR0FBR0osT0FBTyxDQUFDRSxNQUFSLEdBQWlCUixpQkFBMUQsRUFBNkU7RUFDbEYsT0FBT00sT0FBTyxDQUFDSyxNQUFSLENBQWVELEdBQWYsRUFBb0IsR0FBcEIsQ0FBUDtBQUNEIn0=