"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aesDecrypt = aesDecrypt;
exports.aesEncrypt = aesEncrypt;
exports.createTarballHash = createTarballHash;
exports.defaultTarballHashAlgorithm = exports.defaultAlgorithm = void 0;
exports.generateRandomHexString = generateRandomHexString;
exports.signPayload = signPayload;
exports.stringToMD5 = stringToMD5;
exports.verifyPayload = verifyPayload;

var _crypto = require("crypto");

var _jsonwebtoken = _interopRequireDefault(require("jsonwebtoken"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const defaultAlgorithm = 'aes192';
exports.defaultAlgorithm = defaultAlgorithm;
const defaultTarballHashAlgorithm = 'sha1';
exports.defaultTarballHashAlgorithm = defaultTarballHashAlgorithm;

function aesEncrypt(buf, secret) {
  // deprecated (it will be migrated in Verdaccio 5), it is a breaking change
  // https://nodejs.org/api/crypto.html#crypto_crypto_createcipher_algorithm_password_options
  // https://www.grainger.xyz/changing-from-cipher-to-cipheriv/
  const c = (0, _crypto.createCipher)(defaultAlgorithm, secret);
  const b1 = c.update(buf);
  const b2 = c.final();
  return Buffer.concat([b1, b2]);
}

function aesDecrypt(buf, secret) {
  try {
    // deprecated (it will be migrated in Verdaccio 5), it is a breaking change
    // https://nodejs.org/api/crypto.html#crypto_crypto_createdecipher_algorithm_password_options
    // https://www.grainger.xyz/changing-from-cipher-to-cipheriv/
    const c = (0, _crypto.createDecipher)(defaultAlgorithm, secret);
    const b1 = c.update(buf);
    const b2 = c.final();
    return Buffer.concat([b1, b2]);
  } catch (_) {
    return Buffer.alloc(0);
  }
}

function createTarballHash() {
  return (0, _crypto.createHash)(defaultTarballHashAlgorithm);
}
/**
 * Express doesn't do ETAGS with requests <= 1024b
 * we use md5 here, it works well on 1k+ bytes, but sucks with fewer data
 * could improve performance using crc32 after benchmarks.
 * @param {Object} data
 * @return {String}
 */


function stringToMD5(data) {
  return (0, _crypto.createHash)('md5').update(data).digest('hex');
}

function generateRandomHexString(length = 8) {
  return (0, _crypto.pseudoRandomBytes)(length).toString('hex');
}

async function signPayload(payload, secretOrPrivateKey, options) {
  return new Promise(function (resolve, reject) {
    return _jsonwebtoken.default.sign(payload, secretOrPrivateKey, _objectSpread({
      notBefore: '1'
    }, options), (error, token) => error ? reject(error) : resolve(token));
  });
}

function verifyPayload(token, secretOrPrivateKey) {
  return _jsonwebtoken.default.verify(token, secretOrPrivateKey);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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