"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.keyPem = exports.csrPem = exports.certPem = exports.WEB_TITLE = exports.USERS = exports.TOKEN_BEARER = exports.TOKEN_BASIC = exports.TIME_EXPIRATION_24H = exports.TIME_EXPIRATION_1H = exports.SUPPORT_ERRORS = exports.STORAGE = exports.ROLES = exports.PACKAGE_ACCESS = exports.MODULE_NOT_FOUND = exports.LATEST = exports.HTTP_STATUS = exports.HEADER_TYPE = exports.HEADERS = exports.ERROR_CODE = exports.DIST_TAGS = exports.DEFAULT_USER = exports.DEFAULT_UPLINK = exports.DEFAULT_REGISTRY = exports.DEFAULT_PROTOCOL = exports.DEFAULT_PORT = exports.DEFAULT_NO_README = exports.DEFAULT_MIN_LIMIT_PASSWORD = exports.DEFAULT_DOMAIN = exports.CHARACTER_ENCODING = exports.APP_ERROR = exports.API_MESSAGE = exports.API_ERROR = void 0;
const DEFAULT_PORT = '4873';
exports.DEFAULT_PORT = DEFAULT_PORT;
const DEFAULT_PROTOCOL = 'http';
exports.DEFAULT_PROTOCOL = DEFAULT_PROTOCOL;
const DEFAULT_DOMAIN = 'localhost';
exports.DEFAULT_DOMAIN = DEFAULT_DOMAIN;
const TIME_EXPIRATION_24H = '24h';
exports.TIME_EXPIRATION_24H = TIME_EXPIRATION_24H;
const TIME_EXPIRATION_1H = '1h';
exports.TIME_EXPIRATION_1H = TIME_EXPIRATION_1H;
const DIST_TAGS = 'dist-tags';
exports.DIST_TAGS = DIST_TAGS;
const LATEST = 'latest';
exports.LATEST = LATEST;
const USERS = 'users';
exports.USERS = USERS;
const DEFAULT_MIN_LIMIT_PASSWORD = 3;
exports.DEFAULT_MIN_LIMIT_PASSWORD = DEFAULT_MIN_LIMIT_PASSWORD;
const DEFAULT_USER = 'Anonymous';
exports.DEFAULT_USER = DEFAULT_USER;
const keyPem = 'verdaccio-key.pem';
exports.keyPem = keyPem;
const certPem = 'verdaccio-cert.pem';
exports.certPem = certPem;
const csrPem = 'verdaccio-csr.pem';
exports.csrPem = csrPem;
const HEADERS = {
  ACCEPT: 'Accept',
  ACCEPT_ENCODING: 'Accept-Encoding',
  USER_AGENT: 'User-Agent',
  JSON: 'application/json',
  CONTENT_TYPE: 'Content-type',
  CONTENT_LENGTH: 'content-length',
  CACHE_CONTROL: 'Cache-Control',
  TEXT_PLAIN: 'text/plain',
  TEXT_HTML: 'text/html',
  AUTHORIZATION: 'authorization',
  FORWARDED_PROTO: 'X-Forwarded-Proto',
  FRAMES_OPTIONS: 'X-Frame-Options',
  CSP: 'Content-Security-Policy',
  CTO: 'X-Content-Type-Options',
  XSS: 'X-XSS-Protection',
  ETAG: 'ETag',
  JSON_CHARSET: 'application/json; charset=utf-8',
  OCTET_STREAM: 'application/octet-stream; charset=utf-8',
  TEXT_CHARSET: 'text/plain; charset=utf-8',
  WWW_AUTH: 'WWW-Authenticate',
  GZIP: 'gzip'
};
exports.HEADERS = HEADERS;
const CHARACTER_ENCODING = {
  UTF8: 'utf8'
};
exports.CHARACTER_ENCODING = CHARACTER_ENCODING;
const HEADER_TYPE = {
  CONTENT_ENCODING: 'content-encoding',
  CONTENT_TYPE: 'content-type',
  CONTENT_LENGTH: 'content-length',
  ACCEPT_ENCODING: 'accept-encoding'
};
exports.HEADER_TYPE = HEADER_TYPE;
const ERROR_CODE = {
  token_required: 'token is required'
};
exports.ERROR_CODE = ERROR_CODE;
const TOKEN_BASIC = 'Basic';
exports.TOKEN_BASIC = TOKEN_BASIC;
const TOKEN_BEARER = 'Bearer';
exports.TOKEN_BEARER = TOKEN_BEARER;
const DEFAULT_REGISTRY = 'https://registry.npmjs.org';
exports.DEFAULT_REGISTRY = DEFAULT_REGISTRY;
const DEFAULT_UPLINK = 'npmjs';
exports.DEFAULT_UPLINK = DEFAULT_UPLINK;
const ROLES = {
  $ALL: '$all',
  ALL: 'all',
  $AUTH: '$authenticated',
  $ANONYMOUS: '$anonymous',
  DEPRECATED_ALL: '@all',
  DEPRECATED_AUTH: '@authenticated',
  DEPRECATED_ANONYMOUS: '@anonymous'
};
exports.ROLES = ROLES;
const HTTP_STATUS = {
  OK: 200,
  CREATED: 201,
  MULTIPLE_CHOICES: 300,
  REDIRECT: 302,
  NOT_MODIFIED: 304,
  BAD_REQUEST: 400,
  UNAUTHORIZED: 401,
  FORBIDDEN: 403,
  NOT_FOUND: 404,
  CONFLICT: 409,
  UNSUPPORTED_MEDIA: 415,
  BAD_DATA: 422,
  INTERNAL_ERROR: 500,
  NOT_IMPLEMENTED: 501,
  SERVICE_UNAVAILABLE: 503,
  LOOP_DETECTED: 508
};
exports.HTTP_STATUS = HTTP_STATUS;
const API_MESSAGE = {
  PKG_CREATED: 'created new package',
  PKG_CHANGED: 'package changed',
  PKG_REMOVED: 'package removed',
  PKG_PUBLISHED: 'package published',
  TARBALL_UPLOADED: 'tarball uploaded successfully',
  TARBALL_REMOVED: 'tarball removed',
  TAG_UPDATED: 'tags updated',
  TAG_REMOVED: 'tag removed',
  TAG_ADDED: 'package tagged',
  LOGGED_OUT: 'Logged out'
};
exports.API_MESSAGE = API_MESSAGE;
const SUPPORT_ERRORS = {
  PLUGIN_MISSING_INTERFACE: 'the plugin does not provide implementation of the requested feature',
  TFA_DISABLED: 'the two-factor authentication is not yet supported',
  STORAGE_NOT_IMPLEMENT: 'the storage does not support token saving',
  PARAMETERS_NOT_VALID: 'the parameters are not valid'
};
exports.SUPPORT_ERRORS = SUPPORT_ERRORS;
const API_ERROR = {
  PASSWORD_SHORT: (passLength = DEFAULT_MIN_LIMIT_PASSWORD) => `The provided password is too short. Please pick a password longer than ${passLength} characters.`,
  MUST_BE_LOGGED: 'You must be logged in to publish packages.',
  PLUGIN_ERROR: 'bug in the auth plugin system',
  CONFIG_BAD_FORMAT: 'config file must be an object',
  BAD_USERNAME_PASSWORD: 'bad username/password, access denied',
  NO_PACKAGE: 'no such package available',
  PACKAGE_CANNOT_BE_ADDED: 'this package cannot be added',
  BAD_DATA: 'bad data',
  NOT_ALLOWED: 'not allowed to access package',
  NOT_ALLOWED_PUBLISH: 'not allowed to publish package',
  INTERNAL_SERVER_ERROR: 'internal server error',
  UNKNOWN_ERROR: 'unknown error',
  NOT_PACKAGE_UPLINK: 'package does not exist on uplink',
  UPLINK_OFFLINE_PUBLISH: 'one of the uplinks is down, refuse to publish',
  UPLINK_OFFLINE: 'uplink is offline',
  CONTENT_MISMATCH: 'content length mismatch',
  NOT_FILE_UPLINK: "file doesn't exist on uplink",
  MAX_USERS_REACHED: 'maximum amount of users reached',
  VERSION_NOT_EXIST: "this version doesn't exist",
  FILE_NOT_FOUND: 'File not found',
  UNSUPORTED_REGISTRY_CALL: 'unsupported registry call',
  BAD_STATUS_CODE: 'bad status code',
  PACKAGE_EXIST: 'this package is already present',
  BAD_AUTH_HEADER: 'bad authorization header',
  WEB_DISABLED: 'Web interface is disabled in the config file',
  DEPRECATED_BASIC_HEADER: 'basic authentication is deprecated, please use JWT instead',
  BAD_FORMAT_USER_GROUP: 'user groups is different than an array',
  RESOURCE_UNAVAILABLE: 'resource unavailable',
  BAD_PACKAGE_DATA: 'bad incoming package data',
  USERNAME_PASSWORD_REQUIRED: 'username and password is required',
  USERNAME_ALREADY_REGISTERED: 'username is already registered'
};
exports.API_ERROR = API_ERROR;
const APP_ERROR = {
  CONFIG_NOT_VALID: 'CONFIG: it does not look like a valid config file',
  PROFILE_ERROR: 'profile unexpected error',
  PASSWORD_VALIDATION: 'not valid password'
};
exports.APP_ERROR = APP_ERROR;
const DEFAULT_NO_README = 'ERROR: No README data found!';
exports.DEFAULT_NO_README = DEFAULT_NO_README;
const MODULE_NOT_FOUND = 'MODULE_NOT_FOUND';
exports.MODULE_NOT_FOUND = MODULE_NOT_FOUND;
const WEB_TITLE = 'Verdaccio';
exports.WEB_TITLE = WEB_TITLE;
const PACKAGE_ACCESS = {
  SCOPE: '@*/*',
  ALL: '**'
};
exports.PACKAGE_ACCESS = PACKAGE_ACCESS;
const STORAGE = {
  PACKAGE_FILE_NAME: 'package.json',
  FILE_EXIST_ERROR: 'EEXISTS',
  NO_SUCH_FILE_ERROR: 'ENOENT',
  DEFAULT_REVISION: '0-0000000000000000'
};
exports.STORAGE = STORAGE;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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