"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfoCommand = void 0;

var _clipanion = require("clipanion");

var _envinfo = _interopRequireDefault(require("envinfo"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class InfoCommand extends _clipanion.Command {
  async execute() {
    this.context.stdout.write('\nEnvironment Info:');
    const data = await _envinfo.default.run({
      System: ['OS', 'CPU'],
      Binaries: ['node', 'yarn', 'npm', 'pnpm'],
      Virtualization: ['Docker'],
      Browsers: ['Chrome', 'Edge', 'Firefox', 'Safari'],
      npmGlobalPackages: ['verdaccio']
    });
    this.context.stdout.write(data);
    process.exit(0);
  }

}

exports.InfoCommand = InfoCommand;

_defineProperty(InfoCommand, "paths", [[`--info`], [`-i`]]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJJbmZvQ29tbWFuZCIsIkNvbW1hbmQiLCJleGVjdXRlIiwiY29udGV4dCIsInN0ZG91dCIsIndyaXRlIiwiZGF0YSIsImVudmluZm8iLCJydW4iLCJTeXN0ZW0iLCJCaW5hcmllcyIsIlZpcnR1YWxpemF0aW9uIiwiQnJvd3NlcnMiLCJucG1HbG9iYWxQYWNrYWdlcyIsInByb2Nlc3MiLCJleGl0Il0sInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL2xpYi9jbGkvY29tbWFuZHMvaW5mby50cyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21tYW5kIH0gZnJvbSAnY2xpcGFuaW9uJztcbmltcG9ydCBlbnZpbmZvIGZyb20gJ2VudmluZm8nO1xuXG5leHBvcnQgY2xhc3MgSW5mb0NvbW1hbmQgZXh0ZW5kcyBDb21tYW5kIHtcbiAgc3RhdGljIHBhdGhzID0gW1tgLS1pbmZvYF0sIFtgLWlgXV07XG5cbiAgYXN5bmMgZXhlY3V0ZSgpIHtcbiAgICB0aGlzLmNvbnRleHQuc3Rkb3V0LndyaXRlKCdcXG5FbnZpcm9ubWVudCBJbmZvOicpO1xuICAgIGNvbnN0IGRhdGEgPSBhd2FpdCBlbnZpbmZvLnJ1bih7XG4gICAgICBTeXN0ZW06IFsnT1MnLCAnQ1BVJ10sXG4gICAgICBCaW5hcmllczogWydub2RlJywgJ3lhcm4nLCAnbnBtJywgJ3BucG0nXSxcbiAgICAgIFZpcnR1YWxpemF0aW9uOiBbJ0RvY2tlciddLFxuICAgICAgQnJvd3NlcnM6IFsnQ2hyb21lJywgJ0VkZ2UnLCAnRmlyZWZveCcsICdTYWZhcmknXSxcbiAgICAgIG5wbUdsb2JhbFBhY2thZ2VzOiBbJ3ZlcmRhY2NpbyddLFxuICAgIH0pO1xuXG4gICAgdGhpcy5jb250ZXh0LnN0ZG91dC53cml0ZShkYXRhKTtcbiAgICBwcm9jZXNzLmV4aXQoMCk7XG4gIH1cbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOztBQUNBOzs7Ozs7QUFFTyxNQUFNQSxXQUFOLFNBQTBCQyxrQkFBMUIsQ0FBa0M7RUFHMUIsTUFBUEMsT0FBTyxHQUFHO0lBQ2QsS0FBS0MsT0FBTCxDQUFhQyxNQUFiLENBQW9CQyxLQUFwQixDQUEwQixxQkFBMUI7SUFDQSxNQUFNQyxJQUFJLEdBQUcsTUFBTUMsZ0JBQUEsQ0FBUUMsR0FBUixDQUFZO01BQzdCQyxNQUFNLEVBQUUsQ0FBQyxJQUFELEVBQU8sS0FBUCxDQURxQjtNQUU3QkMsUUFBUSxFQUFFLENBQUMsTUFBRCxFQUFTLE1BQVQsRUFBaUIsS0FBakIsRUFBd0IsTUFBeEIsQ0FGbUI7TUFHN0JDLGNBQWMsRUFBRSxDQUFDLFFBQUQsQ0FIYTtNQUk3QkMsUUFBUSxFQUFFLENBQUMsUUFBRCxFQUFXLE1BQVgsRUFBbUIsU0FBbkIsRUFBOEIsUUFBOUIsQ0FKbUI7TUFLN0JDLGlCQUFpQixFQUFFLENBQUMsV0FBRDtJQUxVLENBQVosQ0FBbkI7SUFRQSxLQUFLVixPQUFMLENBQWFDLE1BQWIsQ0FBb0JDLEtBQXBCLENBQTBCQyxJQUExQjtJQUNBUSxPQUFPLENBQUNDLElBQVIsQ0FBYSxDQUFiO0VBQ0Q7O0FBZnNDOzs7O2dCQUE1QmYsVyxXQUNJLENBQUMsQ0FBRSxRQUFGLENBQUQsRUFBYSxDQUFFLElBQUYsQ0FBYixDIn0=