#!/usr/bin/env node

/* eslint no-sync:0 */

/* eslint no-empty:0 */
"use strict";

if (process.getuid && process.getuid() === 0) {
  process.emitWarning(`Verdaccio doesn't need superuser privileges. don't run it under root`);
} // eslint-disable-next-line import/order


const logger = require('./logger');

logger.setup(null, {
  logStart: false
}); // default setup

require('./cli/cli');

process.on('uncaughtException', function (err) {
  logger.logger.fatal({
    err: err
  }, 'uncaught exception, please report this\n@{err.stack}');
  process.exit(255);
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJwcm9jZXNzIiwiZ2V0dWlkIiwiZW1pdFdhcm5pbmciLCJsb2dnZXIiLCJyZXF1aXJlIiwic2V0dXAiLCJsb2dTdGFydCIsIm9uIiwiZXJyIiwiZmF0YWwiLCJleGl0Il0sInNvdXJjZXMiOlsiLi4vLi4vc3JjL2xpYi9jbGkudHMiXSwic291cmNlc0NvbnRlbnQiOlsiIyEvdXNyL2Jpbi9lbnYgbm9kZVxuXG4vKiBlc2xpbnQgbm8tc3luYzowICovXG4vKiBlc2xpbnQgbm8tZW1wdHk6MCAqL1xuXG5pZiAocHJvY2Vzcy5nZXR1aWQgJiYgcHJvY2Vzcy5nZXR1aWQoKSA9PT0gMCkge1xuICBwcm9jZXNzLmVtaXRXYXJuaW5nKGBWZXJkYWNjaW8gZG9lc24ndCBuZWVkIHN1cGVydXNlciBwcml2aWxlZ2VzLiBkb24ndCBydW4gaXQgdW5kZXIgcm9vdGApO1xufVxuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgaW1wb3J0L29yZGVyXG5jb25zdCBsb2dnZXIgPSByZXF1aXJlKCcuL2xvZ2dlcicpO1xubG9nZ2VyLnNldHVwKG51bGwsIHsgbG9nU3RhcnQ6IGZhbHNlIH0pOyAvLyBkZWZhdWx0IHNldHVwXG5cbnJlcXVpcmUoJy4vY2xpL2NsaScpO1xuXG5wcm9jZXNzLm9uKCd1bmNhdWdodEV4Y2VwdGlvbicsIGZ1bmN0aW9uIChlcnIpIHtcbiAgbG9nZ2VyLmxvZ2dlci5mYXRhbChcbiAgICB7XG4gICAgICBlcnI6IGVycixcbiAgICB9LFxuICAgICd1bmNhdWdodCBleGNlcHRpb24sIHBsZWFzZSByZXBvcnQgdGhpc1xcbkB7ZXJyLnN0YWNrfSdcbiAgKTtcbiAgcHJvY2Vzcy5leGl0KDI1NSk7XG59KTtcbiJdLCJtYXBwaW5ncyI6IkFBQUE7O0FBRUE7O0FBQ0E7OztBQUVBLElBQUlBLE9BQU8sQ0FBQ0MsTUFBUixJQUFrQkQsT0FBTyxDQUFDQyxNQUFSLE9BQXFCLENBQTNDLEVBQThDO0VBQzVDRCxPQUFPLENBQUNFLFdBQVIsQ0FBcUIsc0VBQXJCO0FBQ0QsQyxDQUVEOzs7QUFDQSxNQUFNQyxNQUFNLEdBQUdDLE9BQU8sQ0FBQyxVQUFELENBQXRCOztBQUNBRCxNQUFNLENBQUNFLEtBQVAsQ0FBYSxJQUFiLEVBQW1CO0VBQUVDLFFBQVEsRUFBRTtBQUFaLENBQW5CLEUsQ0FBeUM7O0FBRXpDRixPQUFPLENBQUMsV0FBRCxDQUFQOztBQUVBSixPQUFPLENBQUNPLEVBQVIsQ0FBVyxtQkFBWCxFQUFnQyxVQUFVQyxHQUFWLEVBQWU7RUFDN0NMLE1BQU0sQ0FBQ0EsTUFBUCxDQUFjTSxLQUFkLENBQ0U7SUFDRUQsR0FBRyxFQUFFQTtFQURQLENBREYsRUFJRSxzREFKRjtFQU1BUixPQUFPLENBQUNVLElBQVIsQ0FBYSxHQUFiO0FBQ0QsQ0FSRCJ9