"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createServerFactory = createServerFactory;
exports.displayExperimentsInfoBox = displayExperimentsInfoBox;
exports.runServer = runServer;

var _constants = _interopRequireDefault(require("constants"));

var _debug = _interopRequireDefault(require("debug"));

var _fs = _interopRequireDefault(require("fs"));

var _http = _interopRequireDefault(require("http"));

var _https = _interopRequireDefault(require("https"));

var _lodash = _interopRequireWildcard(require("lodash"));

var _path = _interopRequireDefault(require("path"));

var _index = _interopRequireDefault(require("../api/index"));

var _utils = require("./cli/utils");

var _configPath = _interopRequireDefault(require("./config-path"));

var _constants2 = require("./constants");

var _utils2 = require("./utils");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const debug = (0, _debug.default)('verdaccio');

const logger = require('./logger');

function displayExperimentsInfoBox(flags) {
  if (!flags) {
    return;
  }

  const experimentList = Object.keys(flags);

  if (experimentList.length >= 1) {
    logger.warn( // eslint-disable-next-line max-len
    `experiments are enabled, it is recommended do not use experiments in production comment out this section to disable it`);
    experimentList.forEach(experiment => {
      // eslint-disable-next-line max-len
      logger.info(`support for experiment [${experiment}] ${flags[experiment] ? 'is enabled' : ' is disabled'}`);
    });
  }
}
/**
 * Exposes a server factory to be instantiated programmatically.
 *
    const app = await runServer(); // default configuration
    const app = await runServer('./config/config.yaml');
    const app = await runServer({ configuration });
    app.listen(4000, (event) => {
      // do something
    });
 * @param config
 */


async function runServer(config) {
  let configurationParsed;

  if (config === undefined || typeof config === 'string') {
    const configPathLocation = (0, _configPath.default)(config);
    configurationParsed = (0, _utils2.parseConfigFile)(configPathLocation);

    if (!configurationParsed.self_path) {
      configurationParsed.self_path = _path.default.resolve(configPathLocation);
    }
  } else if (_lodash.default.isObject(config)) {
    configurationParsed = config;

    if (!configurationParsed.self_path) {
      throw new Error('self_path is required, please provide a valid root path for storage');
    }
  } else {
    throw new Error(_constants2.API_ERROR.CONFIG_BAD_FORMAT);
  }

  const addresses = (0, _utils.getListListenAddresses)(undefined, configurationParsed.listen);

  if (addresses.length > 1) {
    process.emitWarning('You have specified multiple listen addresses, using this method only the first will be used');
  }

  const app = await (0, _index.default)(configurationParsed);
  return createServerFactory(configurationParsed, addresses[0], app);
}
/**
 * Return a native HTTP/HTTPS server instance
 * @param config
 * @param addr
 * @param app
 */


function createServerFactory(config, addr, app) {
  let serverFactory;

  if (addr.proto === 'https') {
    debug('https enabled');

    try {
      let httpsOptions = {
        // disable insecure SSLv2 and SSLv3
        secureOptions: _constants.default.SSL_OP_NO_SSLv2 | _constants.default.SSL_OP_NO_SSLv3
      };
      const keyCertConfig = config.https;
      const pfxConfig = config.https; // https must either have key and cert or a pfx and (optionally) a passphrase

      if (!(keyCertConfig.key && keyCertConfig.cert || pfxConfig.pfx)) {
        throw Error('bad format https configuration');
      }

      if (pfxConfig.pfx) {
        const {
          pfx,
          passphrase
        } = pfxConfig;
        httpsOptions = (0, _lodash.assign)(httpsOptions, {
          pfx: _fs.default.readFileSync(pfx),
          passphrase: passphrase || ''
        });
      } else {
        const {
          key,
          cert,
          ca
        } = keyCertConfig;
        httpsOptions = (0, _lodash.assign)(httpsOptions, _objectSpread({
          key: _fs.default.readFileSync(key),
          cert: _fs.default.readFileSync(cert)
        }, ca && {
          ca: _fs.default.readFileSync(ca)
        }));
      } // TODO: enable http2 as feature
      // if (config.server.http2) <-- check if force http2


      serverFactory = _https.default.createServer(httpsOptions, app);
    } catch (err) {
      throw new Error(`cannot create https server: ${err.message}`);
    }
  } else {
    // http
    debug('http enabled');
    serverFactory = _http.default.createServer(app);
  }

  if (config.server && typeof config.server.keepAliveTimeout !== 'undefined' && // @ts-ignore
  config.server.keepAliveTimeout !== 'null') {
    // library definition for node is not up to date (doesn't contain recent 8.0 changes)
    serverFactory.keepAliveTimeout = config.server.keepAliveTimeout * 1000;
  } // FIXE: I could not find the reason of this code.


  unlinkAddressPath(addr);
  return serverFactory;
}

function unlinkAddressPath(addr) {
  if (addr.path && _fs.default.existsSync(addr.path)) {
    _fs.default.unlinkSync(addr.path);
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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