"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderHTML;
exports.resolveLogo = resolveLogo;
exports.validatePrimaryColor = validatePrimaryColor;

var _debug = _interopRequireDefault(require("debug"));

var _lruCache = _interopRequireDefault(require("lru-cache"));

var _path = _interopRequireDefault(require("path"));

var _url = require("url");

var _commonsApi = require("@verdaccio/commons-api");

var _constants = require("../../../lib/constants");

var _utils = require("../../../lib/utils");

var _template = _interopRequireDefault(require("./template"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const pkgJSON = require('../../../../package.json');

const DEFAULT_LANGUAGE = 'es-US';
const cache = new _lruCache.default({
  max: 500,
  ttl: 1000 * 60 * 60
});
const debug = (0, _debug.default)('verdaccio');
const defaultManifestFiles = {
  js: ['runtime.js', 'vendors.js', 'main.js'],
  ico: 'favicon.ico'
};

function validatePrimaryColor(primaryColor) {
  const isHex = /^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$/i.test(primaryColor);

  if (!isHex) {
    debug('invalid primary color %o', primaryColor);
    return;
  }

  return primaryColor;
}

function resolveLogo(config, req) {
  var _config$web, _config$web2, _config$web4;

  const isLocalFile = (config === null || config === void 0 ? void 0 : (_config$web = config.web) === null || _config$web === void 0 ? void 0 : _config$web.logo) && !(0, _utils.isHTTPProtocol)(config === null || config === void 0 ? void 0 : (_config$web2 = config.web) === null || _config$web2 === void 0 ? void 0 : _config$web2.logo);

  if (isLocalFile) {
    var _config$web3;

    return `${(0, _utils.getPublicUrl)(config === null || config === void 0 ? void 0 : config.url_prefix, req)}-/static/${_path.default.basename(config === null || config === void 0 ? void 0 : (_config$web3 = config.web) === null || _config$web3 === void 0 ? void 0 : _config$web3.logo)}`;
  } else if ((0, _utils.isHTTPProtocol)(config === null || config === void 0 ? void 0 : (_config$web4 = config.web) === null || _config$web4 === void 0 ? void 0 : _config$web4.logo)) {
    var _config$web5;

    return config === null || config === void 0 ? void 0 : (_config$web5 = config.web) === null || _config$web5 === void 0 ? void 0 : _config$web5.logo;
  } else {
    return '';
  }
}

function renderHTML(config, manifest, manifestFiles, req, res) {
  var _config$i18n$web, _config$i18n, _config$web6, _config$web$darkMode, _config$web7, _config$web$title, _config$web8, _config$web$scope, _config$web9, _config$web$pkgManage, _config$web10, _validatePrimaryColor, _config$web11;

  const {
    url_prefix
  } = config;
  const base = (0, _utils.getPublicUrl)(config === null || config === void 0 ? void 0 : config.url_prefix, req);
  const basename = new _url.URL(base).pathname;
  const language = (_config$i18n$web = config === null || config === void 0 ? void 0 : (_config$i18n = config.i18n) === null || _config$i18n === void 0 ? void 0 : _config$i18n.web) !== null && _config$i18n$web !== void 0 ? _config$i18n$web : DEFAULT_LANGUAGE;
  const needHtmlCache = [undefined, null].includes(config === null || config === void 0 ? void 0 : (_config$web6 = config.web) === null || _config$web6 === void 0 ? void 0 : _config$web6.html_cache) ? true : config.web.html_cache;
  const darkMode = (_config$web$darkMode = config === null || config === void 0 ? void 0 : (_config$web7 = config.web) === null || _config$web7 === void 0 ? void 0 : _config$web7.darkMode) !== null && _config$web$darkMode !== void 0 ? _config$web$darkMode : false;
  const title = (_config$web$title = config === null || config === void 0 ? void 0 : (_config$web8 = config.web) === null || _config$web8 === void 0 ? void 0 : _config$web8.title) !== null && _config$web$title !== void 0 ? _config$web$title : _constants.WEB_TITLE;
  const scope = (_config$web$scope = config === null || config === void 0 ? void 0 : (_config$web9 = config.web) === null || _config$web9 === void 0 ? void 0 : _config$web9.scope) !== null && _config$web$scope !== void 0 ? _config$web$scope : '';
  const login = (0, _utils.hasLogin)(config);
  const logoURI = resolveLogo(config, req);
  const pkgManagers = (_config$web$pkgManage = config === null || config === void 0 ? void 0 : (_config$web10 = config.web) === null || _config$web10 === void 0 ? void 0 : _config$web10.pkgManagers) !== null && _config$web$pkgManage !== void 0 ? _config$web$pkgManage : ['yarn', 'pnpm', 'npm'];
  const version = pkgJSON.version;
  const primaryColor = (_validatePrimaryColor = validatePrimaryColor(config === null || config === void 0 ? void 0 : (_config$web11 = config.web) === null || _config$web11 === void 0 ? void 0 : _config$web11.primary_color)) !== null && _validatePrimaryColor !== void 0 ? _validatePrimaryColor : '#4b5e40';
  const {
    scriptsBodyAfter,
    metaScripts,
    scriptsbodyBefore,
    showInfo,
    showSettings,
    showThemeSwitch,
    showFooter,
    showSearch,
    showDownloadTarball
  } = Object.assign({}, {
    scriptsBodyAfter: [],
    bodyBefore: [],
    metaScripts: []
  }, config === null || config === void 0 ? void 0 : config.web);
  const options = {
    showInfo,
    showSettings,
    showThemeSwitch,
    showFooter,
    showSearch,
    showDownloadTarball,
    darkMode,
    url_prefix,
    basename,
    base,
    primaryColor,
    version,
    pkgManagers,
    login,
    logo: logoURI,
    title,
    scope,
    language
  };
  let webPage;

  try {
    webPage = cache.get('template');

    if (!webPage) {
      debug('web options %o', options);
      debug('web manifestFiles %o', manifestFiles);
      webPage = (0, _template.default)({
        manifest: manifestFiles !== null && manifestFiles !== void 0 ? manifestFiles : defaultManifestFiles,
        options,
        scriptsBodyAfter,
        metaScripts,
        scriptsbodyBefore
      }, manifest);
      debug('template :: %o', webPage);

      if (needHtmlCache) {
        cache.set('template', webPage);
        debug('set template cache');
      }
    } else {
      debug('reuse template cache');
    }
  } catch (error) {
    throw new Error(`theme could not be load, stack ${error.stack}`);
  }

  res.setHeader('Content-Type', _commonsApi.HEADERS.TEXT_HTML);
  res.send(webPage);
  debug('render web');
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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