"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _bodyParser = _interopRequireDefault(require("body-parser"));

var _express = _interopRequireDefault(require("express"));

var _distTags = _interopRequireDefault(require("./api/dist-tags"));

var _package = _interopRequireDefault(require("./api/package"));

var _ping = _interopRequireDefault(require("./api/ping"));

var _publish = _interopRequireDefault(require("./api/publish"));

var _search = _interopRequireDefault(require("./api/search"));

var _stars = _interopRequireDefault(require("./api/stars"));

var _user = _interopRequireDefault(require("./api/user"));

var _v = _interopRequireDefault(require("./api/v1"));

var _search2 = _interopRequireDefault(require("./api/v1/search"));

var _whoami = _interopRequireDefault(require("./api/whoami"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const {
  match,
  validateName,
  validatePackage,
  encodeScopePackage,
  antiLoop
} = require('../middleware');

function _default(config, auth, storage) {
  /* eslint new-cap:off */
  const app = _express.default.Router();
  /* eslint new-cap:off */
  // validate all of these params as a package name
  // this might be too harsh, so ask if it causes trouble


  app.param('package', validatePackage);
  app.param('filename', validateName);
  app.param('tag', validateName);
  app.param('version', validateName);
  app.param('revision', validateName);
  app.param('token', validateName); // these can't be safely put into express url for some reason
  // TODO: For some reason? what reason?

  app.param('_rev', match(/^-rev$/));
  app.param('org_couchdb_user', match(/^org\.couchdb\.user:/));
  app.param('anything', match(/.*/));
  app.use(auth.apiJWTmiddleware());
  app.use(_bodyParser.default.json({
    strict: false,
    limit: config.max_body_size || '10mb'
  }));
  app.use(antiLoop(config)); // encode / in a scoped package name to be matched as a single parameter in routes

  app.use(encodeScopePackage); // for "npm whoami"

  (0, _whoami.default)(app);
  (0, _package.default)(app, auth, storage, config);
  (0, _search.default)(app, auth, storage);
  (0, _distTags.default)(app, auth, storage);
  (0, _publish.default)(app, auth, storage, config);
  (0, _ping.default)(app);
  (0, _stars.default)(app, storage);
  (0, _search2.default)(app, auth, storage);
  (0, _user.default)(app, auth, config);
  app.use((0, _v.default)(auth, storage, config));
  return app;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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