"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _express = require("express");

var _lodash = _interopRequireDefault(require("lodash"));

var _authUtils = require("../../../../lib/auth-utils");

var _constants = require("../../../../lib/constants");

var _utils = require("../../../../lib/utils");

var _rateLimiter = require("../../../rate-limiter");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _default(auth, config) {
  const profileRoute = (0, _express.Router)();
  /* eslint new-cap: 0 */

  function buildProfile(name) {
    return {
      tfa: false,
      name,
      email: '',
      email_verified: false,
      created: '',
      updated: '',
      cidr_whitelist: null,
      fullname: ''
    };
  }

  profileRoute.get('/user', (0, _rateLimiter.limiter)(config === null || config === void 0 ? void 0 : config.userRateLimit), function (req, res, next) {
    if (_lodash.default.isNil(req.remote_user.name) === false) {
      return next(buildProfile(req.remote_user.name));
    }

    res.status(_constants.HTTP_STATUS.UNAUTHORIZED);
    return next({
      message: _constants.API_ERROR.MUST_BE_LOGGED
    });
  });
  profileRoute.post('/user', (0, _rateLimiter.limiter)(config === null || config === void 0 ? void 0 : config.userRateLimit), function (req, res, next) {
    if (_lodash.default.isNil(req.remote_user.name)) {
      res.status(_constants.HTTP_STATUS.UNAUTHORIZED);
      return next({
        message: _constants.API_ERROR.MUST_BE_LOGGED
      });
    }

    const {
      password,
      tfa
    } = req.body;
    const {
      name
    } = req.remote_user;

    if (_lodash.default.isNil(password) === false) {
      if ((0, _authUtils.validatePassword)(password.new) === false) {
        /* eslint new-cap:off */
        return next(_utils.ErrorCode.getCode(_constants.HTTP_STATUS.UNAUTHORIZED, _constants.API_ERROR.PASSWORD_SHORT()));
        /* eslint new-cap:off */
      }

      auth.changePassword(name, password.old, password.new, (err, isUpdated) => {
        if (_lodash.default.isNull(err) === false) {
          return next(_utils.ErrorCode.getCode(err.status, err.message) || _utils.ErrorCode.getConflict(err.message));
        }

        if (isUpdated) {
          return next(buildProfile(req.remote_user.name));
        }

        return next(_utils.ErrorCode.getInternalError(_constants.API_ERROR.INTERNAL_SERVER_ERROR));
      });
    } else if (_lodash.default.isNil(tfa) === false) {
      return next(_utils.ErrorCode.getCode(_constants.HTTP_STATUS.SERVICE_UNAVAILABLE, _constants.SUPPORT_ERRORS.TFA_DISABLED));
    } else {
      return next(_utils.ErrorCode.getCode(_constants.HTTP_STATUS.INTERNAL_ERROR, _constants.APP_ERROR.PROFILE_ERROR));
    }
  });
  return profileRoute;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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