"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _cookies = _interopRequireDefault(require("cookies"));

var _express = _interopRequireDefault(require("express"));

var _lodash = _interopRequireDefault(require("lodash"));

var _authUtils = require("../../../lib/auth-utils");

var _constants = require("../../../lib/constants");

var _logger = require("../../../lib/logger");

var _utils = require("../../../lib/utils");

var _rateLimiter = require("../../rate-limiter");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _default(route, auth, config) {
  /* eslint new-cap:off */
  const userRouter = _express.default.Router();

  userRouter.get('/-/user/:org_couchdb_user', (0, _rateLimiter.limiter)(config === null || config === void 0 ? void 0 : config.userRateLimit), function (req, res, next) {
    res.status(_constants.HTTP_STATUS.OK);
    next({
      ok: (0, _authUtils.getAuthenticatedMessage)(req.remote_user.name)
    });
  });
  userRouter.put('/-/user/:org_couchdb_user/:_rev?/:revision?', (0, _rateLimiter.limiter)(config === null || config === void 0 ? void 0 : config.userRateLimit), function (req, res, next) {
    const {
      name,
      password
    } = req.body;
    const remoteName = req.remote_user.name;

    if (_lodash.default.isNil(remoteName) === false && _lodash.default.isNil(name) === false && remoteName === name) {
      auth.authenticate(name, password, async function callbackAuthenticate(err, user) {
        if (err) {
          _logger.logger.error({
            name,
            err
          }, 'authenticating for user @{username} failed. Error: @{err.message}');

          return next(_utils.ErrorCode.getCode(_constants.HTTP_STATUS.UNAUTHORIZED, _constants.API_ERROR.BAD_USERNAME_PASSWORD));
        }

        const restoredRemoteUser = (0, _authUtils.createRemoteUser)(name, user.groups || []);
        const token = await (0, _authUtils.getApiToken)(auth, config, restoredRemoteUser, password);
        res.status(_constants.HTTP_STATUS.CREATED);
        res.set(_constants.HEADERS.CACHE_CONTROL, 'no-cache, no-store');
        return next({
          ok: (0, _authUtils.getAuthenticatedMessage)(req.remote_user.name),
          token
        });
      });
    } else {
      if ((0, _authUtils.validatePassword)(password) === false) {
        // eslint-disable-next-line new-cap
        return next(_utils.ErrorCode.getCode(_constants.HTTP_STATUS.BAD_REQUEST, _constants.API_ERROR.PASSWORD_SHORT()));
      }

      auth.add_user(name, password, async function (err, user) {
        if (err) {
          if (err.status >= _constants.HTTP_STATUS.BAD_REQUEST && err.status < _constants.HTTP_STATUS.INTERNAL_ERROR) {
            // With npm registering is the same as logging in,
            // and npm accepts only an 409 error.
            // So, changing status code here.
            return next(_utils.ErrorCode.getCode(err.status, err.message) || _utils.ErrorCode.getConflict(err.message));
          }

          return next(err);
        }

        const token = name && password ? await (0, _authUtils.getApiToken)(auth, config, user, password) : undefined;
        req.remote_user = user;
        res.status(_constants.HTTP_STATUS.CREATED);
        res.set(_constants.HEADERS.CACHE_CONTROL, 'no-cache, no-store');
        return next({
          ok: `user '${req.body.name}' created`,
          token
        });
      });
    }
  });
  userRouter.delete('/-/user/token/*', (0, _rateLimiter.limiter)(config === null || config === void 0 ? void 0 : config.userRateLimit), function (req, res, next) {
    res.status(_constants.HTTP_STATUS.OK);
    next({
      ok: _constants.API_MESSAGE.LOGGED_OUT
    });
  }); // placeholder 'cause npm require to be authenticated to publish
  // we do not do any real authentication yet

  userRouter.post('/_session', _cookies.default.express(), function (req, res, next) {
    res.cookies.set('AuthSession', String(Math.random()), (0, _authUtils.createSessionToken)());
    next({
      ok: true,
      name: 'somebody',
      roles: []
    });
  });
  route.use(userRouter);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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