"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _lodash = _interopRequireDefault(require("lodash"));

var _constants = require("../../../lib/constants");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _default(route, storage) {
  route.get('/-/_view/starredByUser', (req, res, next) => {
    const remoteUsername = req.remote_user.name;
    storage.getLocalDatabase((err, localPackages) => {
      if (err) {
        return next(err);
      }

      const filteredPackages = localPackages.filter(localPackage => _lodash.default.keys(localPackage[_constants.USERS]).includes(remoteUsername));
      res.status(_constants.HTTP_STATUS.OK);
      next({
        rows: filteredPackages.map(filteredPackage => ({
          value: filteredPackage.name
        }))
      });
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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