"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _debug = _interopRequireDefault(require("debug"));

var _lodash = _interopRequireDefault(require("lodash"));

var _constants = require("../../../lib/constants");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const debug = (0, _debug.default)('verdaccio:star');

function _default(storage) {
  const validateInputs = (newUsers, localUsers, username, isStar) => {
    const isExistlocalUsers = _lodash.default.isNil(localUsers[username]) === false;

    if (isStar && isExistlocalUsers && localUsers[username]) {
      return true;
    } else if (!isStar && isExistlocalUsers) {
      return false;
    } else if (!isStar && !isExistlocalUsers) {
      return true;
    }

    return false;
  };

  return (req, res, next) => {
    const name = req.params.package;
    debug('starring a package for %o', name);

    const afterChangePackage = function (err) {
      if (err) {
        return next(err);
      }

      res.status(_constants.HTTP_STATUS.OK);
      next({
        success: true
      });
    };

    storage.getPackage({
      name,
      req,
      callback: function (err, info) {
        if (err) {
          return next(err);
        }

        const newStarUser = req.body[_constants.USERS];
        const remoteUsername = req.remote_user.name;
        const localStarUsers = info[_constants.USERS]; // Check is star or unstar

        const isStar = Object.keys(newStarUser).includes(remoteUsername);

        if (_lodash.default.isNil(localStarUsers) === false && validateInputs(newStarUser, localStarUsers, remoteUsername, isStar)) {
          return afterChangePackage();
        }

        const users = isStar ? _objectSpread(_objectSpread({}, localStarUsers), {}, {
          [remoteUsername]: true
        }) : _lodash.default.reduce(localStarUsers, (users, value, key) => {
          if (key !== remoteUsername) {
            users[key] = value;
          }

          return users;
        }, {});
        storage.changePackage(name, _objectSpread(_objectSpread({}, info), {}, {
          users
        }), req.body._rev, function (err) {
          afterChangePackage(err);
        });
      }
    });
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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