"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = (app, selfPath) => {
  // Hook for tests only
  app.get('/-/_debug', function (req, res, next) {
    const doGarbabeCollector = _lodash.default.isNil(global.gc) === false;

    if (doGarbabeCollector) {
      global.gc();
    }

    next({
      pid: process.pid,
      // @ts-ignore
      main: process.mainModule.filename,
      conf: selfPath,
      mem: process.memoryUsage(),
      gc: doGarbabeCollector
    });
  });
};

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJhcHAiLCJzZWxmUGF0aCIsImdldCIsInJlcSIsInJlcyIsIm5leHQiLCJkb0dhcmJhYmVDb2xsZWN0b3IiLCJfIiwiaXNOaWwiLCJnbG9iYWwiLCJnYyIsInBpZCIsInByb2Nlc3MiLCJtYWluIiwibWFpbk1vZHVsZSIsImZpbGVuYW1lIiwiY29uZiIsIm1lbSIsIm1lbW9yeVVzYWdlIl0sInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2FwaS9kZWJ1Zy9pbmRleC50cyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBcHBsaWNhdGlvbiB9IGZyb20gJ2V4cHJlc3MnO1xuaW1wb3J0IF8gZnJvbSAnbG9kYXNoJztcblxuaW1wb3J0IHsgJE5leHRGdW5jdGlvblZlciwgJFJlcXVlc3RFeHRlbmQsICRSZXNwb25zZUV4dGVuZCB9IGZyb20gJy4uLy4uLy4uL3R5cGVzJztcblxuZXhwb3J0IGRlZmF1bHQgKGFwcDogQXBwbGljYXRpb24sIHNlbGZQYXRoOiBzdHJpbmcpOiB2b2lkID0+IHtcbiAgLy8gSG9vayBmb3IgdGVzdHMgb25seVxuICBhcHAuZ2V0KCcvLS9fZGVidWcnLCBmdW5jdGlvbiAocmVxOiAkUmVxdWVzdEV4dGVuZCwgcmVzOiAkUmVzcG9uc2VFeHRlbmQsIG5leHQ6ICROZXh0RnVuY3Rpb25WZXIpOiB2b2lkIHtcbiAgICBjb25zdCBkb0dhcmJhYmVDb2xsZWN0b3IgPSBfLmlzTmlsKGdsb2JhbC5nYykgPT09IGZhbHNlO1xuXG4gICAgaWYgKGRvR2FyYmFiZUNvbGxlY3Rvcikge1xuICAgICAgZ2xvYmFsLmdjKCk7XG4gICAgfVxuXG4gICAgbmV4dCh7XG4gICAgICBwaWQ6IHByb2Nlc3MucGlkLFxuICAgICAgLy8gQHRzLWlnbm9yZVxuICAgICAgbWFpbjogcHJvY2Vzcy5tYWluTW9kdWxlLmZpbGVuYW1lLFxuICAgICAgY29uZjogc2VsZlBhdGgsXG4gICAgICBtZW06IHByb2Nlc3MubWVtb3J5VXNhZ2UoKSxcbiAgICAgIGdjOiBkb0dhcmJhYmVDb2xsZWN0b3IsXG4gICAgfSk7XG4gIH0pO1xufTtcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUNBOzs7O2VBSWUsQ0FBQ0EsR0FBRCxFQUFtQkMsUUFBbkIsS0FBOEM7RUFDM0Q7RUFDQUQsR0FBRyxDQUFDRSxHQUFKLENBQVEsV0FBUixFQUFxQixVQUFVQyxHQUFWLEVBQStCQyxHQUEvQixFQUFxREMsSUFBckQsRUFBbUY7SUFDdEcsTUFBTUMsa0JBQWtCLEdBQUdDLGVBQUEsQ0FBRUMsS0FBRixDQUFRQyxNQUFNLENBQUNDLEVBQWYsTUFBdUIsS0FBbEQ7O0lBRUEsSUFBSUosa0JBQUosRUFBd0I7TUFDdEJHLE1BQU0sQ0FBQ0MsRUFBUDtJQUNEOztJQUVETCxJQUFJLENBQUM7TUFDSE0sR0FBRyxFQUFFQyxPQUFPLENBQUNELEdBRFY7TUFFSDtNQUNBRSxJQUFJLEVBQUVELE9BQU8sQ0FBQ0UsVUFBUixDQUFtQkMsUUFIdEI7TUFJSEMsSUFBSSxFQUFFZixRQUpIO01BS0hnQixHQUFHLEVBQUVMLE9BQU8sQ0FBQ00sV0FBUixFQUxGO01BTUhSLEVBQUUsRUFBRUo7SUFORCxDQUFELENBQUo7RUFRRCxDQWZEO0FBZ0JELEMifQ==