import { HttpError } from 'http-errors';
export declare const DEFAULT_MIN_LIMIT_PASSWORD = 3;
export declare const HTTP_STATUS: {
    OK: number;
    CREATED: number;
    MULTIPLE_CHOICES: number;
    NOT_MODIFIED: number;
    BAD_REQUEST: number;
    UNAUTHORIZED: number;
    FORBIDDEN: number;
    NOT_FOUND: number;
    CONFLICT: number;
    UNSUPPORTED_MEDIA: number;
    BAD_DATA: number;
    INTERNAL_ERROR: number;
    SERVICE_UNAVAILABLE: number;
    LOOP_DETECTED: number;
};
export declare const HEADERS: {
    ACCEPT: string;
    ACCEPT_ENCODING: string;
    USER_AGENT: string;
    JSON: string;
    CONTENT_TYPE: string;
    CONTENT_LENGTH: string;
    TEXT_PLAIN: string;
    TEXT_HTML: string;
    AUTHORIZATION: string;
    FORWARDED_PROTO: string;
    FRAMES_OPTIONS: string;
    CSP: string;
    CTO: string;
    XSS: string;
    ETAG: string;
    JSON_CHARSET: string;
    OCTET_STREAM: string;
    TEXT_CHARSET: string;
    WWW_AUTH: string;
    GZIP: string;
};
export declare const API_MESSAGE: {
    PKG_CREATED: string;
    PKG_CHANGED: string;
    PKG_REMOVED: string;
    PKG_PUBLISHED: string;
    TARBALL_UPLOADED: string;
    TARBALL_REMOVED: string;
    TAG_UPDATED: string;
    TAG_REMOVED: string;
    TAG_ADDED: string;
    LOGGED_OUT: string;
};
export declare const API_ERROR: {
    PASSWORD_SHORT: (passLength?: number) => string;
    MUST_BE_LOGGED: string;
    PLUGIN_ERROR: string;
    CONFIG_BAD_FORMAT: string;
    BAD_USERNAME_PASSWORD: string;
    NO_PACKAGE: string;
    PACKAGE_CANNOT_BE_ADDED: string;
    BAD_DATA: string;
    NOT_ALLOWED: string;
    NOT_ALLOWED_PUBLISH: string;
    INTERNAL_SERVER_ERROR: string;
    UNKNOWN_ERROR: string;
    NOT_PACKAGE_UPLINK: string;
    UPLINK_OFFLINE_PUBLISH: string;
    UPLINK_OFFLINE: string;
    CONTENT_MISMATCH: string;
    NOT_FILE_UPLINK: string;
    MAX_USERS_REACHED: string;
    VERSION_NOT_EXIST: string;
    FILE_NOT_FOUND: string;
    BAD_STATUS_CODE: string;
    PACKAGE_EXIST: string;
    BAD_AUTH_HEADER: string;
    WEB_DISABLED: string;
    DEPRECATED_BASIC_HEADER: string;
    BAD_FORMAT_USER_GROUP: string;
    RESOURCE_UNAVAILABLE: string;
    BAD_PACKAGE_DATA: string;
    USERNAME_PASSWORD_REQUIRED: string;
    USERNAME_ALREADY_REGISTERED: string;
};
export declare type VerdaccioError = HttpError & {
    code: number;
};
export declare function getConflict(message?: string): VerdaccioError;
export declare function getBadData(customMessage?: string): VerdaccioError;
export declare function getBadRequest(customMessage: string): VerdaccioError;
export declare function getInternalError(customMessage?: string): VerdaccioError;
export declare function getUnauthorized(message?: string): VerdaccioError;
export declare function getForbidden(message?: string): VerdaccioError;
export declare function getServiceUnavailable(message?: string): VerdaccioError;
export declare function getNotFound(customMessage?: string): VerdaccioError;
export declare function getCode(statusCode: number, customMessage: string): VerdaccioError;
