/// <reference types="node" />
import childProcess from 'child_process';
import { DepGraph } from 'dependency-graph';
import { JSONObject } from '@lumino/coreutils';
declare type Dict<T> = {
    [key: string]: T;
};
/**
 *  Exit with an error code on uncaught error.
 */
export declare function exitOnUuncaughtException(): void;
/**
 * Get all of the lerna package paths.
 */
export declare function getLernaPaths(basePath?: string): string[];
/**
 * Get all of the core package paths.
 */
export declare function getCorePaths(): string[];
/**
 * Write a package.json if necessary.
 *
 * @param data - The package data.
 *
 * @oaram pkgJsonPath - The path to the package.json file.
 *
 * @returns Whether the file has changed.
 */
export declare function writePackageData(pkgJsonPath: string, data: JSONObject): boolean;
/**
 * Read a json file.
 */
export declare function readJSONFile(filePath: string): any;
/**
 * Write a json file.
 */
export declare function writeJSONFile(filePath: string, data: JSONObject): boolean;
/**
 * Simple template substitution for template vars of the form {{name}}
 *
 * @param templ: the template string.
 * Ex: `This header generated by {{funcName}}`
 *
 * @param subs: an object in which the parameter keys are the template
 * variables and the parameter values are the substitutions.
 *
 * @param options: function options.
 *
 * @param options.autoindent: default = true. If true, will try to match
 * indentation level of {{var}} in substituted template.
 *
 * @param options.end: default = '\n'. Inserted at the end of
 * a template post-substitution and post-trim.
 *
 * @returns the input template with all {{vars}} substituted, then `.trim`-ed.
 */
export declare function fromTemplate(templ: string, subs: Dict<string>, options?: {
    autoindent?: boolean;
    end?: string;
}): string;
/**
 *
 * Call a command, checking its status.
 */
export declare function checkStatus(cmd: string): number | null;
/**
 * Get the current version of JupyterLab
 */
export declare function getPythonVersion(): string;
/**
 * Get the current version of a package
 */
export declare function getJSVersion(pkg: string): string;
/**
 * Pre-bump.
 */
export declare function prebump(): void;
/**
 * Post-bump.
 */
export declare function postbump(commit?: boolean): void;
/**
 * Run a command with terminal output.
 *
 * @param cmd - The command to run.
 */
export declare function run(cmd: string, options?: childProcess.ExecSyncOptions, quiet?: boolean): string;
/**
 * Get a graph that has all of the package data for the local packages and their
 * first order dependencies.
 */
export declare function getPackageGraph(): DepGraph<Dict<unknown>>;
/**
 * Ensure the given path uses '/' as path separator.
 */
export declare function ensureUnixPathSep(source: string): string;
/**
 * Get the last portion of a path, without its extension (if any).
 *
 * @param pathArg - The file path.
 *
 * @returns the last part of the path, sans extension.
 */
export declare function stem(pathArg: string): string;
/**
 * Given a 'snake-case', 'snake_case', or 'snake case' string,
 * will return the camel case version: 'snakeCase'.
 *
 * @param str: the snake-case input string.
 *
 * @param upper: default = false. If true, the first letter of the
 * returned string will be capitalized.
 *
 * @returns the camel case version of the input string.
 */
export declare function camelCase(str: string, upper?: boolean): string;
export {};
