# Welcome to CrewPlus

**CrewPlus** provides the foundational services and core components for building advanced AI applications. It is the heart of the CrewPlus ecosystem, designed for scalability, extensibility, and seamless integration.

## Overview

This repository, `crewplus-base`, contains the core `crewplus` Python package. It includes essential building blocks for interacting with large language models, managing vector databases, and handling application configuration. Whether you are building a simple chatbot or a complex multi-agent system, CrewPlus offers the robust foundation you need.

## The CrewPlus Ecosystem

CrewPlus is designed as a modular and extensible ecosystem of packages. This allows you to adopt only the components you need for your specific use case.

-   **`crewplus` (This package):** The core package containing foundational services for chat, model load balancing, and vector stores.
-   **`crewplus-agents`:** An extension for creating and managing autonomous AI agents.
-   **`crewplus-ingestion`:** Provides robust pipelines for knowledge ingestion and data processing.
-   **`crewplus-integrations`:** A collection of third-party integrations to connect CrewPlus with other services and platforms.

## Getting Started

To get started, check out our detailed user guides:

-   **[GeminiChatModel Guide](./GeminiChatModel.md)**: A comprehensive guide to using the `GeminiChatModel` for text, image, and video understanding.
-   **[ModelLoadBalancer Guide](./ModelLoadBalancer.md)**: A guide to using the `ModelLoadBalancer` for managing and accessing different language models.
