# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev2
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from synctera_client import schemas  # noqa: F401


class Bin(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """


    class MetaOapg:
        required = {
            "country",
            "ica_bid",
            "billing_ica",
            "bin",
            "card_category",
            "brand_product_code",
            "pan_utilization",
            "processor",
            "account_range_length",
            "partner_id",
            "bank_id",
            "card_brand",
            "currency",
            "card_product_type",
        }
        
        class properties:
            account_range_length = schemas.IntSchema
            bank_id = schemas.IntSchema
            billing_ica = schemas.StrSchema
            bin = schemas.StrSchema
        
            @staticmethod
            def brand_product_code() -> typing.Type['BrandProductCode']:
                return BrandProductCode
        
            @staticmethod
            def card_brand() -> typing.Type['CardBrand']:
                return CardBrand
        
            @staticmethod
            def card_category() -> typing.Type['CardCategory']:
                return CardCategory
        
            @staticmethod
            def card_product_type() -> typing.Type['CardProductType']:
                return CardProductType
        
            @staticmethod
            def country() -> typing.Type['CountryCode']:
                return CountryCode
        
            @staticmethod
            def currency() -> typing.Type['CurrencyCode']:
                return CurrencyCode
            ica_bid = schemas.StrSchema
            pan_utilization = schemas.IntSchema
            partner_id = schemas.IntSchema
            processor = schemas.StrSchema
        
            @staticmethod
            def bin_status() -> typing.Type['BinStatus']:
                return BinStatus
            creation_time = schemas.DateTimeSchema
            digital_wallet_active = schemas.BoolSchema
            end_date = schemas.DateTimeSchema
            id = schemas.UUIDSchema
            is_tokenization_enabled = schemas.BoolSchema
            last_modified_time = schemas.DateTimeSchema
        
            @staticmethod
            def physical_card_format() -> typing.Type['PhysicalCardFormat']:
                return PhysicalCardFormat
            start_date = schemas.DateTimeSchema
            __annotations__ = {
                "account_range_length": account_range_length,
                "bank_id": bank_id,
                "billing_ica": billing_ica,
                "bin": bin,
                "brand_product_code": brand_product_code,
                "card_brand": card_brand,
                "card_category": card_category,
                "card_product_type": card_product_type,
                "country": country,
                "currency": currency,
                "ica_bid": ica_bid,
                "pan_utilization": pan_utilization,
                "partner_id": partner_id,
                "processor": processor,
                "bin_status": bin_status,
                "creation_time": creation_time,
                "digital_wallet_active": digital_wallet_active,
                "end_date": end_date,
                "id": id,
                "is_tokenization_enabled": is_tokenization_enabled,
                "last_modified_time": last_modified_time,
                "physical_card_format": physical_card_format,
                "start_date": start_date,
            }
    
    country: 'CountryCode'
    ica_bid: MetaOapg.properties.ica_bid
    billing_ica: MetaOapg.properties.billing_ica
    bin: MetaOapg.properties.bin
    card_category: 'CardCategory'
    brand_product_code: 'BrandProductCode'
    pan_utilization: MetaOapg.properties.pan_utilization
    processor: MetaOapg.properties.processor
    account_range_length: MetaOapg.properties.account_range_length
    partner_id: MetaOapg.properties.partner_id
    bank_id: MetaOapg.properties.bank_id
    card_brand: 'CardBrand'
    currency: 'CurrencyCode'
    card_product_type: 'CardProductType'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["account_range_length"]) -> MetaOapg.properties.account_range_length: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["bank_id"]) -> MetaOapg.properties.bank_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["billing_ica"]) -> MetaOapg.properties.billing_ica: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["bin"]) -> MetaOapg.properties.bin: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["brand_product_code"]) -> 'BrandProductCode': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["card_brand"]) -> 'CardBrand': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["card_category"]) -> 'CardCategory': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["card_product_type"]) -> 'CardProductType': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["country"]) -> 'CountryCode': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["currency"]) -> 'CurrencyCode': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["ica_bid"]) -> MetaOapg.properties.ica_bid: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["pan_utilization"]) -> MetaOapg.properties.pan_utilization: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["partner_id"]) -> MetaOapg.properties.partner_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["processor"]) -> MetaOapg.properties.processor: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["bin_status"]) -> 'BinStatus': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["creation_time"]) -> MetaOapg.properties.creation_time: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["digital_wallet_active"]) -> MetaOapg.properties.digital_wallet_active: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["end_date"]) -> MetaOapg.properties.end_date: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["is_tokenization_enabled"]) -> MetaOapg.properties.is_tokenization_enabled: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["last_modified_time"]) -> MetaOapg.properties.last_modified_time: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["physical_card_format"]) -> 'PhysicalCardFormat': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["start_date"]) -> MetaOapg.properties.start_date: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["account_range_length", "bank_id", "billing_ica", "bin", "brand_product_code", "card_brand", "card_category", "card_product_type", "country", "currency", "ica_bid", "pan_utilization", "partner_id", "processor", "bin_status", "creation_time", "digital_wallet_active", "end_date", "id", "is_tokenization_enabled", "last_modified_time", "physical_card_format", "start_date", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["account_range_length"]) -> MetaOapg.properties.account_range_length: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["bank_id"]) -> MetaOapg.properties.bank_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["billing_ica"]) -> MetaOapg.properties.billing_ica: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["bin"]) -> MetaOapg.properties.bin: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["brand_product_code"]) -> 'BrandProductCode': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["card_brand"]) -> 'CardBrand': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["card_category"]) -> 'CardCategory': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["card_product_type"]) -> 'CardProductType': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["country"]) -> 'CountryCode': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["currency"]) -> 'CurrencyCode': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["ica_bid"]) -> MetaOapg.properties.ica_bid: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["pan_utilization"]) -> MetaOapg.properties.pan_utilization: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["partner_id"]) -> MetaOapg.properties.partner_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["processor"]) -> MetaOapg.properties.processor: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["bin_status"]) -> typing.Union['BinStatus', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["creation_time"]) -> typing.Union[MetaOapg.properties.creation_time, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["digital_wallet_active"]) -> typing.Union[MetaOapg.properties.digital_wallet_active, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["end_date"]) -> typing.Union[MetaOapg.properties.end_date, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> typing.Union[MetaOapg.properties.id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["is_tokenization_enabled"]) -> typing.Union[MetaOapg.properties.is_tokenization_enabled, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["last_modified_time"]) -> typing.Union[MetaOapg.properties.last_modified_time, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["physical_card_format"]) -> typing.Union['PhysicalCardFormat', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["start_date"]) -> typing.Union[MetaOapg.properties.start_date, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["account_range_length", "bank_id", "billing_ica", "bin", "brand_product_code", "card_brand", "card_category", "card_product_type", "country", "currency", "ica_bid", "pan_utilization", "partner_id", "processor", "bin_status", "creation_time", "digital_wallet_active", "end_date", "id", "is_tokenization_enabled", "last_modified_time", "physical_card_format", "start_date", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        country: 'CountryCode',
        ica_bid: typing.Union[MetaOapg.properties.ica_bid, str, ],
        billing_ica: typing.Union[MetaOapg.properties.billing_ica, str, ],
        bin: typing.Union[MetaOapg.properties.bin, str, ],
        card_category: 'CardCategory',
        brand_product_code: 'BrandProductCode',
        pan_utilization: typing.Union[MetaOapg.properties.pan_utilization, decimal.Decimal, int, ],
        processor: typing.Union[MetaOapg.properties.processor, str, ],
        account_range_length: typing.Union[MetaOapg.properties.account_range_length, decimal.Decimal, int, ],
        partner_id: typing.Union[MetaOapg.properties.partner_id, decimal.Decimal, int, ],
        bank_id: typing.Union[MetaOapg.properties.bank_id, decimal.Decimal, int, ],
        card_brand: 'CardBrand',
        currency: 'CurrencyCode',
        card_product_type: 'CardProductType',
        bin_status: typing.Union['BinStatus', schemas.Unset] = schemas.unset,
        creation_time: typing.Union[MetaOapg.properties.creation_time, str, datetime, schemas.Unset] = schemas.unset,
        digital_wallet_active: typing.Union[MetaOapg.properties.digital_wallet_active, bool, schemas.Unset] = schemas.unset,
        end_date: typing.Union[MetaOapg.properties.end_date, str, datetime, schemas.Unset] = schemas.unset,
        id: typing.Union[MetaOapg.properties.id, str, uuid.UUID, schemas.Unset] = schemas.unset,
        is_tokenization_enabled: typing.Union[MetaOapg.properties.is_tokenization_enabled, bool, schemas.Unset] = schemas.unset,
        last_modified_time: typing.Union[MetaOapg.properties.last_modified_time, str, datetime, schemas.Unset] = schemas.unset,
        physical_card_format: typing.Union['PhysicalCardFormat', schemas.Unset] = schemas.unset,
        start_date: typing.Union[MetaOapg.properties.start_date, str, datetime, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'Bin':
        return super().__new__(
            cls,
            *_args,
            country=country,
            ica_bid=ica_bid,
            billing_ica=billing_ica,
            bin=bin,
            card_category=card_category,
            brand_product_code=brand_product_code,
            pan_utilization=pan_utilization,
            processor=processor,
            account_range_length=account_range_length,
            partner_id=partner_id,
            bank_id=bank_id,
            card_brand=card_brand,
            currency=currency,
            card_product_type=card_product_type,
            bin_status=bin_status,
            creation_time=creation_time,
            digital_wallet_active=digital_wallet_active,
            end_date=end_date,
            id=id,
            is_tokenization_enabled=is_tokenization_enabled,
            last_modified_time=last_modified_time,
            physical_card_format=physical_card_format,
            start_date=start_date,
            _configuration=_configuration,
            **kwargs,
        )

from synctera_client.model.bin_status import BinStatus
from synctera_client.model.brand_product_code import BrandProductCode
from synctera_client.model.card_brand import CardBrand
from synctera_client.model.card_category import CardCategory
from synctera_client.model.card_product_type import CardProductType
from synctera_client.model.country_code import CountryCode
from synctera_client.model.currency_code import CurrencyCode
from synctera_client.model.physical_card_format import PhysicalCardFormat
